/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.Factory;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import java.util.ArrayList;

public class MesgFilter
implements MesgListener,
MesgDefinitionListener {
    private ArrayList<MesgListener> mesgListeners = new ArrayList();
    private ArrayList<MesgDefinitionListener> mesgDefListeners = new ArrayList();
    private ArrayList<String> mesgDefinitionsToOutput;
    private ArrayList<String> mesgToOutput;
    private boolean outputMesgDefinitions = true;
    private boolean outputMesg = true;

    public void addListener(MesgListener mesgListener) {
        if (mesgListener != null && !this.mesgListeners.contains(mesgListener)) {
            this.mesgListeners.add(mesgListener);
        }
    }

    public void addListener(MesgDefinitionListener mesgDefinitionListener) {
        if (mesgDefinitionListener != null && !this.mesgDefListeners.contains(mesgDefinitionListener)) {
            this.mesgDefListeners.add(mesgDefinitionListener);
        }
    }

    public void setMesgDefinitionsToOutput(ArrayList<String> arrayList) {
        this.mesgDefinitionsToOutput = arrayList;
        for (String string : this.mesgDefinitionsToOutput) {
            if (!string.matches("^none$")) continue;
            this.outputMesgDefinitions = false;
        }
    }

    public void setDataMessagesToOutput(ArrayList<String> arrayList) {
        this.mesgToOutput = arrayList;
        for (String string : this.mesgToOutput) {
            if (!string.matches("^none$")) continue;
            this.outputMesg = false;
        }
    }

    @Override
    public void onMesgDefinition(MesgDefinition mesgDefinition) {
        boolean bl = true;
        Mesg mesg = Factory.createMesg(mesgDefinition.getNum());
        if (!this.outputMesgDefinitions) {
            bl = false;
        } else if (!this.mesgDefinitionsToOutput.isEmpty()) {
            bl = false;
            for (String object : this.mesgDefinitionsToOutput) {
                if (!object.matches("^" + mesg.getName() + "$")) continue;
                bl = true;
            }
        }
        if (bl) {
            for (MesgDefinitionListener mesgDefinitionListener : this.mesgDefListeners) {
                mesgDefinitionListener.onMesgDefinition(mesgDefinition);
            }
        }
    }

    @Override
    public void onMesg(Mesg mesg) {
        boolean bl = true;
        if (!this.outputMesg) {
            bl = false;
        } else if (!this.mesgToOutput.isEmpty()) {
            bl = false;
            for (String object : this.mesgToOutput) {
                if (!object.matches("^" + mesg.getName() + "$")) continue;
                bl = true;
            }
        }
        if (bl) {
            for (MesgListener mesgListener : this.mesgListeners) {
                mesgListener.onMesg(mesg);
            }
        }
    }
}

