/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.test;

import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgListener;
import com.garmin.fit.test.Test;
import java.util.ArrayList;

public class ActivityFileTimeStampTest
implements Test,
MesgListener {
    private int fileType = 0;
    private String szError = null;
    private ArrayList<Session> SessionList = new ArrayList();
    private float activity_total_timer_time = -1.0f;

    @Override
    public void onMesg(Mesg mesg) {
        Object[] objectArray = this.SessionList.toArray();
        if (this.szError != null) {
            return;
        }
        if (mesg.getName() == "file_id") {
            this.fileType = Integer.parseInt(mesg.getField("type").getValue().toString());
            return;
        }
        if (this.fileType != 4) {
            return;
        }
        Field field = mesg.getField("timestamp");
        if (field == null) {
            this.szError = "\"timestamp\" field does not exist for message: " + mesg.getName();
            return;
        }
        if (mesg.getName() == "session") {
            int n = Integer.parseInt(mesg.getField("timestamp").getValue().toString());
            Session session = new Session(n);
            field = mesg.getField("start_time");
            if (field != null) {
                session.setStartTime(Integer.parseInt(field.getValue().toString()));
            }
            if ((field = mesg.getField("total_elapsed_time")) != null) {
                session.setTotalElapsedTime(Float.valueOf(Float.parseFloat(field.getValue().toString())));
            }
            if ((field = mesg.getField("total_timer_time")) != null) {
                session.setTotalTimerTime(Float.valueOf(Float.parseFloat(field.getValue().toString())));
            }
            this.SessionList.add(session);
            return;
        }
        if (mesg.getName() == "activity") {
            field = mesg.getField("total_timer_time");
            if (field != null) {
                this.activity_total_timer_time = Float.parseFloat(field.getValue().toString());
            }
            return;
        }
        if (this.SessionList.size() == 0) {
            return;
        }
        if (mesg.getName() == "lap") {
            field = mesg.getField("timestamp");
            if (field != null) {
                ((Session)objectArray[this.SessionList.size() - 1]).addLap(Integer.parseInt(field.getValue().toString()));
            }
            if ((field = mesg.getField("start_time")) != null) {
                ((Session)objectArray[this.SessionList.size() - 1]).addStartTime(Integer.parseInt(field.getValue().toString()));
            }
            if ((field = mesg.getField("total_elapsed_time")) != null) {
                ((Session)objectArray[this.SessionList.size() - 1]).addLapTotalElapsedTime(Float.valueOf(Float.parseFloat(field.getValue().toString())));
            }
            if ((field = mesg.getField("total_timer_time")) != null) {
                ((Session)objectArray[this.SessionList.size() - 1]).addLapTotalTimerTime(Float.valueOf(Float.parseFloat(field.getValue().toString())));
            }
        } else if (mesg.getName() == "record" && (field = mesg.getField("timestamp")) != null) {
            ((Session)objectArray[this.SessionList.size() - 1]).addRecord(Integer.parseInt(field.getValue().toString()));
        }
    }

    @Override
    public String getError() {
        float f = 0.0f;
        Object[] objectArray = this.SessionList.toArray();
        if (this.szError != null) {
            return this.szError;
        }
        for (int i = 0; i < this.SessionList.size(); ++i) {
            this.szError = ((Session)objectArray[i]).verifyTimeStamps();
            if (this.szError != null) {
                return this.szError;
            }
            this.szError = ((Session)objectArray[i]).verifyTotalTimes();
            if (this.szError != null) {
                return this.szError;
            }
            this.szError = ((Session)objectArray[i]).verifyRecordTimes();
            if (this.szError != null) {
                return this.szError;
            }
            f += ((Session)objectArray[i]).getTotalTimerTime();
        }
        if (this.activity_total_timer_time != -1.0f && (int)f != (int)this.activity_total_timer_time) {
            return "Activity total timer time: " + this.activity_total_timer_time + " is not equal to sum of sessions' total timer time: " + f;
        }
        return this.szError;
    }

    private class Session {
        private Integer timestamp;
        private Integer start_time;
        private float total_elapsed_time;
        private float total_timer_time;
        private ArrayList<Integer> Laps = new ArrayList();
        private ArrayList<Integer> Lap_start_time = new ArrayList();
        private ArrayList<Float> Lap_total_elapsed_time = new ArrayList();
        private ArrayList<Float> Lap_total_timer_time = new ArrayList();
        private ArrayList<Integer> Records = new ArrayList();

        Session(Integer n) {
            this.timestamp = n;
            this.start_time = 0;
            this.total_elapsed_time = 0.0f;
            this.total_timer_time = 0.0f;
        }

        public void setStartTime(int n) {
            this.start_time = n;
        }

        public void setTotalElapsedTime(Float f) {
            this.total_elapsed_time = f.floatValue();
        }

        public void setTotalTimerTime(Float f) {
            this.total_timer_time = f.floatValue();
        }

        public void addLap(int n) {
            this.Laps.add(n);
        }

        public void addStartTime(int n) {
            this.Lap_start_time.add(n);
        }

        public void addLapTotalElapsedTime(Float f) {
            this.Lap_total_elapsed_time.add(f);
        }

        public void addLapTotalTimerTime(Float f) {
            this.Lap_total_timer_time.add(f);
        }

        public void addRecord(int n) {
            this.Records.add(n);
        }

        public float getTotalTimerTime() {
            return this.total_timer_time;
        }

        public String verifyTimeStamps() {
            int n;
            Object[] objectArray;
            if (this.Laps.size() > 0) {
                objectArray = this.Laps.toArray();
                for (n = 0; n < this.Laps.size(); ++n) {
                    if ((Integer)objectArray[n] <= this.timestamp) continue;
                    return "Timestamp of lap " + n + ": " + (Integer)objectArray[n] + " is greater than timestamp of session: " + this.timestamp;
                }
            }
            if (this.Lap_start_time.size() > 0) {
                objectArray = this.Lap_start_time.toArray();
                for (n = 0; n < this.Lap_start_time.size(); ++n) {
                    if ((Integer)objectArray[n] >= this.start_time) continue;
                    return "Start time of lap " + n + ": " + (Integer)objectArray[n] + " is less than start time of session: " + this.start_time;
                }
            }
            if (this.Records.size() > 0) {
                objectArray = this.Records.toArray();
                for (n = 0; n < this.Records.size(); ++n) {
                    if ((Integer)objectArray[n] <= this.timestamp) continue;
                    return "Timestamp of record " + n + ": " + (Integer)objectArray[n] + " is greater than timestamp of session: " + this.timestamp;
                }
            }
            return null;
        }

        public String verifyTotalTimes() {
            int n;
            Object[] objectArray;
            float f;
            if (this.Lap_total_elapsed_time.size() > 0 && this.total_elapsed_time != 0.0f) {
                f = 0.0f;
                objectArray = this.Lap_total_elapsed_time.toArray();
                for (n = 0; n < this.Lap_total_elapsed_time.size(); ++n) {
                    f += ((Float)objectArray[n]).floatValue();
                }
                if ((int)f != (int)this.total_elapsed_time) {
                    return "Session's total elapsed time: " + this.total_elapsed_time + " is not equal to the sum of the lap's total elapsed time: " + f;
                }
            }
            if (this.Lap_total_timer_time.size() > 0 && this.total_timer_time != 0.0f) {
                f = 0.0f;
                objectArray = this.Lap_total_timer_time.toArray();
                for (n = 0; n < this.Lap_total_timer_time.size(); ++n) {
                    f += ((Float)objectArray[n]).floatValue();
                }
                if ((int)f != (int)this.total_timer_time) {
                    return "Session's total timer time: " + this.total_timer_time + " is not equal to the sum of the lap's total total time: " + f;
                }
            }
            return null;
        }

        public String verifyRecordTimes() {
            if (this.Records.size() > 0) {
                Object[] objectArray = this.Records.toArray();
                for (int i = 0; i < this.Records.size(); ++i) {
                    if ((Integer)objectArray[i] < this.start_time) {
                        return "Timestamp of record " + i + ": " + (Integer)objectArray[i] + " is less than start time of session: " + this.start_time;
                    }
                    if (!((float)((Integer)objectArray[i]).intValue() > (float)this.start_time.intValue() + this.total_elapsed_time)) continue;
                    return "Timestamp of record " + i + ": " + (Integer)objectArray[i] + " is greater than start time of session + session duration: " + ((float)this.start_time.intValue() + this.total_elapsed_time);
                }
            }
            return null;
        }
    }
}

