////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Dynastream Innovations Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2015 Dynastream Innovations Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 16.10Release
// Tag = development-akw-16.10.00-0
////////////////////////////////////////////////////////////////////////////////


package com.garmin.fit;


public class AccelerometerDataMesg extends Mesg {

   protected static final	Mesg accelerometerDataMesg;
   static {         
      // accelerometer_data   
      accelerometerDataMesg = new Mesg("accelerometer_data", MesgNum.ACCELEROMETER_DATA);
      accelerometerDataMesg.addField(new Field("timestamp", 253, 134, 1, 0, "s", false));
      
      accelerometerDataMesg.addField(new Field("timestamp_ms", 0, 132, 1, 0, "ms", false));
      
      accelerometerDataMesg.addField(new Field("sample_time_offset", 1, 132, 1, 0, "ms", false));
      
      accelerometerDataMesg.addField(new Field("accel_x", 2, 132, 1, 0, "counts", false));
      
      accelerometerDataMesg.addField(new Field("accel_y", 3, 132, 1, 0, "counts", false));
      
      accelerometerDataMesg.addField(new Field("accel_z", 4, 132, 1, 0, "counts", false));
      
      accelerometerDataMesg.addField(new Field("calibrated_accel_x", 5, 136, 1, 0, "g", false));
      
      accelerometerDataMesg.addField(new Field("calibrated_accel_y", 6, 136, 1, 0, "g", false));
      
      accelerometerDataMesg.addField(new Field("calibrated_accel_z", 7, 136, 1, 0, "g", false));
      
   }

   public AccelerometerDataMesg() {
      super(Factory.createMesg(MesgNum.ACCELEROMETER_DATA));
   }

   public AccelerometerDataMesg(final Mesg mesg) {
      super(mesg);
   }


   /**
    * Get timestamp field
    * Units: s
    * Comment: Whole second part of the timestamp
    *
    * @return timestamp
    */
   public DateTime getTimestamp() {
      return timestampToDateTime(getFieldLongValue(253, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD));
   }

   /**
    * Set timestamp field
    * Units: s
    * Comment: Whole second part of the timestamp
    *
    * @param timestamp
    */
   public void setTimestamp(DateTime timestamp) {
      setFieldValue(253, 0, timestamp.getTimestamp(), Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get timestamp_ms field
    * Units: ms
    * Comment: Millisecond part of the timestamp.
    *
    * @return timestamp_ms
    */
   public Integer getTimestampMs() {
      return getFieldIntegerValue(0, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set timestamp_ms field
    * Units: ms
    * Comment: Millisecond part of the timestamp.
    *
    * @param timestampMs
    */
   public void setTimestampMs(Integer timestampMs) {
      setFieldValue(0, 0, timestampMs, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of sample_time_offset
    */
   public int getNumSampleTimeOffset() {
      return getNumFieldValues(1, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get sample_time_offset field
    * Units: ms
    * Comment: Each time in the array describes the time at which the accelerometer sample with the corrosponding index was taken. Limited to 30 samples in each message. The samples may span across seconds. Array size must match the number of samples in accel_x and accel_y and accel_z
    *
    * @param index of sample_time_offset
    * @return sample_time_offset
    */
   public Integer getSampleTimeOffset(int index) {
      return getFieldIntegerValue(1, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set sample_time_offset field
    * Units: ms
    * Comment: Each time in the array describes the time at which the accelerometer sample with the corrosponding index was taken. Limited to 30 samples in each message. The samples may span across seconds. Array size must match the number of samples in accel_x and accel_y and accel_z
    *
    * @param index of sample_time_offset
    * @param sampleTimeOffset
    */
   public void setSampleTimeOffset(int index, Integer sampleTimeOffset) {
      setFieldValue(1, index, sampleTimeOffset, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of accel_x
    */
   public int getNumAccelX() {
      return getNumFieldValues(2, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get accel_x field
    * Units: counts
    * Comment: These are the raw ADC reading. Maximum number of samples is 30 in each message. The samples may span across seconds. A conversion will need to be done on this data once read.
    *
    * @param index of accel_x
    * @return accel_x
    */
   public Integer getAccelX(int index) {
      return getFieldIntegerValue(2, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set accel_x field
    * Units: counts
    * Comment: These are the raw ADC reading. Maximum number of samples is 30 in each message. The samples may span across seconds. A conversion will need to be done on this data once read.
    *
    * @param index of accel_x
    * @param accelX
    */
   public void setAccelX(int index, Integer accelX) {
      setFieldValue(2, index, accelX, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of accel_y
    */
   public int getNumAccelY() {
      return getNumFieldValues(3, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get accel_y field
    * Units: counts
    * Comment: These are the raw ADC reading. Maximum number of samples is 30 in each message. The samples may span across seconds. A conversion will need to be done on this data once read.
    *
    * @param index of accel_y
    * @return accel_y
    */
   public Integer getAccelY(int index) {
      return getFieldIntegerValue(3, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set accel_y field
    * Units: counts
    * Comment: These are the raw ADC reading. Maximum number of samples is 30 in each message. The samples may span across seconds. A conversion will need to be done on this data once read.
    *
    * @param index of accel_y
    * @param accelY
    */
   public void setAccelY(int index, Integer accelY) {
      setFieldValue(3, index, accelY, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of accel_z
    */
   public int getNumAccelZ() {
      return getNumFieldValues(4, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get accel_z field
    * Units: counts
    * Comment: These are the raw ADC reading. Maximum number of samples is 30 in each message. The samples may span across seconds. A conversion will need to be done on this data once read.
    *
    * @param index of accel_z
    * @return accel_z
    */
   public Integer getAccelZ(int index) {
      return getFieldIntegerValue(4, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set accel_z field
    * Units: counts
    * Comment: These are the raw ADC reading. Maximum number of samples is 30 in each message. The samples may span across seconds. A conversion will need to be done on this data once read.
    *
    * @param index of accel_z
    * @param accelZ
    */
   public void setAccelZ(int index, Integer accelZ) {
      setFieldValue(4, index, accelZ, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of calibrated_accel_x
    */
   public int getNumCalibratedAccelX() {
      return getNumFieldValues(5, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get calibrated_accel_x field
    * Units: g
    * Comment: Calibrated accel reading
    *
    * @param index of calibrated_accel_x
    * @return calibrated_accel_x
    */
   public Float getCalibratedAccelX(int index) {
      return getFieldFloatValue(5, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set calibrated_accel_x field
    * Units: g
    * Comment: Calibrated accel reading
    *
    * @param index of calibrated_accel_x
    * @param calibratedAccelX
    */
   public void setCalibratedAccelX(int index, Float calibratedAccelX) {
      setFieldValue(5, index, calibratedAccelX, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of calibrated_accel_y
    */
   public int getNumCalibratedAccelY() {
      return getNumFieldValues(6, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get calibrated_accel_y field
    * Units: g
    * Comment: Calibrated accel reading
    *
    * @param index of calibrated_accel_y
    * @return calibrated_accel_y
    */
   public Float getCalibratedAccelY(int index) {
      return getFieldFloatValue(6, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set calibrated_accel_y field
    * Units: g
    * Comment: Calibrated accel reading
    *
    * @param index of calibrated_accel_y
    * @param calibratedAccelY
    */
   public void setCalibratedAccelY(int index, Float calibratedAccelY) {
      setFieldValue(6, index, calibratedAccelY, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of calibrated_accel_z
    */
   public int getNumCalibratedAccelZ() {
      return getNumFieldValues(7, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get calibrated_accel_z field
    * Units: g
    * Comment: Calibrated accel reading
    *
    * @param index of calibrated_accel_z
    * @return calibrated_accel_z
    */
   public Float getCalibratedAccelZ(int index) {
      return getFieldFloatValue(7, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set calibrated_accel_z field
    * Units: g
    * Comment: Calibrated accel reading
    *
    * @param index of calibrated_accel_z
    * @param calibratedAccelZ
    */
   public void setCalibratedAccelZ(int index, Float calibratedAccelZ) {
      setFieldValue(7, index, calibratedAccelZ, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

}
