////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Dynastream Innovations Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2015 Dynastream Innovations Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 16.10Release
// Tag = development-akw-16.10.00-0
////////////////////////////////////////////////////////////////////////////////


package com.garmin.fit;


public class AviationAttitudeMesg extends Mesg {

   protected static final	Mesg aviationAttitudeMesg;
   static {         
      // aviation_attitude   
      aviationAttitudeMesg = new Mesg("aviation_attitude", MesgNum.AVIATION_ATTITUDE);
      aviationAttitudeMesg.addField(new Field("timestamp", 253, 134, 1, 0, "s", false));
      
      aviationAttitudeMesg.addField(new Field("timestamp_ms", 0, 132, 1, 0, "ms", false));
      
      aviationAttitudeMesg.addField(new Field("system_time", 1, 134, 1, 0, "ms", false));
      
      aviationAttitudeMesg.addField(new Field("pitch", 2, 131, 10430.38, 0, "radians", false));
      
      aviationAttitudeMesg.addField(new Field("roll", 3, 131, 10430.38, 0, "radians", false));
      
      aviationAttitudeMesg.addField(new Field("accel_lateral", 4, 131, 100, 0, "m/s^2", false));
      
      aviationAttitudeMesg.addField(new Field("accel_normal", 5, 131, 100, 0, "m/s^2", false));
      
      aviationAttitudeMesg.addField(new Field("turn_rate", 6, 131, 1024, 0, "radians/second", false));
      
      aviationAttitudeMesg.addField(new Field("stage", 7, 0, 1, 0, "", false));
      
      aviationAttitudeMesg.addField(new Field("attitude_stage_complete", 8, 2, 1, 0, "%", false));
      
      aviationAttitudeMesg.addField(new Field("track", 9, 132, 10430.38, 0, "radians", false));
      
      aviationAttitudeMesg.addField(new Field("validity", 10, 132, 1, 0, "", false));
      
   }

   public AviationAttitudeMesg() {
      super(Factory.createMesg(MesgNum.AVIATION_ATTITUDE));
   }

   public AviationAttitudeMesg(final Mesg mesg) {
      super(mesg);
   }


   /**
    * Get timestamp field
    * Units: s
    * Comment: Timestamp message was output
    *
    * @return timestamp
    */
   public DateTime getTimestamp() {
      return timestampToDateTime(getFieldLongValue(253, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD));
   }

   /**
    * Set timestamp field
    * Units: s
    * Comment: Timestamp message was output
    *
    * @param timestamp
    */
   public void setTimestamp(DateTime timestamp) {
      setFieldValue(253, 0, timestamp.getTimestamp(), Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get timestamp_ms field
    * Units: ms
    * Comment: Fractional part of timestamp, added to timestamp
    *
    * @return timestamp_ms
    */
   public Integer getTimestampMs() {
      return getFieldIntegerValue(0, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set timestamp_ms field
    * Units: ms
    * Comment: Fractional part of timestamp, added to timestamp
    *
    * @param timestampMs
    */
   public void setTimestampMs(Integer timestampMs) {
      setFieldValue(0, 0, timestampMs, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of system_time
    */
   public int getNumSystemTime() {
      return getNumFieldValues(1, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get system_time field
    * Units: ms
    * Comment: System time associated with sample expressed in ms.
    *
    * @param index of system_time
    * @return system_time
    */
   public Long getSystemTime(int index) {
      return getFieldLongValue(1, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set system_time field
    * Units: ms
    * Comment: System time associated with sample expressed in ms.
    *
    * @param index of system_time
    * @param systemTime
    */
   public void setSystemTime(int index, Long systemTime) {
      setFieldValue(1, index, systemTime, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of pitch
    */
   public int getNumPitch() {
      return getNumFieldValues(2, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get pitch field
    * Units: radians
    * Comment: Range -PI/2 to +PI/2
    *
    * @param index of pitch
    * @return pitch
    */
   public Float getPitch(int index) {
      return getFieldFloatValue(2, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set pitch field
    * Units: radians
    * Comment: Range -PI/2 to +PI/2
    *
    * @param index of pitch
    * @param pitch
    */
   public void setPitch(int index, Float pitch) {
      setFieldValue(2, index, pitch, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of roll
    */
   public int getNumRoll() {
      return getNumFieldValues(3, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get roll field
    * Units: radians
    * Comment: Range -PI to +PI
    *
    * @param index of roll
    * @return roll
    */
   public Float getRoll(int index) {
      return getFieldFloatValue(3, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set roll field
    * Units: radians
    * Comment: Range -PI to +PI
    *
    * @param index of roll
    * @param roll
    */
   public void setRoll(int index, Float roll) {
      setFieldValue(3, index, roll, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of accel_lateral
    */
   public int getNumAccelLateral() {
      return getNumFieldValues(4, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get accel_lateral field
    * Units: m/s^2
    * Comment: Range -78.4 to +78.4 (-8 Gs to 8 Gs)
    *
    * @param index of accel_lateral
    * @return accel_lateral
    */
   public Float getAccelLateral(int index) {
      return getFieldFloatValue(4, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set accel_lateral field
    * Units: m/s^2
    * Comment: Range -78.4 to +78.4 (-8 Gs to 8 Gs)
    *
    * @param index of accel_lateral
    * @param accelLateral
    */
   public void setAccelLateral(int index, Float accelLateral) {
      setFieldValue(4, index, accelLateral, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of accel_normal
    */
   public int getNumAccelNormal() {
      return getNumFieldValues(5, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get accel_normal field
    * Units: m/s^2
    * Comment: Range -78.4 to +78.4 (-8 Gs to 8 Gs)
    *
    * @param index of accel_normal
    * @return accel_normal
    */
   public Float getAccelNormal(int index) {
      return getFieldFloatValue(5, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set accel_normal field
    * Units: m/s^2
    * Comment: Range -78.4 to +78.4 (-8 Gs to 8 Gs)
    *
    * @param index of accel_normal
    * @param accelNormal
    */
   public void setAccelNormal(int index, Float accelNormal) {
      setFieldValue(5, index, accelNormal, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of turn_rate
    */
   public int getNumTurnRate() {
      return getNumFieldValues(6, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get turn_rate field
    * Units: radians/second
    * Comment: Range -8.727 to +8.727 (-500 degs/sec to +500 degs/sec)
    *
    * @param index of turn_rate
    * @return turn_rate
    */
   public Float getTurnRate(int index) {
      return getFieldFloatValue(6, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set turn_rate field
    * Units: radians/second
    * Comment: Range -8.727 to +8.727 (-500 degs/sec to +500 degs/sec)
    *
    * @param index of turn_rate
    * @param turnRate
    */
   public void setTurnRate(int index, Float turnRate) {
      setFieldValue(6, index, turnRate, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of stage
    */
   public int getNumStage() {
      return getNumFieldValues(7, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get stage field
    *
    * @param index of stage
    * @return stage
    */
   public AttitudeStage getStage(int index) {
      Short value = getFieldShortValue(7, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return AttitudeStage.getByValue(value);
   }

   /**
    * Set stage field
    *
    * @param index of stage
    * @param stage
    */
   public void setStage(int index, AttitudeStage stage) {
      setFieldValue(7, index, stage.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of attitude_stage_complete
    */
   public int getNumAttitudeStageComplete() {
      return getNumFieldValues(8, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get attitude_stage_complete field
    * Units: %
    * Comment: The percent complete of the current attitude stage.  Set to 0 for attitude stages 0, 1 and 2 and to 100 for attitude stage 3 by AHRS modules that do not support it.  Range - 100
    *
    * @param index of attitude_stage_complete
    * @return attitude_stage_complete
    */
   public Short getAttitudeStageComplete(int index) {
      return getFieldShortValue(8, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set attitude_stage_complete field
    * Units: %
    * Comment: The percent complete of the current attitude stage.  Set to 0 for attitude stages 0, 1 and 2 and to 100 for attitude stage 3 by AHRS modules that do not support it.  Range - 100
    *
    * @param index of attitude_stage_complete
    * @param attitudeStageComplete
    */
   public void setAttitudeStageComplete(int index, Short attitudeStageComplete) {
      setFieldValue(8, index, attitudeStageComplete, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of track
    */
   public int getNumTrack() {
      return getNumFieldValues(9, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get track field
    * Units: radians
    * Comment: Track Angle/Heading Range 0 - 2pi
    *
    * @param index of track
    * @return track
    */
   public Float getTrack(int index) {
      return getFieldFloatValue(9, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set track field
    * Units: radians
    * Comment: Track Angle/Heading Range 0 - 2pi
    *
    * @param index of track
    * @param track
    */
   public void setTrack(int index, Float track) {
      setFieldValue(9, index, track, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of validity
    */
   public int getNumValidity() {
      return getNumFieldValues(10, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get validity field
    *
    * @param index of validity
    * @return validity
    */
   public Integer getValidity(int index) {
      return getFieldIntegerValue(10, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set validity field
    *
    * @param index of validity
    * @param validity
    */
   public void setValidity(int index, Integer validity) {
      setFieldValue(10, index, validity, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

}
