////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Dynastream Innovations Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2015 Dynastream Innovations Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 16.10Release
// Tag = development-akw-16.10.00-0
////////////////////////////////////////////////////////////////////////////////


package com.garmin.fit.csv;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.ArrayList;
import com.garmin.fit.*;

public class CSVReader {
   private static final Pattern csvPattern = Pattern.compile("\"([^\"]+?)\",?|([^,]+),?|,");

   static public boolean read(final InputStream in, final MesgListener mesgListener, final MesgDefinitionListener mesgDefinitionListener) {
      try {
         BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
         ArrayList<String> cells;
         int typeCol = -1;
         int localNumCol = -1;
         int mesgCol = -1;
         int fieldCol = -1;
         int lineNum = 1;
         String line;

         line = reader.readLine();
         // Strips the UTF-8 BOM if it exists
         line = stripUTF8Bom(line);
         cells = readCells(line);

         for (int col = 0; col < cells.size(); col++) {
            if (cells.get(col).equals("Type")) {
               typeCol = col;
            } else if (cells.get(col).equals("Local Number")) {
               localNumCol = col;
            } else if (cells.get(col).equals("Message")) {
               mesgCol = col;
            } else if (cells.get(col).equals("Field 1")) {
               fieldCol = col;
               break;
            }
         }

         while ((line = reader.readLine()) != null) {
            int cellIndex;
            Mesg mesg;
            MesgDefinition mesgDef = null;

            cells = readCells(line);
            lineNum++;

            if ((cells.size() <= typeCol) || (cells.size() <= localNumCol) || (cells.size() <= mesgCol))
               continue; // Ignore empty lines.

            mesg = Factory.createMesg(cells.get(mesgCol));

            if (mesg.getNum() == MesgNum.INVALID) {
               System.err.printf("CSVReader.read(): Error on line %d - Unknown message \"%s\".\n", lineNum, mesg.getName());
               return false;
            }

            if (localNumCol >= 0)
               mesg.setLocalNum(Integer.valueOf(cells.get(localNumCol)));

            if ((typeCol >= 0) && cells.get(typeCol).equals("Definition"))
               mesgDef = new MesgDefinition(mesg);

            cellIndex = fieldCol;

            while ((cellIndex + 2) <= cells.size()) {
               String fieldOrSubFieldName = cells.get(cellIndex++);
               ArrayList<String> values = readValues(cells.get(cellIndex++));
               Field field;
               FieldDefinition fieldDef = null;

               cellIndex++; // ignore units

               if (fieldOrSubFieldName == null)
                  break; // Blank cell.

               field = Factory.createField(mesg.getName(), fieldOrSubFieldName);

               if (field.getNum() == Fit.FIELD_NUM_INVALID) {
                  System.err.printf("CSVReader.read(): Error on line %d - Unknown field \"%s\" in message \"%s\".\n", lineNum, fieldOrSubFieldName, mesg.getName());
                  return false;
               }

               if (values == null)
                  break;

               if (mesgDef != null)
                  fieldDef = new FieldDefinition(field);

               for (String value : values) {
                  try {
                  // Value is too large to represent as a normal double and is stored in a string.
                  // Test for presence of "E" as Java will convert this number to scientific notation.
                  if ((Double.valueOf(value).toString().contains("E")) && (field.getType() == Fit.BASE_TYPE_STRING)) {
                     throw new java.lang.NumberFormatException();
                  }
                     field.setValue(field.getNumValues(), Double.valueOf(value), fieldOrSubFieldName);
                     if (fieldDef != null)
                        fieldDef.setSize(Integer.valueOf(value) * Fit.baseTypeSizes[field.getType() & Fit.BASE_TYPE_NUM_MASK]);

                  } catch (java.lang.NumberFormatException e) {
                     field.setValue(field.getNumValues(), value, fieldOrSubFieldName);
                  }
               }

               mesg.addField(field);
               if (mesgDef != null)
                  mesgDef.addField(fieldDef);
            }

            if (mesgDef != null) {
               if (mesgDefinitionListener != null)
                  mesgDefinitionListener.onMesgDefinition(mesgDef);
            } else {
               if (mesgListener != null)
                  mesgListener.onMesg(mesg);
            }
         }
      } catch (java.io.IOException e) {
         throw new RuntimeException(e);
      }

      return true;
   }

   static private ArrayList<String> readCells(String line) {
      ArrayList<String> list = new ArrayList<String>();
      Matcher m;

      if (line == null)
         return null;

      m = csvPattern.matcher(line);

      while (m.find()) {
         String match = m.group();

         if (match == null)
            break;

         if (match.endsWith(",")) { // trim trailing ,
            match = match.substring(0, match.length() - 1);
         }

         if (match.startsWith("\"")) { // assume also ends with
            match = match.substring(1, match.length() - 1);
         }

         if (match.length() == 0)
            match = null;

         list.add(match);
      }

      return list;
   }

   static private ArrayList<String> readValues(String cell) {
      ArrayList<String> list = new ArrayList<String>();
      String value;
      int i = 0;

      if (cell == null)
         return null;

      value = "";
      while (i < cell.length()) {
         if (cell.charAt(i) == '|') {
            list.add(value);
            value = "";
         } else {
            value += cell.charAt(i);
         }
         i++;
      }

      if (value.length() > 0)
         list.add(value);

      return list;
   }

   static private String stripUTF8Bom(String input) {

      byte[] beforeStrip = input.getBytes(Charset.forName("UTF-8"));
      if (beforeStrip[0] == Fit.UTF8_BOM_BYTE_1 && beforeStrip[1] == Fit.UTF8_BOM_BYTE_2 && beforeStrip[2] == Fit.UTF8_BOM_BYTE_3) {
         byte[] afterStrip = new byte[beforeStrip.length-Fit.UTF8_NUM_BOM_BYTES];
         System.arraycopy(beforeStrip, Fit.UTF8_NUM_BOM_BYTES, afterStrip, 0, afterStrip.length);

         try {
            input = new String(afterStrip, "UTF-8");
         } catch (UnsupportedEncodingException e) {
         }
      }

       return input;
   }
}
