////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Dynastream Innovations Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2015 Dynastream Innovations Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 16.10Release
// Tag = development-akw-16.10.00-0
////////////////////////////////////////////////////////////////////////////////


package com.garmin.fit;


public class LapMesg extends Mesg implements MesgWithEvent {

   protected static final	Mesg lapMesg;
   static {            
      int field_index = 0;
      int subfield_index = 0;         
      // lap   
      lapMesg = new Mesg("lap", MesgNum.LAP);
      lapMesg.addField(new Field("message_index", 254, 132, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("timestamp", 253, 134, 1, 0, "s", false));
      field_index++;
      lapMesg.addField(new Field("event", 0, 0, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("event_type", 1, 0, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("start_time", 2, 134, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("start_position_lat", 3, 133, 1, 0, "semicircles", false));
      field_index++;
      lapMesg.addField(new Field("start_position_long", 4, 133, 1, 0, "semicircles", false));
      field_index++;
      lapMesg.addField(new Field("end_position_lat", 5, 133, 1, 0, "semicircles", false));
      field_index++;
      lapMesg.addField(new Field("end_position_long", 6, 133, 1, 0, "semicircles", false));
      field_index++;
      lapMesg.addField(new Field("total_elapsed_time", 7, 134, 1000, 0, "s", false));
      field_index++;
      lapMesg.addField(new Field("total_timer_time", 8, 134, 1000, 0, "s", false));
      field_index++;
      lapMesg.addField(new Field("total_distance", 9, 134, 100, 0, "m", false));
      field_index++;
      lapMesg.addField(new Field("total_cycles", 10, 134, 1, 0, "cycles", false));
      subfield_index = 0;
      lapMesg.fields.get(field_index).subFields.add(new SubField("total_strides", 134, 1, 0, "strides"));
      lapMesg.fields.get(field_index).subFields.get(subfield_index).addMap(25, 1);
      lapMesg.fields.get(field_index).subFields.get(subfield_index).addMap(25, 11);
      subfield_index++;
      field_index++;
      lapMesg.addField(new Field("total_calories", 11, 132, 1, 0, "kcal", false));
      field_index++;
      lapMesg.addField(new Field("total_fat_calories", 12, 132, 1, 0, "kcal", false));
      field_index++;
      lapMesg.addField(new Field("avg_speed", 13, 132, 1000, 0, "m/s", false)); 
      lapMesg.fields.get(field_index).components.add(new FieldComponent(110, false, 16, 1000, 0)); // enhanced_avg_speed
      field_index++;
      lapMesg.addField(new Field("max_speed", 14, 132, 1000, 0, "m/s", false)); 
      lapMesg.fields.get(field_index).components.add(new FieldComponent(111, false, 16, 1000, 0)); // enhanced_max_speed
      field_index++;
      lapMesg.addField(new Field("avg_heart_rate", 15, 2, 1, 0, "bpm", false));
      field_index++;
      lapMesg.addField(new Field("max_heart_rate", 16, 2, 1, 0, "bpm", false));
      field_index++;
      lapMesg.addField(new Field("avg_cadence", 17, 2, 1, 0, "rpm", false));
      subfield_index = 0;
      lapMesg.fields.get(field_index).subFields.add(new SubField("avg_running_cadence", 2, 1, 0, "strides/min"));
      lapMesg.fields.get(field_index).subFields.get(subfield_index).addMap(25, 1);
      subfield_index++;
      field_index++;
      lapMesg.addField(new Field("max_cadence", 18, 2, 1, 0, "rpm", false));
      subfield_index = 0;
      lapMesg.fields.get(field_index).subFields.add(new SubField("max_running_cadence", 2, 1, 0, "strides/min"));
      lapMesg.fields.get(field_index).subFields.get(subfield_index).addMap(25, 1);
      subfield_index++;
      field_index++;
      lapMesg.addField(new Field("avg_power", 19, 132, 1, 0, "watts", false));
      field_index++;
      lapMesg.addField(new Field("max_power", 20, 132, 1, 0, "watts", false));
      field_index++;
      lapMesg.addField(new Field("total_ascent", 21, 132, 1, 0, "m", false));
      field_index++;
      lapMesg.addField(new Field("total_descent", 22, 132, 1, 0, "m", false));
      field_index++;
      lapMesg.addField(new Field("intensity", 23, 0, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("lap_trigger", 24, 0, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("sport", 25, 0, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("event_group", 26, 2, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("num_lengths", 32, 132, 1, 0, "lengths", false));
      field_index++;
      lapMesg.addField(new Field("normalized_power", 33, 132, 1, 0, "watts", false));
      field_index++;
      lapMesg.addField(new Field("left_right_balance", 34, 132, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("first_length_index", 35, 132, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("avg_stroke_distance", 37, 132, 100, 0, "m", false));
      field_index++;
      lapMesg.addField(new Field("swim_stroke", 38, 0, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("sub_sport", 39, 0, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("num_active_lengths", 40, 132, 1, 0, "lengths", false));
      field_index++;
      lapMesg.addField(new Field("total_work", 41, 134, 1, 0, "J", false));
      field_index++;
      lapMesg.addField(new Field("avg_altitude", 42, 132, 5, 500, "m", false)); 
      lapMesg.fields.get(field_index).components.add(new FieldComponent(112, false, 16, 5, 500)); // enhanced_avg_altitude
      field_index++;
      lapMesg.addField(new Field("max_altitude", 43, 132, 5, 500, "m", false)); 
      lapMesg.fields.get(field_index).components.add(new FieldComponent(114, false, 16, 5, 500)); // enhanced_max_altitude
      field_index++;
      lapMesg.addField(new Field("gps_accuracy", 44, 2, 1, 0, "m", false));
      field_index++;
      lapMesg.addField(new Field("avg_grade", 45, 131, 100, 0, "%", false));
      field_index++;
      lapMesg.addField(new Field("avg_pos_grade", 46, 131, 100, 0, "%", false));
      field_index++;
      lapMesg.addField(new Field("avg_neg_grade", 47, 131, 100, 0, "%", false));
      field_index++;
      lapMesg.addField(new Field("max_pos_grade", 48, 131, 100, 0, "%", false));
      field_index++;
      lapMesg.addField(new Field("max_neg_grade", 49, 131, 100, 0, "%", false));
      field_index++;
      lapMesg.addField(new Field("avg_temperature", 50, 1, 1, 0, "C", false));
      field_index++;
      lapMesg.addField(new Field("max_temperature", 51, 1, 1, 0, "C", false));
      field_index++;
      lapMesg.addField(new Field("total_moving_time", 52, 134, 1000, 0, "s", false));
      field_index++;
      lapMesg.addField(new Field("avg_pos_vertical_speed", 53, 131, 1000, 0, "m/s", false));
      field_index++;
      lapMesg.addField(new Field("avg_neg_vertical_speed", 54, 131, 1000, 0, "m/s", false));
      field_index++;
      lapMesg.addField(new Field("max_pos_vertical_speed", 55, 131, 1000, 0, "m/s", false));
      field_index++;
      lapMesg.addField(new Field("max_neg_vertical_speed", 56, 131, 1000, 0, "m/s", false));
      field_index++;
      lapMesg.addField(new Field("time_in_hr_zone", 57, 134, 1000, 0, "s", false));
      field_index++;
      lapMesg.addField(new Field("time_in_speed_zone", 58, 134, 1000, 0, "s", false));
      field_index++;
      lapMesg.addField(new Field("time_in_cadence_zone", 59, 134, 1000, 0, "s", false));
      field_index++;
      lapMesg.addField(new Field("time_in_power_zone", 60, 134, 1000, 0, "s", false));
      field_index++;
      lapMesg.addField(new Field("repetition_num", 61, 132, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("min_altitude", 62, 132, 5, 500, "m", false)); 
      lapMesg.fields.get(field_index).components.add(new FieldComponent(113, false, 16, 5, 500)); // enhanced_min_altitude
      field_index++;
      lapMesg.addField(new Field("min_heart_rate", 63, 2, 1, 0, "bpm", false));
      field_index++;
      lapMesg.addField(new Field("wkt_step_index", 71, 132, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("opponent_score", 74, 132, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("stroke_count", 75, 132, 1, 0, "counts", false));
      field_index++;
      lapMesg.addField(new Field("zone_count", 76, 132, 1, 0, "counts", false));
      field_index++;
      lapMesg.addField(new Field("avg_vertical_oscillation", 77, 132, 10, 0, "mm", false));
      field_index++;
      lapMesg.addField(new Field("avg_stance_time_percent", 78, 132, 100, 0, "percent", false));
      field_index++;
      lapMesg.addField(new Field("avg_stance_time", 79, 132, 10, 0, "ms", false));
      field_index++;
      lapMesg.addField(new Field("avg_fractional_cadence", 80, 2, 128, 0, "rpm", false));
      field_index++;
      lapMesg.addField(new Field("max_fractional_cadence", 81, 2, 128, 0, "rpm", false));
      field_index++;
      lapMesg.addField(new Field("total_fractional_cycles", 82, 2, 128, 0, "cycles", false));
      field_index++;
      lapMesg.addField(new Field("player_score", 83, 132, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("avg_total_hemoglobin_conc", 84, 132, 100, 0, "g/dL", false));
      field_index++;
      lapMesg.addField(new Field("min_total_hemoglobin_conc", 85, 132, 100, 0, "g/dL", false));
      field_index++;
      lapMesg.addField(new Field("max_total_hemoglobin_conc", 86, 132, 100, 0, "g/dL", false));
      field_index++;
      lapMesg.addField(new Field("avg_saturated_hemoglobin_percent", 87, 132, 10, 0, "%", false));
      field_index++;
      lapMesg.addField(new Field("min_saturated_hemoglobin_percent", 88, 132, 10, 0, "%", false));
      field_index++;
      lapMesg.addField(new Field("max_saturated_hemoglobin_percent", 89, 132, 10, 0, "%", false));
      field_index++;
      lapMesg.addField(new Field("avg_left_torque_effectiveness", 91, 2, 2, 0, "percent", false));
      field_index++;
      lapMesg.addField(new Field("avg_right_torque_effectiveness", 92, 2, 2, 0, "percent", false));
      field_index++;
      lapMesg.addField(new Field("avg_left_pedal_smoothness", 93, 2, 2, 0, "percent", false));
      field_index++;
      lapMesg.addField(new Field("avg_right_pedal_smoothness", 94, 2, 2, 0, "percent", false));
      field_index++;
      lapMesg.addField(new Field("avg_combined_pedal_smoothness", 95, 2, 2, 0, "percent", false));
      field_index++;
      lapMesg.addField(new Field("time_standing", 98, 134, 1000, 0, "s", false));
      field_index++;
      lapMesg.addField(new Field("stand_count", 99, 132, 1, 0, "", false));
      field_index++;
      lapMesg.addField(new Field("avg_left_pco", 100, 1, 1, 0, "mm", false));
      field_index++;
      lapMesg.addField(new Field("avg_right_pco", 101, 1, 1, 0, "mm", false));
      field_index++;
      lapMesg.addField(new Field("avg_left_power_phase", 102, 2, 0.7111111, 0, "degrees", false));
      field_index++;
      lapMesg.addField(new Field("avg_left_power_phase_peak", 103, 2, 0.7111111, 0, "degrees", false));
      field_index++;
      lapMesg.addField(new Field("avg_right_power_phase", 104, 2, 0.7111111, 0, "degrees", false));
      field_index++;
      lapMesg.addField(new Field("avg_right_power_phase_peak", 105, 2, 0.7111111, 0, "degrees", false));
      field_index++;
      lapMesg.addField(new Field("avg_power_position", 106, 132, 1, 0, "watts", false));
      field_index++;
      lapMesg.addField(new Field("max_power_position", 107, 132, 1, 0, "watts", false));
      field_index++;
      lapMesg.addField(new Field("avg_cadence_position", 108, 2, 1, 0, "rpm", false));
      field_index++;
      lapMesg.addField(new Field("max_cadence_position", 109, 2, 1, 0, "rpm", false));
      field_index++;
      lapMesg.addField(new Field("enhanced_avg_speed", 110, 134, 1000, 0, "m/s", false));
      field_index++;
      lapMesg.addField(new Field("enhanced_max_speed", 111, 134, 1000, 0, "m/s", false));
      field_index++;
      lapMesg.addField(new Field("enhanced_avg_altitude", 112, 134, 5, 500, "m", false));
      field_index++;
      lapMesg.addField(new Field("enhanced_min_altitude", 113, 134, 5, 500, "m", false));
      field_index++;
      lapMesg.addField(new Field("enhanced_max_altitude", 114, 134, 5, 500, "m", false));
      field_index++;
      lapMesg.addField(new Field("avg_lev_motor_power", 115, 132, 1, 0, "watts", false));
      field_index++;
      lapMesg.addField(new Field("max_lev_motor_power", 116, 132, 1, 0, "watts", false));
      field_index++;
      lapMesg.addField(new Field("lev_battery_consumption", 117, 2, 2, 0, "percent", false));
      field_index++;
   }

   public LapMesg() {
      super(Factory.createMesg(MesgNum.LAP));
   }

   public LapMesg(final Mesg mesg) {
      super(mesg);
   }


   /**
    * Get message_index field
    *
    * @return message_index
    */
   public Integer getMessageIndex() {
      return getFieldIntegerValue(254, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set message_index field
    *
    * @param messageIndex
    */
   public void setMessageIndex(Integer messageIndex) {
      setFieldValue(254, 0, messageIndex, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get timestamp field
    * Units: s
    * Comment: Lap end time.
    *
    * @return timestamp
    */
   public DateTime getTimestamp() {
      return timestampToDateTime(getFieldLongValue(253, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD));
   }

   /**
    * Set timestamp field
    * Units: s
    * Comment: Lap end time.
    *
    * @param timestamp
    */
   public void setTimestamp(DateTime timestamp) {
      setFieldValue(253, 0, timestamp.getTimestamp(), Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get event field
    *
    * @return event
    */
   public Event getEvent() {
      Short value = getFieldShortValue(0, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return Event.getByValue(value);
   }

   /**
    * Set event field
    *
    * @param event
    */
   public void setEvent(Event event) {
      setFieldValue(0, 0, event.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get event_type field
    *
    * @return event_type
    */
   public EventType getEventType() {
      Short value = getFieldShortValue(1, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return EventType.getByValue(value);
   }

   /**
    * Set event_type field
    *
    * @param eventType
    */
   public void setEventType(EventType eventType) {
      setFieldValue(1, 0, eventType.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get start_time field
    *
    * @return start_time
    */
   public DateTime getStartTime() {
      return timestampToDateTime(getFieldLongValue(2, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD));
   }

   /**
    * Set start_time field
    *
    * @param startTime
    */
   public void setStartTime(DateTime startTime) {
      setFieldValue(2, 0, startTime.getTimestamp(), Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get start_position_lat field
    * Units: semicircles
    *
    * @return start_position_lat
    */
   public Integer getStartPositionLat() {
      return getFieldIntegerValue(3, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set start_position_lat field
    * Units: semicircles
    *
    * @param startPositionLat
    */
   public void setStartPositionLat(Integer startPositionLat) {
      setFieldValue(3, 0, startPositionLat, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get start_position_long field
    * Units: semicircles
    *
    * @return start_position_long
    */
   public Integer getStartPositionLong() {
      return getFieldIntegerValue(4, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set start_position_long field
    * Units: semicircles
    *
    * @param startPositionLong
    */
   public void setStartPositionLong(Integer startPositionLong) {
      setFieldValue(4, 0, startPositionLong, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get end_position_lat field
    * Units: semicircles
    *
    * @return end_position_lat
    */
   public Integer getEndPositionLat() {
      return getFieldIntegerValue(5, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set end_position_lat field
    * Units: semicircles
    *
    * @param endPositionLat
    */
   public void setEndPositionLat(Integer endPositionLat) {
      setFieldValue(5, 0, endPositionLat, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get end_position_long field
    * Units: semicircles
    *
    * @return end_position_long
    */
   public Integer getEndPositionLong() {
      return getFieldIntegerValue(6, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set end_position_long field
    * Units: semicircles
    *
    * @param endPositionLong
    */
   public void setEndPositionLong(Integer endPositionLong) {
      setFieldValue(6, 0, endPositionLong, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_elapsed_time field
    * Units: s
    * Comment: Time (includes pauses)
    *
    * @return total_elapsed_time
    */
   public Float getTotalElapsedTime() {
      return getFieldFloatValue(7, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_elapsed_time field
    * Units: s
    * Comment: Time (includes pauses)
    *
    * @param totalElapsedTime
    */
   public void setTotalElapsedTime(Float totalElapsedTime) {
      setFieldValue(7, 0, totalElapsedTime, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_timer_time field
    * Units: s
    * Comment: Timer Time (excludes pauses)
    *
    * @return total_timer_time
    */
   public Float getTotalTimerTime() {
      return getFieldFloatValue(8, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_timer_time field
    * Units: s
    * Comment: Timer Time (excludes pauses)
    *
    * @param totalTimerTime
    */
   public void setTotalTimerTime(Float totalTimerTime) {
      setFieldValue(8, 0, totalTimerTime, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_distance field
    * Units: m
    *
    * @return total_distance
    */
   public Float getTotalDistance() {
      return getFieldFloatValue(9, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_distance field
    * Units: m
    *
    * @param totalDistance
    */
   public void setTotalDistance(Float totalDistance) {
      setFieldValue(9, 0, totalDistance, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_cycles field
    * Units: cycles
    *
    * @return total_cycles
    */
   public Long getTotalCycles() {
      return getFieldLongValue(10, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_cycles field
    * Units: cycles
    *
    * @param totalCycles
    */
   public void setTotalCycles(Long totalCycles) {
      setFieldValue(10, 0, totalCycles, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_strides field
    * Units: strides
    *
    * @return total_strides
    */
   public Long getTotalStrides() {
      return getFieldLongValue(10, 0, Profile.SubFields.LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES);
   }

   /**
    * Set total_strides field
    * Units: strides
    *
    * @param totalStrides
    */
   public void setTotalStrides(Long totalStrides) {
      setFieldValue(10, 0, totalStrides, Profile.SubFields.LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES);
   }

   /**
    * Get total_calories field
    * Units: kcal
    *
    * @return total_calories
    */
   public Integer getTotalCalories() {
      return getFieldIntegerValue(11, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_calories field
    * Units: kcal
    *
    * @param totalCalories
    */
   public void setTotalCalories(Integer totalCalories) {
      setFieldValue(11, 0, totalCalories, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_fat_calories field
    * Units: kcal
    * Comment: If New Leaf
    *
    * @return total_fat_calories
    */
   public Integer getTotalFatCalories() {
      return getFieldIntegerValue(12, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_fat_calories field
    * Units: kcal
    * Comment: If New Leaf
    *
    * @param totalFatCalories
    */
   public void setTotalFatCalories(Integer totalFatCalories) {
      setFieldValue(12, 0, totalFatCalories, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_speed field
    * Units: m/s
    *
    * @return avg_speed
    */
   public Float getAvgSpeed() {
      return getFieldFloatValue(13, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_speed field
    * Units: m/s
    *
    * @param avgSpeed
    */
   public void setAvgSpeed(Float avgSpeed) {
      setFieldValue(13, 0, avgSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_speed field
    * Units: m/s
    *
    * @return max_speed
    */
   public Float getMaxSpeed() {
      return getFieldFloatValue(14, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_speed field
    * Units: m/s
    *
    * @param maxSpeed
    */
   public void setMaxSpeed(Float maxSpeed) {
      setFieldValue(14, 0, maxSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_heart_rate field
    * Units: bpm
    *
    * @return avg_heart_rate
    */
   public Short getAvgHeartRate() {
      return getFieldShortValue(15, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_heart_rate field
    * Units: bpm
    *
    * @param avgHeartRate
    */
   public void setAvgHeartRate(Short avgHeartRate) {
      setFieldValue(15, 0, avgHeartRate, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_heart_rate field
    * Units: bpm
    *
    * @return max_heart_rate
    */
   public Short getMaxHeartRate() {
      return getFieldShortValue(16, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_heart_rate field
    * Units: bpm
    *
    * @param maxHeartRate
    */
   public void setMaxHeartRate(Short maxHeartRate) {
      setFieldValue(16, 0, maxHeartRate, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_cadence field
    * Units: rpm
    * Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
    *
    * @return avg_cadence
    */
   public Short getAvgCadence() {
      return getFieldShortValue(17, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_cadence field
    * Units: rpm
    * Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
    *
    * @param avgCadence
    */
   public void setAvgCadence(Short avgCadence) {
      setFieldValue(17, 0, avgCadence, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_running_cadence field
    * Units: strides/min
    *
    * @return avg_running_cadence
    */
   public Short getAvgRunningCadence() {
      return getFieldShortValue(17, 0, Profile.SubFields.LAP_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE);
   }

   /**
    * Set avg_running_cadence field
    * Units: strides/min
    *
    * @param avgRunningCadence
    */
   public void setAvgRunningCadence(Short avgRunningCadence) {
      setFieldValue(17, 0, avgRunningCadence, Profile.SubFields.LAP_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE);
   }

   /**
    * Get max_cadence field
    * Units: rpm
    *
    * @return max_cadence
    */
   public Short getMaxCadence() {
      return getFieldShortValue(18, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_cadence field
    * Units: rpm
    *
    * @param maxCadence
    */
   public void setMaxCadence(Short maxCadence) {
      setFieldValue(18, 0, maxCadence, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_running_cadence field
    * Units: strides/min
    *
    * @return max_running_cadence
    */
   public Short getMaxRunningCadence() {
      return getFieldShortValue(18, 0, Profile.SubFields.LAP_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE);
   }

   /**
    * Set max_running_cadence field
    * Units: strides/min
    *
    * @param maxRunningCadence
    */
   public void setMaxRunningCadence(Short maxRunningCadence) {
      setFieldValue(18, 0, maxRunningCadence, Profile.SubFields.LAP_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE);
   }

   /**
    * Get avg_power field
    * Units: watts
    * Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
    *
    * @return avg_power
    */
   public Integer getAvgPower() {
      return getFieldIntegerValue(19, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_power field
    * Units: watts
    * Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
    *
    * @param avgPower
    */
   public void setAvgPower(Integer avgPower) {
      setFieldValue(19, 0, avgPower, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_power field
    * Units: watts
    *
    * @return max_power
    */
   public Integer getMaxPower() {
      return getFieldIntegerValue(20, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_power field
    * Units: watts
    *
    * @param maxPower
    */
   public void setMaxPower(Integer maxPower) {
      setFieldValue(20, 0, maxPower, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_ascent field
    * Units: m
    *
    * @return total_ascent
    */
   public Integer getTotalAscent() {
      return getFieldIntegerValue(21, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_ascent field
    * Units: m
    *
    * @param totalAscent
    */
   public void setTotalAscent(Integer totalAscent) {
      setFieldValue(21, 0, totalAscent, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_descent field
    * Units: m
    *
    * @return total_descent
    */
   public Integer getTotalDescent() {
      return getFieldIntegerValue(22, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_descent field
    * Units: m
    *
    * @param totalDescent
    */
   public void setTotalDescent(Integer totalDescent) {
      setFieldValue(22, 0, totalDescent, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get intensity field
    *
    * @return intensity
    */
   public Intensity getIntensity() {
      Short value = getFieldShortValue(23, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return Intensity.getByValue(value);
   }

   /**
    * Set intensity field
    *
    * @param intensity
    */
   public void setIntensity(Intensity intensity) {
      setFieldValue(23, 0, intensity.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get lap_trigger field
    *
    * @return lap_trigger
    */
   public LapTrigger getLapTrigger() {
      Short value = getFieldShortValue(24, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return LapTrigger.getByValue(value);
   }

   /**
    * Set lap_trigger field
    *
    * @param lapTrigger
    */
   public void setLapTrigger(LapTrigger lapTrigger) {
      setFieldValue(24, 0, lapTrigger.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get sport field
    *
    * @return sport
    */
   public Sport getSport() {
      Short value = getFieldShortValue(25, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return Sport.getByValue(value);
   }

   /**
    * Set sport field
    *
    * @param sport
    */
   public void setSport(Sport sport) {
      setFieldValue(25, 0, sport.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get event_group field
    *
    * @return event_group
    */
   public Short getEventGroup() {
      return getFieldShortValue(26, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set event_group field
    *
    * @param eventGroup
    */
   public void setEventGroup(Short eventGroup) {
      setFieldValue(26, 0, eventGroup, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get num_lengths field
    * Units: lengths
    * Comment: # of lengths of swim pool
    *
    * @return num_lengths
    */
   public Integer getNumLengths() {
      return getFieldIntegerValue(32, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set num_lengths field
    * Units: lengths
    * Comment: # of lengths of swim pool
    *
    * @param numLengths
    */
   public void setNumLengths(Integer numLengths) {
      setFieldValue(32, 0, numLengths, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get normalized_power field
    * Units: watts
    *
    * @return normalized_power
    */
   public Integer getNormalizedPower() {
      return getFieldIntegerValue(33, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set normalized_power field
    * Units: watts
    *
    * @param normalizedPower
    */
   public void setNormalizedPower(Integer normalizedPower) {
      setFieldValue(33, 0, normalizedPower, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get left_right_balance field
    *
    * @return left_right_balance
    */
   public Integer getLeftRightBalance() {
      return getFieldIntegerValue(34, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set left_right_balance field
    *
    * @param leftRightBalance
    */
   public void setLeftRightBalance(Integer leftRightBalance) {
      setFieldValue(34, 0, leftRightBalance, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get first_length_index field
    *
    * @return first_length_index
    */
   public Integer getFirstLengthIndex() {
      return getFieldIntegerValue(35, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set first_length_index field
    *
    * @param firstLengthIndex
    */
   public void setFirstLengthIndex(Integer firstLengthIndex) {
      setFieldValue(35, 0, firstLengthIndex, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_stroke_distance field
    * Units: m
    *
    * @return avg_stroke_distance
    */
   public Float getAvgStrokeDistance() {
      return getFieldFloatValue(37, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_stroke_distance field
    * Units: m
    *
    * @param avgStrokeDistance
    */
   public void setAvgStrokeDistance(Float avgStrokeDistance) {
      setFieldValue(37, 0, avgStrokeDistance, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get swim_stroke field
    *
    * @return swim_stroke
    */
   public SwimStroke getSwimStroke() {
      Short value = getFieldShortValue(38, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return SwimStroke.getByValue(value);
   }

   /**
    * Set swim_stroke field
    *
    * @param swimStroke
    */
   public void setSwimStroke(SwimStroke swimStroke) {
      setFieldValue(38, 0, swimStroke.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get sub_sport field
    *
    * @return sub_sport
    */
   public SubSport getSubSport() {
      Short value = getFieldShortValue(39, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return SubSport.getByValue(value);
   }

   /**
    * Set sub_sport field
    *
    * @param subSport
    */
   public void setSubSport(SubSport subSport) {
      setFieldValue(39, 0, subSport.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get num_active_lengths field
    * Units: lengths
    * Comment: # of active lengths of swim pool
    *
    * @return num_active_lengths
    */
   public Integer getNumActiveLengths() {
      return getFieldIntegerValue(40, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set num_active_lengths field
    * Units: lengths
    * Comment: # of active lengths of swim pool
    *
    * @param numActiveLengths
    */
   public void setNumActiveLengths(Integer numActiveLengths) {
      setFieldValue(40, 0, numActiveLengths, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_work field
    * Units: J
    *
    * @return total_work
    */
   public Long getTotalWork() {
      return getFieldLongValue(41, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_work field
    * Units: J
    *
    * @param totalWork
    */
   public void setTotalWork(Long totalWork) {
      setFieldValue(41, 0, totalWork, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_altitude field
    * Units: m
    *
    * @return avg_altitude
    */
   public Float getAvgAltitude() {
      return getFieldFloatValue(42, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_altitude field
    * Units: m
    *
    * @param avgAltitude
    */
   public void setAvgAltitude(Float avgAltitude) {
      setFieldValue(42, 0, avgAltitude, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_altitude field
    * Units: m
    *
    * @return max_altitude
    */
   public Float getMaxAltitude() {
      return getFieldFloatValue(43, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_altitude field
    * Units: m
    *
    * @param maxAltitude
    */
   public void setMaxAltitude(Float maxAltitude) {
      setFieldValue(43, 0, maxAltitude, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get gps_accuracy field
    * Units: m
    *
    * @return gps_accuracy
    */
   public Short getGpsAccuracy() {
      return getFieldShortValue(44, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set gps_accuracy field
    * Units: m
    *
    * @param gpsAccuracy
    */
   public void setGpsAccuracy(Short gpsAccuracy) {
      setFieldValue(44, 0, gpsAccuracy, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_grade field
    * Units: %
    *
    * @return avg_grade
    */
   public Float getAvgGrade() {
      return getFieldFloatValue(45, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_grade field
    * Units: %
    *
    * @param avgGrade
    */
   public void setAvgGrade(Float avgGrade) {
      setFieldValue(45, 0, avgGrade, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_pos_grade field
    * Units: %
    *
    * @return avg_pos_grade
    */
   public Float getAvgPosGrade() {
      return getFieldFloatValue(46, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_pos_grade field
    * Units: %
    *
    * @param avgPosGrade
    */
   public void setAvgPosGrade(Float avgPosGrade) {
      setFieldValue(46, 0, avgPosGrade, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_neg_grade field
    * Units: %
    *
    * @return avg_neg_grade
    */
   public Float getAvgNegGrade() {
      return getFieldFloatValue(47, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_neg_grade field
    * Units: %
    *
    * @param avgNegGrade
    */
   public void setAvgNegGrade(Float avgNegGrade) {
      setFieldValue(47, 0, avgNegGrade, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_pos_grade field
    * Units: %
    *
    * @return max_pos_grade
    */
   public Float getMaxPosGrade() {
      return getFieldFloatValue(48, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_pos_grade field
    * Units: %
    *
    * @param maxPosGrade
    */
   public void setMaxPosGrade(Float maxPosGrade) {
      setFieldValue(48, 0, maxPosGrade, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_neg_grade field
    * Units: %
    *
    * @return max_neg_grade
    */
   public Float getMaxNegGrade() {
      return getFieldFloatValue(49, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_neg_grade field
    * Units: %
    *
    * @param maxNegGrade
    */
   public void setMaxNegGrade(Float maxNegGrade) {
      setFieldValue(49, 0, maxNegGrade, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_temperature field
    * Units: C
    *
    * @return avg_temperature
    */
   public Byte getAvgTemperature() {
      return getFieldByteValue(50, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_temperature field
    * Units: C
    *
    * @param avgTemperature
    */
   public void setAvgTemperature(Byte avgTemperature) {
      setFieldValue(50, 0, avgTemperature, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_temperature field
    * Units: C
    *
    * @return max_temperature
    */
   public Byte getMaxTemperature() {
      return getFieldByteValue(51, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_temperature field
    * Units: C
    *
    * @param maxTemperature
    */
   public void setMaxTemperature(Byte maxTemperature) {
      setFieldValue(51, 0, maxTemperature, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_moving_time field
    * Units: s
    *
    * @return total_moving_time
    */
   public Float getTotalMovingTime() {
      return getFieldFloatValue(52, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_moving_time field
    * Units: s
    *
    * @param totalMovingTime
    */
   public void setTotalMovingTime(Float totalMovingTime) {
      setFieldValue(52, 0, totalMovingTime, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_pos_vertical_speed field
    * Units: m/s
    *
    * @return avg_pos_vertical_speed
    */
   public Float getAvgPosVerticalSpeed() {
      return getFieldFloatValue(53, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_pos_vertical_speed field
    * Units: m/s
    *
    * @param avgPosVerticalSpeed
    */
   public void setAvgPosVerticalSpeed(Float avgPosVerticalSpeed) {
      setFieldValue(53, 0, avgPosVerticalSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_neg_vertical_speed field
    * Units: m/s
    *
    * @return avg_neg_vertical_speed
    */
   public Float getAvgNegVerticalSpeed() {
      return getFieldFloatValue(54, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_neg_vertical_speed field
    * Units: m/s
    *
    * @param avgNegVerticalSpeed
    */
   public void setAvgNegVerticalSpeed(Float avgNegVerticalSpeed) {
      setFieldValue(54, 0, avgNegVerticalSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_pos_vertical_speed field
    * Units: m/s
    *
    * @return max_pos_vertical_speed
    */
   public Float getMaxPosVerticalSpeed() {
      return getFieldFloatValue(55, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_pos_vertical_speed field
    * Units: m/s
    *
    * @param maxPosVerticalSpeed
    */
   public void setMaxPosVerticalSpeed(Float maxPosVerticalSpeed) {
      setFieldValue(55, 0, maxPosVerticalSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_neg_vertical_speed field
    * Units: m/s
    *
    * @return max_neg_vertical_speed
    */
   public Float getMaxNegVerticalSpeed() {
      return getFieldFloatValue(56, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_neg_vertical_speed field
    * Units: m/s
    *
    * @param maxNegVerticalSpeed
    */
   public void setMaxNegVerticalSpeed(Float maxNegVerticalSpeed) {
      setFieldValue(56, 0, maxNegVerticalSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of time_in_hr_zone
    */
   public int getNumTimeInHrZone() {
      return getNumFieldValues(57, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get time_in_hr_zone field
    * Units: s
    *
    * @param index of time_in_hr_zone
    * @return time_in_hr_zone
    */
   public Float getTimeInHrZone(int index) {
      return getFieldFloatValue(57, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set time_in_hr_zone field
    * Units: s
    *
    * @param index of time_in_hr_zone
    * @param timeInHrZone
    */
   public void setTimeInHrZone(int index, Float timeInHrZone) {
      setFieldValue(57, index, timeInHrZone, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of time_in_speed_zone
    */
   public int getNumTimeInSpeedZone() {
      return getNumFieldValues(58, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get time_in_speed_zone field
    * Units: s
    *
    * @param index of time_in_speed_zone
    * @return time_in_speed_zone
    */
   public Float getTimeInSpeedZone(int index) {
      return getFieldFloatValue(58, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set time_in_speed_zone field
    * Units: s
    *
    * @param index of time_in_speed_zone
    * @param timeInSpeedZone
    */
   public void setTimeInSpeedZone(int index, Float timeInSpeedZone) {
      setFieldValue(58, index, timeInSpeedZone, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of time_in_cadence_zone
    */
   public int getNumTimeInCadenceZone() {
      return getNumFieldValues(59, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get time_in_cadence_zone field
    * Units: s
    *
    * @param index of time_in_cadence_zone
    * @return time_in_cadence_zone
    */
   public Float getTimeInCadenceZone(int index) {
      return getFieldFloatValue(59, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set time_in_cadence_zone field
    * Units: s
    *
    * @param index of time_in_cadence_zone
    * @param timeInCadenceZone
    */
   public void setTimeInCadenceZone(int index, Float timeInCadenceZone) {
      setFieldValue(59, index, timeInCadenceZone, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of time_in_power_zone
    */
   public int getNumTimeInPowerZone() {
      return getNumFieldValues(60, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get time_in_power_zone field
    * Units: s
    *
    * @param index of time_in_power_zone
    * @return time_in_power_zone
    */
   public Float getTimeInPowerZone(int index) {
      return getFieldFloatValue(60, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set time_in_power_zone field
    * Units: s
    *
    * @param index of time_in_power_zone
    * @param timeInPowerZone
    */
   public void setTimeInPowerZone(int index, Float timeInPowerZone) {
      setFieldValue(60, index, timeInPowerZone, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get repetition_num field
    *
    * @return repetition_num
    */
   public Integer getRepetitionNum() {
      return getFieldIntegerValue(61, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set repetition_num field
    *
    * @param repetitionNum
    */
   public void setRepetitionNum(Integer repetitionNum) {
      setFieldValue(61, 0, repetitionNum, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get min_altitude field
    * Units: m
    *
    * @return min_altitude
    */
   public Float getMinAltitude() {
      return getFieldFloatValue(62, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set min_altitude field
    * Units: m
    *
    * @param minAltitude
    */
   public void setMinAltitude(Float minAltitude) {
      setFieldValue(62, 0, minAltitude, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get min_heart_rate field
    * Units: bpm
    *
    * @return min_heart_rate
    */
   public Short getMinHeartRate() {
      return getFieldShortValue(63, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set min_heart_rate field
    * Units: bpm
    *
    * @param minHeartRate
    */
   public void setMinHeartRate(Short minHeartRate) {
      setFieldValue(63, 0, minHeartRate, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get wkt_step_index field
    *
    * @return wkt_step_index
    */
   public Integer getWktStepIndex() {
      return getFieldIntegerValue(71, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set wkt_step_index field
    *
    * @param wktStepIndex
    */
   public void setWktStepIndex(Integer wktStepIndex) {
      setFieldValue(71, 0, wktStepIndex, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get opponent_score field
    *
    * @return opponent_score
    */
   public Integer getOpponentScore() {
      return getFieldIntegerValue(74, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set opponent_score field
    *
    * @param opponentScore
    */
   public void setOpponentScore(Integer opponentScore) {
      setFieldValue(74, 0, opponentScore, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of stroke_count
    */
   public int getNumStrokeCount() {
      return getNumFieldValues(75, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get stroke_count field
    * Units: counts
    * Comment: stroke_type enum used as the index
    *
    * @param index of stroke_count
    * @return stroke_count
    */
   public Integer getStrokeCount(int index) {
      return getFieldIntegerValue(75, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set stroke_count field
    * Units: counts
    * Comment: stroke_type enum used as the index
    *
    * @param index of stroke_count
    * @param strokeCount
    */
   public void setStrokeCount(int index, Integer strokeCount) {
      setFieldValue(75, index, strokeCount, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of zone_count
    */
   public int getNumZoneCount() {
      return getNumFieldValues(76, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get zone_count field
    * Units: counts
    * Comment: zone number used as the index
    *
    * @param index of zone_count
    * @return zone_count
    */
   public Integer getZoneCount(int index) {
      return getFieldIntegerValue(76, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set zone_count field
    * Units: counts
    * Comment: zone number used as the index
    *
    * @param index of zone_count
    * @param zoneCount
    */
   public void setZoneCount(int index, Integer zoneCount) {
      setFieldValue(76, index, zoneCount, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_vertical_oscillation field
    * Units: mm
    *
    * @return avg_vertical_oscillation
    */
   public Float getAvgVerticalOscillation() {
      return getFieldFloatValue(77, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_vertical_oscillation field
    * Units: mm
    *
    * @param avgVerticalOscillation
    */
   public void setAvgVerticalOscillation(Float avgVerticalOscillation) {
      setFieldValue(77, 0, avgVerticalOscillation, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_stance_time_percent field
    * Units: percent
    *
    * @return avg_stance_time_percent
    */
   public Float getAvgStanceTimePercent() {
      return getFieldFloatValue(78, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_stance_time_percent field
    * Units: percent
    *
    * @param avgStanceTimePercent
    */
   public void setAvgStanceTimePercent(Float avgStanceTimePercent) {
      setFieldValue(78, 0, avgStanceTimePercent, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_stance_time field
    * Units: ms
    *
    * @return avg_stance_time
    */
   public Float getAvgStanceTime() {
      return getFieldFloatValue(79, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_stance_time field
    * Units: ms
    *
    * @param avgStanceTime
    */
   public void setAvgStanceTime(Float avgStanceTime) {
      setFieldValue(79, 0, avgStanceTime, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_fractional_cadence field
    * Units: rpm
    * Comment: fractional part of the avg_cadence
    *
    * @return avg_fractional_cadence
    */
   public Float getAvgFractionalCadence() {
      return getFieldFloatValue(80, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_fractional_cadence field
    * Units: rpm
    * Comment: fractional part of the avg_cadence
    *
    * @param avgFractionalCadence
    */
   public void setAvgFractionalCadence(Float avgFractionalCadence) {
      setFieldValue(80, 0, avgFractionalCadence, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_fractional_cadence field
    * Units: rpm
    * Comment: fractional part of the max_cadence
    *
    * @return max_fractional_cadence
    */
   public Float getMaxFractionalCadence() {
      return getFieldFloatValue(81, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_fractional_cadence field
    * Units: rpm
    * Comment: fractional part of the max_cadence
    *
    * @param maxFractionalCadence
    */
   public void setMaxFractionalCadence(Float maxFractionalCadence) {
      setFieldValue(81, 0, maxFractionalCadence, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_fractional_cycles field
    * Units: cycles
    * Comment: fractional part of the total_cycles
    *
    * @return total_fractional_cycles
    */
   public Float getTotalFractionalCycles() {
      return getFieldFloatValue(82, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_fractional_cycles field
    * Units: cycles
    * Comment: fractional part of the total_cycles
    *
    * @param totalFractionalCycles
    */
   public void setTotalFractionalCycles(Float totalFractionalCycles) {
      setFieldValue(82, 0, totalFractionalCycles, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get player_score field
    *
    * @return player_score
    */
   public Integer getPlayerScore() {
      return getFieldIntegerValue(83, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set player_score field
    *
    * @param playerScore
    */
   public void setPlayerScore(Integer playerScore) {
      setFieldValue(83, 0, playerScore, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_total_hemoglobin_conc
    */
   public int getNumAvgTotalHemoglobinConc() {
      return getNumFieldValues(84, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_total_hemoglobin_conc field
    * Units: g/dL
    * Comment: Avg saturated and unsaturated hemoglobin
    *
    * @param index of avg_total_hemoglobin_conc
    * @return avg_total_hemoglobin_conc
    */
   public Float getAvgTotalHemoglobinConc(int index) {
      return getFieldFloatValue(84, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_total_hemoglobin_conc field
    * Units: g/dL
    * Comment: Avg saturated and unsaturated hemoglobin
    *
    * @param index of avg_total_hemoglobin_conc
    * @param avgTotalHemoglobinConc
    */
   public void setAvgTotalHemoglobinConc(int index, Float avgTotalHemoglobinConc) {
      setFieldValue(84, index, avgTotalHemoglobinConc, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of min_total_hemoglobin_conc
    */
   public int getNumMinTotalHemoglobinConc() {
      return getNumFieldValues(85, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get min_total_hemoglobin_conc field
    * Units: g/dL
    * Comment: Min saturated and unsaturated hemoglobin
    *
    * @param index of min_total_hemoglobin_conc
    * @return min_total_hemoglobin_conc
    */
   public Float getMinTotalHemoglobinConc(int index) {
      return getFieldFloatValue(85, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set min_total_hemoglobin_conc field
    * Units: g/dL
    * Comment: Min saturated and unsaturated hemoglobin
    *
    * @param index of min_total_hemoglobin_conc
    * @param minTotalHemoglobinConc
    */
   public void setMinTotalHemoglobinConc(int index, Float minTotalHemoglobinConc) {
      setFieldValue(85, index, minTotalHemoglobinConc, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of max_total_hemoglobin_conc
    */
   public int getNumMaxTotalHemoglobinConc() {
      return getNumFieldValues(86, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_total_hemoglobin_conc field
    * Units: g/dL
    * Comment: Max saturated and unsaturated hemoglobin
    *
    * @param index of max_total_hemoglobin_conc
    * @return max_total_hemoglobin_conc
    */
   public Float getMaxTotalHemoglobinConc(int index) {
      return getFieldFloatValue(86, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_total_hemoglobin_conc field
    * Units: g/dL
    * Comment: Max saturated and unsaturated hemoglobin
    *
    * @param index of max_total_hemoglobin_conc
    * @param maxTotalHemoglobinConc
    */
   public void setMaxTotalHemoglobinConc(int index, Float maxTotalHemoglobinConc) {
      setFieldValue(86, index, maxTotalHemoglobinConc, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_saturated_hemoglobin_percent
    */
   public int getNumAvgSaturatedHemoglobinPercent() {
      return getNumFieldValues(87, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_saturated_hemoglobin_percent field
    * Units: %
    * Comment: Avg percentage of hemoglobin saturated with oxygen
    *
    * @param index of avg_saturated_hemoglobin_percent
    * @return avg_saturated_hemoglobin_percent
    */
   public Float getAvgSaturatedHemoglobinPercent(int index) {
      return getFieldFloatValue(87, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_saturated_hemoglobin_percent field
    * Units: %
    * Comment: Avg percentage of hemoglobin saturated with oxygen
    *
    * @param index of avg_saturated_hemoglobin_percent
    * @param avgSaturatedHemoglobinPercent
    */
   public void setAvgSaturatedHemoglobinPercent(int index, Float avgSaturatedHemoglobinPercent) {
      setFieldValue(87, index, avgSaturatedHemoglobinPercent, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of min_saturated_hemoglobin_percent
    */
   public int getNumMinSaturatedHemoglobinPercent() {
      return getNumFieldValues(88, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get min_saturated_hemoglobin_percent field
    * Units: %
    * Comment: Min percentage of hemoglobin saturated with oxygen
    *
    * @param index of min_saturated_hemoglobin_percent
    * @return min_saturated_hemoglobin_percent
    */
   public Float getMinSaturatedHemoglobinPercent(int index) {
      return getFieldFloatValue(88, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set min_saturated_hemoglobin_percent field
    * Units: %
    * Comment: Min percentage of hemoglobin saturated with oxygen
    *
    * @param index of min_saturated_hemoglobin_percent
    * @param minSaturatedHemoglobinPercent
    */
   public void setMinSaturatedHemoglobinPercent(int index, Float minSaturatedHemoglobinPercent) {
      setFieldValue(88, index, minSaturatedHemoglobinPercent, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of max_saturated_hemoglobin_percent
    */
   public int getNumMaxSaturatedHemoglobinPercent() {
      return getNumFieldValues(89, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_saturated_hemoglobin_percent field
    * Units: %
    * Comment: Max percentage of hemoglobin saturated with oxygen
    *
    * @param index of max_saturated_hemoglobin_percent
    * @return max_saturated_hemoglobin_percent
    */
   public Float getMaxSaturatedHemoglobinPercent(int index) {
      return getFieldFloatValue(89, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_saturated_hemoglobin_percent field
    * Units: %
    * Comment: Max percentage of hemoglobin saturated with oxygen
    *
    * @param index of max_saturated_hemoglobin_percent
    * @param maxSaturatedHemoglobinPercent
    */
   public void setMaxSaturatedHemoglobinPercent(int index, Float maxSaturatedHemoglobinPercent) {
      setFieldValue(89, index, maxSaturatedHemoglobinPercent, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_left_torque_effectiveness field
    * Units: percent
    *
    * @return avg_left_torque_effectiveness
    */
   public Float getAvgLeftTorqueEffectiveness() {
      return getFieldFloatValue(91, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_left_torque_effectiveness field
    * Units: percent
    *
    * @param avgLeftTorqueEffectiveness
    */
   public void setAvgLeftTorqueEffectiveness(Float avgLeftTorqueEffectiveness) {
      setFieldValue(91, 0, avgLeftTorqueEffectiveness, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_right_torque_effectiveness field
    * Units: percent
    *
    * @return avg_right_torque_effectiveness
    */
   public Float getAvgRightTorqueEffectiveness() {
      return getFieldFloatValue(92, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_right_torque_effectiveness field
    * Units: percent
    *
    * @param avgRightTorqueEffectiveness
    */
   public void setAvgRightTorqueEffectiveness(Float avgRightTorqueEffectiveness) {
      setFieldValue(92, 0, avgRightTorqueEffectiveness, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_left_pedal_smoothness field
    * Units: percent
    *
    * @return avg_left_pedal_smoothness
    */
   public Float getAvgLeftPedalSmoothness() {
      return getFieldFloatValue(93, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_left_pedal_smoothness field
    * Units: percent
    *
    * @param avgLeftPedalSmoothness
    */
   public void setAvgLeftPedalSmoothness(Float avgLeftPedalSmoothness) {
      setFieldValue(93, 0, avgLeftPedalSmoothness, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_right_pedal_smoothness field
    * Units: percent
    *
    * @return avg_right_pedal_smoothness
    */
   public Float getAvgRightPedalSmoothness() {
      return getFieldFloatValue(94, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_right_pedal_smoothness field
    * Units: percent
    *
    * @param avgRightPedalSmoothness
    */
   public void setAvgRightPedalSmoothness(Float avgRightPedalSmoothness) {
      setFieldValue(94, 0, avgRightPedalSmoothness, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_combined_pedal_smoothness field
    * Units: percent
    *
    * @return avg_combined_pedal_smoothness
    */
   public Float getAvgCombinedPedalSmoothness() {
      return getFieldFloatValue(95, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_combined_pedal_smoothness field
    * Units: percent
    *
    * @param avgCombinedPedalSmoothness
    */
   public void setAvgCombinedPedalSmoothness(Float avgCombinedPedalSmoothness) {
      setFieldValue(95, 0, avgCombinedPedalSmoothness, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get time_standing field
    * Units: s
    * Comment: Total time spent in the standing position
    *
    * @return time_standing
    */
   public Float getTimeStanding() {
      return getFieldFloatValue(98, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set time_standing field
    * Units: s
    * Comment: Total time spent in the standing position
    *
    * @param timeStanding
    */
   public void setTimeStanding(Float timeStanding) {
      setFieldValue(98, 0, timeStanding, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get stand_count field
    * Comment: Number of transitions to the standing state
    *
    * @return stand_count
    */
   public Integer getStandCount() {
      return getFieldIntegerValue(99, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set stand_count field
    * Comment: Number of transitions to the standing state
    *
    * @param standCount
    */
   public void setStandCount(Integer standCount) {
      setFieldValue(99, 0, standCount, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_left_pco field
    * Units: mm
    * Comment: Average left platform center offset
    *
    * @return avg_left_pco
    */
   public Byte getAvgLeftPco() {
      return getFieldByteValue(100, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_left_pco field
    * Units: mm
    * Comment: Average left platform center offset
    *
    * @param avgLeftPco
    */
   public void setAvgLeftPco(Byte avgLeftPco) {
      setFieldValue(100, 0, avgLeftPco, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_right_pco field
    * Units: mm
    * Comment: Average right platform center offset
    *
    * @return avg_right_pco
    */
   public Byte getAvgRightPco() {
      return getFieldByteValue(101, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_right_pco field
    * Units: mm
    * Comment: Average right platform center offset
    *
    * @param avgRightPco
    */
   public void setAvgRightPco(Byte avgRightPco) {
      setFieldValue(101, 0, avgRightPco, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_left_power_phase
    */
   public int getNumAvgLeftPowerPhase() {
      return getNumFieldValues(102, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_left_power_phase field
    * Units: degrees
    * Comment: Average left power phase angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_left_power_phase
    * @return avg_left_power_phase
    */
   public Float getAvgLeftPowerPhase(int index) {
      return getFieldFloatValue(102, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_left_power_phase field
    * Units: degrees
    * Comment: Average left power phase angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_left_power_phase
    * @param avgLeftPowerPhase
    */
   public void setAvgLeftPowerPhase(int index, Float avgLeftPowerPhase) {
      setFieldValue(102, index, avgLeftPowerPhase, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_left_power_phase_peak
    */
   public int getNumAvgLeftPowerPhasePeak() {
      return getNumFieldValues(103, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_left_power_phase_peak field
    * Units: degrees
    * Comment: Average left power phase peak angles. Data value indexes  defined by power_phase_type.
    *
    * @param index of avg_left_power_phase_peak
    * @return avg_left_power_phase_peak
    */
   public Float getAvgLeftPowerPhasePeak(int index) {
      return getFieldFloatValue(103, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_left_power_phase_peak field
    * Units: degrees
    * Comment: Average left power phase peak angles. Data value indexes  defined by power_phase_type.
    *
    * @param index of avg_left_power_phase_peak
    * @param avgLeftPowerPhasePeak
    */
   public void setAvgLeftPowerPhasePeak(int index, Float avgLeftPowerPhasePeak) {
      setFieldValue(103, index, avgLeftPowerPhasePeak, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_right_power_phase
    */
   public int getNumAvgRightPowerPhase() {
      return getNumFieldValues(104, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_right_power_phase field
    * Units: degrees
    * Comment: Average right power phase angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_right_power_phase
    * @return avg_right_power_phase
    */
   public Float getAvgRightPowerPhase(int index) {
      return getFieldFloatValue(104, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_right_power_phase field
    * Units: degrees
    * Comment: Average right power phase angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_right_power_phase
    * @param avgRightPowerPhase
    */
   public void setAvgRightPowerPhase(int index, Float avgRightPowerPhase) {
      setFieldValue(104, index, avgRightPowerPhase, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_right_power_phase_peak
    */
   public int getNumAvgRightPowerPhasePeak() {
      return getNumFieldValues(105, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_right_power_phase_peak field
    * Units: degrees
    * Comment: Average right power phase peak angles. Data value indexes  defined by power_phase_type.
    *
    * @param index of avg_right_power_phase_peak
    * @return avg_right_power_phase_peak
    */
   public Float getAvgRightPowerPhasePeak(int index) {
      return getFieldFloatValue(105, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_right_power_phase_peak field
    * Units: degrees
    * Comment: Average right power phase peak angles. Data value indexes  defined by power_phase_type.
    *
    * @param index of avg_right_power_phase_peak
    * @param avgRightPowerPhasePeak
    */
   public void setAvgRightPowerPhasePeak(int index, Float avgRightPowerPhasePeak) {
      setFieldValue(105, index, avgRightPowerPhasePeak, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_power_position
    */
   public int getNumAvgPowerPosition() {
      return getNumFieldValues(106, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_power_position field
    * Units: watts
    * Comment: Average power by position. Data value indexes defined by rider_position_type.
    *
    * @param index of avg_power_position
    * @return avg_power_position
    */
   public Integer getAvgPowerPosition(int index) {
      return getFieldIntegerValue(106, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_power_position field
    * Units: watts
    * Comment: Average power by position. Data value indexes defined by rider_position_type.
    *
    * @param index of avg_power_position
    * @param avgPowerPosition
    */
   public void setAvgPowerPosition(int index, Integer avgPowerPosition) {
      setFieldValue(106, index, avgPowerPosition, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of max_power_position
    */
   public int getNumMaxPowerPosition() {
      return getNumFieldValues(107, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_power_position field
    * Units: watts
    * Comment: Maximum power by position. Data value indexes defined by rider_position_type.
    *
    * @param index of max_power_position
    * @return max_power_position
    */
   public Integer getMaxPowerPosition(int index) {
      return getFieldIntegerValue(107, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_power_position field
    * Units: watts
    * Comment: Maximum power by position. Data value indexes defined by rider_position_type.
    *
    * @param index of max_power_position
    * @param maxPowerPosition
    */
   public void setMaxPowerPosition(int index, Integer maxPowerPosition) {
      setFieldValue(107, index, maxPowerPosition, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_cadence_position
    */
   public int getNumAvgCadencePosition() {
      return getNumFieldValues(108, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_cadence_position field
    * Units: rpm
    * Comment: Average cadence by position. Data value indexes defined by rider_position_type.
    *
    * @param index of avg_cadence_position
    * @return avg_cadence_position
    */
   public Short getAvgCadencePosition(int index) {
      return getFieldShortValue(108, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_cadence_position field
    * Units: rpm
    * Comment: Average cadence by position. Data value indexes defined by rider_position_type.
    *
    * @param index of avg_cadence_position
    * @param avgCadencePosition
    */
   public void setAvgCadencePosition(int index, Short avgCadencePosition) {
      setFieldValue(108, index, avgCadencePosition, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of max_cadence_position
    */
   public int getNumMaxCadencePosition() {
      return getNumFieldValues(109, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_cadence_position field
    * Units: rpm
    * Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.
    *
    * @param index of max_cadence_position
    * @return max_cadence_position
    */
   public Short getMaxCadencePosition(int index) {
      return getFieldShortValue(109, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_cadence_position field
    * Units: rpm
    * Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.
    *
    * @param index of max_cadence_position
    * @param maxCadencePosition
    */
   public void setMaxCadencePosition(int index, Short maxCadencePosition) {
      setFieldValue(109, index, maxCadencePosition, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get enhanced_avg_speed field
    * Units: m/s
    *
    * @return enhanced_avg_speed
    */
   public Float getEnhancedAvgSpeed() {
      return getFieldFloatValue(110, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set enhanced_avg_speed field
    * Units: m/s
    *
    * @param enhancedAvgSpeed
    */
   public void setEnhancedAvgSpeed(Float enhancedAvgSpeed) {
      setFieldValue(110, 0, enhancedAvgSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get enhanced_max_speed field
    * Units: m/s
    *
    * @return enhanced_max_speed
    */
   public Float getEnhancedMaxSpeed() {
      return getFieldFloatValue(111, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set enhanced_max_speed field
    * Units: m/s
    *
    * @param enhancedMaxSpeed
    */
   public void setEnhancedMaxSpeed(Float enhancedMaxSpeed) {
      setFieldValue(111, 0, enhancedMaxSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get enhanced_avg_altitude field
    * Units: m
    *
    * @return enhanced_avg_altitude
    */
   public Float getEnhancedAvgAltitude() {
      return getFieldFloatValue(112, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set enhanced_avg_altitude field
    * Units: m
    *
    * @param enhancedAvgAltitude
    */
   public void setEnhancedAvgAltitude(Float enhancedAvgAltitude) {
      setFieldValue(112, 0, enhancedAvgAltitude, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get enhanced_min_altitude field
    * Units: m
    *
    * @return enhanced_min_altitude
    */
   public Float getEnhancedMinAltitude() {
      return getFieldFloatValue(113, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set enhanced_min_altitude field
    * Units: m
    *
    * @param enhancedMinAltitude
    */
   public void setEnhancedMinAltitude(Float enhancedMinAltitude) {
      setFieldValue(113, 0, enhancedMinAltitude, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get enhanced_max_altitude field
    * Units: m
    *
    * @return enhanced_max_altitude
    */
   public Float getEnhancedMaxAltitude() {
      return getFieldFloatValue(114, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set enhanced_max_altitude field
    * Units: m
    *
    * @param enhancedMaxAltitude
    */
   public void setEnhancedMaxAltitude(Float enhancedMaxAltitude) {
      setFieldValue(114, 0, enhancedMaxAltitude, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_lev_motor_power field
    * Units: watts
    * Comment: lev average motor power during lap
    *
    * @return avg_lev_motor_power
    */
   public Integer getAvgLevMotorPower() {
      return getFieldIntegerValue(115, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_lev_motor_power field
    * Units: watts
    * Comment: lev average motor power during lap
    *
    * @param avgLevMotorPower
    */
   public void setAvgLevMotorPower(Integer avgLevMotorPower) {
      setFieldValue(115, 0, avgLevMotorPower, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_lev_motor_power field
    * Units: watts
    * Comment: lev maximum motor power during lap
    *
    * @return max_lev_motor_power
    */
   public Integer getMaxLevMotorPower() {
      return getFieldIntegerValue(116, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_lev_motor_power field
    * Units: watts
    * Comment: lev maximum motor power during lap
    *
    * @param maxLevMotorPower
    */
   public void setMaxLevMotorPower(Integer maxLevMotorPower) {
      setFieldValue(116, 0, maxLevMotorPower, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get lev_battery_consumption field
    * Units: percent
    * Comment: lev battery consumption during lap
    *
    * @return lev_battery_consumption
    */
   public Float getLevBatteryConsumption() {
      return getFieldFloatValue(117, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set lev_battery_consumption field
    * Units: percent
    * Comment: lev battery consumption during lap
    *
    * @param levBatteryConsumption
    */
   public void setLevBatteryConsumption(Float levBatteryConsumption) {
      setFieldValue(117, 0, levBatteryConsumption, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

}
