////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Dynastream Innovations Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2015 Dynastream Innovations Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 16.10Release
// Tag = development-akw-16.10.00-0
////////////////////////////////////////////////////////////////////////////////


package com.garmin.fit.csv;

import com.garmin.fit.*;

import java.util.Collection;
import java.util.Iterator;

public class MesgDataCSVWriter implements MesgListener {
   private CSVWriter csv;
   private boolean showInvalidsAsEmptyCells = false;

   public MesgDataCSVWriter(String fileName) {
      csv = new CSVWriter(fileName);
   }

   public void close() {
      csv.close();
   }

   public void showInvalidsAsEmptyCells() {
      showInvalidsAsEmptyCells = true;
   }

   public void onMesg(Mesg mesg) {

      Collection<Field> fields = mesg.getFields();
      Iterator<Field> fieldsIterator = fields.iterator();
      while(fieldsIterator.hasNext()) {
         Field field = fieldsIterator.next();
         int subFieldIndex = mesg.GetActiveSubFieldIndex(field.getNum());

         String value = field.getStringValue(0, subFieldIndex);

         if (value == null || (showInvalidsAsEmptyCells && value.equals(Fit.baseTypeInvalidMap.get(field.getType(subFieldIndex)).toString())))
            value = "";

         for (int fieldElement = 1; fieldElement < field.getNumValues(); fieldElement++) {
            value += "|";

            String nextValue = field.getStringValue(fieldElement, subFieldIndex);

            if (nextValue != null)
               value += nextValue;
         }

         // Escapes embedded commas, double quotes, and newline characters
         value = value.replaceAll("\"", "\"\"");
         value = "\"" + value + "\"";

         String units = field.getUnits(subFieldIndex);
         if(units.isEmpty()) {
            csv.set(mesg.getName() + "." + field.getName(subFieldIndex), value);
         }
         else {
            csv.set(mesg.getName() + "." + field.getName(subFieldIndex) + "[" + units + "]", value);
         }

      }
   csv.writeln();
   }
}
