////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Dynastream Innovations Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2015 Dynastream Innovations Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 16.10Release
// Tag = development-akw-16.10.00-0
////////////////////////////////////////////////////////////////////////////////


package com.garmin.fit;

import java.io.OutputStream;
import java.util.ArrayList;

public class MesgDefinition {
   protected int num;
   protected int localNum;
   protected int arch;
   protected ArrayList<FieldDefinition> fields;

   protected MesgDefinition() {
      num = MesgNum.INVALID;
      localNum = 0;
      arch = Fit.ARCH_ENDIAN_BIG;
      fields = new ArrayList<FieldDefinition>(); 
    }
   
   public MesgDefinition(final Mesg mesg) {
      num = mesg.num;
      localNum = mesg.localNum;
      arch = Fit.ARCH_ENDIAN_BIG;

      if (localNum >= Fit.MAX_LOCAL_MESGS)
         throw new FitRuntimeException("Invalid local message number " + localNum + ".  Local message number must be < " + Fit.MAX_LOCAL_MESGS + ".");
      
      fields = new ArrayList<FieldDefinition>();
      
      for (Field field : mesg.fields) {
         fields.add(new FieldDefinition(field));
      }
   }
   
   public int getNum() {
      return num;
   }

   public int getLocalNum() {
      return localNum;
   }
   
   public int getArch() {
      return arch;
   }
   
   public ArrayList<FieldDefinition> getFields() {
      return fields;
   }
   
   public FieldDefinition getField(int num) {
      for (FieldDefinition field : fields) {
         if (field.num == num)
            return field;
      }
      
      return null;
   }
   
   public void addField(FieldDefinition fieldDef) {
      fields.add(fieldDef);
   }
   
   public void write(OutputStream out) {

      try {
         out.write(Fit.HDR_TYPE_DEF_BIT | (localNum & Fit.HDR_TYPE_MASK)); // Message definition record header.
         out.write(0); // Reserved
         out.write(Fit.ARCH_ENDIAN_BIG);
         out.write(num >> 8);
         out.write(num);
         out.write(fields.size());
      } catch (java.io.IOException e) {
      }

      for (FieldDefinition field : fields) {
         field.write(out);
      }

   }
   
   public boolean supports(Mesg mesg) {
      return supports(new MesgDefinition(mesg));
   }
    
   public boolean supports(MesgDefinition mesgDef) {
      if (mesgDef == null)
         return false;

      if (num != mesgDef.num)
         return false;
      
      if (localNum != mesgDef.localNum)
         return false;
      
      for (FieldDefinition fieldDef : mesgDef.fields) {
         FieldDefinition supportedFieldDef = getField(fieldDef.num);
            
         if (supportedFieldDef == null)
            return false;
         
         if (fieldDef.size > supportedFieldDef.size)
            return false;
      }
      
      return true;
   }

   public boolean equals(Object o) {
      if (this == o)
         return true;

      if (!(o instanceof MesgDefinition))
         return false;
      
      MesgDefinition other = (MesgDefinition)o;
      
      if (num != other.num)
         return false;
      
      if (localNum != other.localNum)
         return false;
      
      if (fields.size() != other.fields.size())
         return false;
      
      for (int i=0; i<fields.size(); i++) {
         if (!fields.get(i).equals(other.fields.get(i)))
            return false;
      }
      
      return true;
   }
   
   public int hashCode() {
      int hashCode = 1;
      
      hashCode = (hashCode * 31) + new Integer(num).hashCode();
      hashCode = (hashCode * 47) + new Integer(localNum).hashCode();
      hashCode = (hashCode * 19) + fields.hashCode();
      
      return hashCode;
   }
}
