////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Dynastream Innovations Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2015 Dynastream Innovations Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 16.10Release
// Tag = development-akw-16.10.00-0
////////////////////////////////////////////////////////////////////////////////


package com.garmin.fit;


public class SegmentLapMesg extends Mesg implements MesgWithEvent {

   protected static final	Mesg segmentLapMesg;
   static {            
      int field_index = 0;
      int subfield_index = 0;         
      // segment_lap   
      segmentLapMesg = new Mesg("segment_lap", MesgNum.SEGMENT_LAP);
      segmentLapMesg.addField(new Field("message_index", 254, 132, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("timestamp", 253, 134, 1, 0, "s", false));
      field_index++;
      segmentLapMesg.addField(new Field("event", 0, 0, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("event_type", 1, 0, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("start_time", 2, 134, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("start_position_lat", 3, 133, 1, 0, "semicircles", false));
      field_index++;
      segmentLapMesg.addField(new Field("start_position_long", 4, 133, 1, 0, "semicircles", false));
      field_index++;
      segmentLapMesg.addField(new Field("end_position_lat", 5, 133, 1, 0, "semicircles", false));
      field_index++;
      segmentLapMesg.addField(new Field("end_position_long", 6, 133, 1, 0, "semicircles", false));
      field_index++;
      segmentLapMesg.addField(new Field("total_elapsed_time", 7, 134, 1000, 0, "s", false));
      field_index++;
      segmentLapMesg.addField(new Field("total_timer_time", 8, 134, 1000, 0, "s", false));
      field_index++;
      segmentLapMesg.addField(new Field("total_distance", 9, 134, 100, 0, "m", false));
      field_index++;
      segmentLapMesg.addField(new Field("total_cycles", 10, 134, 1, 0, "cycles", false));
      subfield_index = 0;
      segmentLapMesg.fields.get(field_index).subFields.add(new SubField("total_strokes", 134, 1, 0, "strokes"));
      segmentLapMesg.fields.get(field_index).subFields.get(subfield_index).addMap(23, 2);
      subfield_index++;
      field_index++;
      segmentLapMesg.addField(new Field("total_calories", 11, 132, 1, 0, "kcal", false));
      field_index++;
      segmentLapMesg.addField(new Field("total_fat_calories", 12, 132, 1, 0, "kcal", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_speed", 13, 132, 1000, 0, "m/s", false));
      field_index++;
      segmentLapMesg.addField(new Field("max_speed", 14, 132, 1000, 0, "m/s", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_heart_rate", 15, 2, 1, 0, "bpm", false));
      field_index++;
      segmentLapMesg.addField(new Field("max_heart_rate", 16, 2, 1, 0, "bpm", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_cadence", 17, 2, 1, 0, "rpm", false));
      field_index++;
      segmentLapMesg.addField(new Field("max_cadence", 18, 2, 1, 0, "rpm", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_power", 19, 132, 1, 0, "watts", false));
      field_index++;
      segmentLapMesg.addField(new Field("max_power", 20, 132, 1, 0, "watts", false));
      field_index++;
      segmentLapMesg.addField(new Field("total_ascent", 21, 132, 1, 0, "m", false));
      field_index++;
      segmentLapMesg.addField(new Field("total_descent", 22, 132, 1, 0, "m", false));
      field_index++;
      segmentLapMesg.addField(new Field("sport", 23, 0, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("event_group", 24, 2, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("nec_lat", 25, 133, 1, 0, "semicircles", false));
      field_index++;
      segmentLapMesg.addField(new Field("nec_long", 26, 133, 1, 0, "semicircles", false));
      field_index++;
      segmentLapMesg.addField(new Field("swc_lat", 27, 133, 1, 0, "semicircles", false));
      field_index++;
      segmentLapMesg.addField(new Field("swc_long", 28, 133, 1, 0, "semicircles", false));
      field_index++;
      segmentLapMesg.addField(new Field("name", 29, 7, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("normalized_power", 30, 132, 1, 0, "watts", false));
      field_index++;
      segmentLapMesg.addField(new Field("left_right_balance", 31, 132, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("sub_sport", 32, 0, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("total_work", 33, 134, 1, 0, "J", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_altitude", 34, 132, 5, 500, "m", false));
      field_index++;
      segmentLapMesg.addField(new Field("max_altitude", 35, 132, 5, 500, "m", false));
      field_index++;
      segmentLapMesg.addField(new Field("gps_accuracy", 36, 2, 1, 0, "m", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_grade", 37, 131, 100, 0, "%", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_pos_grade", 38, 131, 100, 0, "%", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_neg_grade", 39, 131, 100, 0, "%", false));
      field_index++;
      segmentLapMesg.addField(new Field("max_pos_grade", 40, 131, 100, 0, "%", false));
      field_index++;
      segmentLapMesg.addField(new Field("max_neg_grade", 41, 131, 100, 0, "%", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_temperature", 42, 1, 1, 0, "C", false));
      field_index++;
      segmentLapMesg.addField(new Field("max_temperature", 43, 1, 1, 0, "C", false));
      field_index++;
      segmentLapMesg.addField(new Field("total_moving_time", 44, 134, 1000, 0, "s", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_pos_vertical_speed", 45, 131, 1000, 0, "m/s", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_neg_vertical_speed", 46, 131, 1000, 0, "m/s", false));
      field_index++;
      segmentLapMesg.addField(new Field("max_pos_vertical_speed", 47, 131, 1000, 0, "m/s", false));
      field_index++;
      segmentLapMesg.addField(new Field("max_neg_vertical_speed", 48, 131, 1000, 0, "m/s", false));
      field_index++;
      segmentLapMesg.addField(new Field("time_in_hr_zone", 49, 134, 1000, 0, "s", false));
      field_index++;
      segmentLapMesg.addField(new Field("time_in_speed_zone", 50, 134, 1000, 0, "s", false));
      field_index++;
      segmentLapMesg.addField(new Field("time_in_cadence_zone", 51, 134, 1000, 0, "s", false));
      field_index++;
      segmentLapMesg.addField(new Field("time_in_power_zone", 52, 134, 1000, 0, "s", false));
      field_index++;
      segmentLapMesg.addField(new Field("repetition_num", 53, 132, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("min_altitude", 54, 132, 5, 500, "m", false));
      field_index++;
      segmentLapMesg.addField(new Field("min_heart_rate", 55, 2, 1, 0, "bpm", false));
      field_index++;
      segmentLapMesg.addField(new Field("active_time", 56, 134, 1000, 0, "s", false));
      field_index++;
      segmentLapMesg.addField(new Field("wkt_step_index", 57, 132, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("sport_event", 58, 0, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_left_torque_effectiveness", 59, 2, 2, 0, "percent", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_right_torque_effectiveness", 60, 2, 2, 0, "percent", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_left_pedal_smoothness", 61, 2, 2, 0, "percent", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_right_pedal_smoothness", 62, 2, 2, 0, "percent", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_combined_pedal_smoothness", 63, 2, 2, 0, "percent", false));
      field_index++;
      segmentLapMesg.addField(new Field("status", 64, 0, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("uuid", 65, 7, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_fractional_cadence", 66, 2, 128, 0, "rpm", false));
      field_index++;
      segmentLapMesg.addField(new Field("max_fractional_cadence", 67, 2, 128, 0, "rpm", false));
      field_index++;
      segmentLapMesg.addField(new Field("total_fractional_cycles", 68, 2, 128, 0, "cycles", false));
      field_index++;
      segmentLapMesg.addField(new Field("front_gear_shift_count", 69, 132, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("rear_gear_shift_count", 70, 132, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("time_standing", 71, 134, 1000, 0, "s", false));
      field_index++;
      segmentLapMesg.addField(new Field("stand_count", 72, 132, 1, 0, "", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_left_pco", 73, 1, 1, 0, "mm", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_right_pco", 74, 1, 1, 0, "mm", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_left_power_phase", 75, 2, 0.7111111, 0, "degrees", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_left_power_phase_peak", 76, 2, 0.7111111, 0, "degrees", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_right_power_phase", 77, 2, 0.7111111, 0, "degrees", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_right_power_phase_peak", 78, 2, 0.7111111, 0, "degrees", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_power_position", 79, 132, 1, 0, "watts", false));
      field_index++;
      segmentLapMesg.addField(new Field("max_power_position", 80, 132, 1, 0, "watts", false));
      field_index++;
      segmentLapMesg.addField(new Field("avg_cadence_position", 81, 2, 1, 0, "rpm", false));
      field_index++;
      segmentLapMesg.addField(new Field("max_cadence_position", 82, 2, 1, 0, "rpm", false));
      field_index++;
   }

   public SegmentLapMesg() {
      super(Factory.createMesg(MesgNum.SEGMENT_LAP));
   }

   public SegmentLapMesg(final Mesg mesg) {
      super(mesg);
   }


   /**
    * Get message_index field
    *
    * @return message_index
    */
   public Integer getMessageIndex() {
      return getFieldIntegerValue(254, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set message_index field
    *
    * @param messageIndex
    */
   public void setMessageIndex(Integer messageIndex) {
      setFieldValue(254, 0, messageIndex, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get timestamp field
    * Units: s
    * Comment: Lap end time.
    *
    * @return timestamp
    */
   public DateTime getTimestamp() {
      return timestampToDateTime(getFieldLongValue(253, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD));
   }

   /**
    * Set timestamp field
    * Units: s
    * Comment: Lap end time.
    *
    * @param timestamp
    */
   public void setTimestamp(DateTime timestamp) {
      setFieldValue(253, 0, timestamp.getTimestamp(), Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get event field
    *
    * @return event
    */
   public Event getEvent() {
      Short value = getFieldShortValue(0, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return Event.getByValue(value);
   }

   /**
    * Set event field
    *
    * @param event
    */
   public void setEvent(Event event) {
      setFieldValue(0, 0, event.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get event_type field
    *
    * @return event_type
    */
   public EventType getEventType() {
      Short value = getFieldShortValue(1, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return EventType.getByValue(value);
   }

   /**
    * Set event_type field
    *
    * @param eventType
    */
   public void setEventType(EventType eventType) {
      setFieldValue(1, 0, eventType.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get start_time field
    *
    * @return start_time
    */
   public DateTime getStartTime() {
      return timestampToDateTime(getFieldLongValue(2, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD));
   }

   /**
    * Set start_time field
    *
    * @param startTime
    */
   public void setStartTime(DateTime startTime) {
      setFieldValue(2, 0, startTime.getTimestamp(), Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get start_position_lat field
    * Units: semicircles
    *
    * @return start_position_lat
    */
   public Integer getStartPositionLat() {
      return getFieldIntegerValue(3, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set start_position_lat field
    * Units: semicircles
    *
    * @param startPositionLat
    */
   public void setStartPositionLat(Integer startPositionLat) {
      setFieldValue(3, 0, startPositionLat, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get start_position_long field
    * Units: semicircles
    *
    * @return start_position_long
    */
   public Integer getStartPositionLong() {
      return getFieldIntegerValue(4, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set start_position_long field
    * Units: semicircles
    *
    * @param startPositionLong
    */
   public void setStartPositionLong(Integer startPositionLong) {
      setFieldValue(4, 0, startPositionLong, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get end_position_lat field
    * Units: semicircles
    *
    * @return end_position_lat
    */
   public Integer getEndPositionLat() {
      return getFieldIntegerValue(5, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set end_position_lat field
    * Units: semicircles
    *
    * @param endPositionLat
    */
   public void setEndPositionLat(Integer endPositionLat) {
      setFieldValue(5, 0, endPositionLat, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get end_position_long field
    * Units: semicircles
    *
    * @return end_position_long
    */
   public Integer getEndPositionLong() {
      return getFieldIntegerValue(6, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set end_position_long field
    * Units: semicircles
    *
    * @param endPositionLong
    */
   public void setEndPositionLong(Integer endPositionLong) {
      setFieldValue(6, 0, endPositionLong, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_elapsed_time field
    * Units: s
    * Comment: Time (includes pauses)
    *
    * @return total_elapsed_time
    */
   public Float getTotalElapsedTime() {
      return getFieldFloatValue(7, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_elapsed_time field
    * Units: s
    * Comment: Time (includes pauses)
    *
    * @param totalElapsedTime
    */
   public void setTotalElapsedTime(Float totalElapsedTime) {
      setFieldValue(7, 0, totalElapsedTime, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_timer_time field
    * Units: s
    * Comment: Timer Time (excludes pauses)
    *
    * @return total_timer_time
    */
   public Float getTotalTimerTime() {
      return getFieldFloatValue(8, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_timer_time field
    * Units: s
    * Comment: Timer Time (excludes pauses)
    *
    * @param totalTimerTime
    */
   public void setTotalTimerTime(Float totalTimerTime) {
      setFieldValue(8, 0, totalTimerTime, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_distance field
    * Units: m
    *
    * @return total_distance
    */
   public Float getTotalDistance() {
      return getFieldFloatValue(9, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_distance field
    * Units: m
    *
    * @param totalDistance
    */
   public void setTotalDistance(Float totalDistance) {
      setFieldValue(9, 0, totalDistance, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_cycles field
    * Units: cycles
    *
    * @return total_cycles
    */
   public Long getTotalCycles() {
      return getFieldLongValue(10, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_cycles field
    * Units: cycles
    *
    * @param totalCycles
    */
   public void setTotalCycles(Long totalCycles) {
      setFieldValue(10, 0, totalCycles, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_strokes field
    * Units: strokes
    *
    * @return total_strokes
    */
   public Long getTotalStrokes() {
      return getFieldLongValue(10, 0, Profile.SubFields.SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STROKES);
   }

   /**
    * Set total_strokes field
    * Units: strokes
    *
    * @param totalStrokes
    */
   public void setTotalStrokes(Long totalStrokes) {
      setFieldValue(10, 0, totalStrokes, Profile.SubFields.SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STROKES);
   }

   /**
    * Get total_calories field
    * Units: kcal
    *
    * @return total_calories
    */
   public Integer getTotalCalories() {
      return getFieldIntegerValue(11, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_calories field
    * Units: kcal
    *
    * @param totalCalories
    */
   public void setTotalCalories(Integer totalCalories) {
      setFieldValue(11, 0, totalCalories, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_fat_calories field
    * Units: kcal
    * Comment: If New Leaf
    *
    * @return total_fat_calories
    */
   public Integer getTotalFatCalories() {
      return getFieldIntegerValue(12, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_fat_calories field
    * Units: kcal
    * Comment: If New Leaf
    *
    * @param totalFatCalories
    */
   public void setTotalFatCalories(Integer totalFatCalories) {
      setFieldValue(12, 0, totalFatCalories, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_speed field
    * Units: m/s
    *
    * @return avg_speed
    */
   public Float getAvgSpeed() {
      return getFieldFloatValue(13, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_speed field
    * Units: m/s
    *
    * @param avgSpeed
    */
   public void setAvgSpeed(Float avgSpeed) {
      setFieldValue(13, 0, avgSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_speed field
    * Units: m/s
    *
    * @return max_speed
    */
   public Float getMaxSpeed() {
      return getFieldFloatValue(14, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_speed field
    * Units: m/s
    *
    * @param maxSpeed
    */
   public void setMaxSpeed(Float maxSpeed) {
      setFieldValue(14, 0, maxSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_heart_rate field
    * Units: bpm
    *
    * @return avg_heart_rate
    */
   public Short getAvgHeartRate() {
      return getFieldShortValue(15, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_heart_rate field
    * Units: bpm
    *
    * @param avgHeartRate
    */
   public void setAvgHeartRate(Short avgHeartRate) {
      setFieldValue(15, 0, avgHeartRate, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_heart_rate field
    * Units: bpm
    *
    * @return max_heart_rate
    */
   public Short getMaxHeartRate() {
      return getFieldShortValue(16, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_heart_rate field
    * Units: bpm
    *
    * @param maxHeartRate
    */
   public void setMaxHeartRate(Short maxHeartRate) {
      setFieldValue(16, 0, maxHeartRate, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_cadence field
    * Units: rpm
    * Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
    *
    * @return avg_cadence
    */
   public Short getAvgCadence() {
      return getFieldShortValue(17, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_cadence field
    * Units: rpm
    * Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
    *
    * @param avgCadence
    */
   public void setAvgCadence(Short avgCadence) {
      setFieldValue(17, 0, avgCadence, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_cadence field
    * Units: rpm
    *
    * @return max_cadence
    */
   public Short getMaxCadence() {
      return getFieldShortValue(18, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_cadence field
    * Units: rpm
    *
    * @param maxCadence
    */
   public void setMaxCadence(Short maxCadence) {
      setFieldValue(18, 0, maxCadence, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_power field
    * Units: watts
    * Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
    *
    * @return avg_power
    */
   public Integer getAvgPower() {
      return getFieldIntegerValue(19, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_power field
    * Units: watts
    * Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
    *
    * @param avgPower
    */
   public void setAvgPower(Integer avgPower) {
      setFieldValue(19, 0, avgPower, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_power field
    * Units: watts
    *
    * @return max_power
    */
   public Integer getMaxPower() {
      return getFieldIntegerValue(20, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_power field
    * Units: watts
    *
    * @param maxPower
    */
   public void setMaxPower(Integer maxPower) {
      setFieldValue(20, 0, maxPower, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_ascent field
    * Units: m
    *
    * @return total_ascent
    */
   public Integer getTotalAscent() {
      return getFieldIntegerValue(21, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_ascent field
    * Units: m
    *
    * @param totalAscent
    */
   public void setTotalAscent(Integer totalAscent) {
      setFieldValue(21, 0, totalAscent, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_descent field
    * Units: m
    *
    * @return total_descent
    */
   public Integer getTotalDescent() {
      return getFieldIntegerValue(22, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_descent field
    * Units: m
    *
    * @param totalDescent
    */
   public void setTotalDescent(Integer totalDescent) {
      setFieldValue(22, 0, totalDescent, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get sport field
    *
    * @return sport
    */
   public Sport getSport() {
      Short value = getFieldShortValue(23, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return Sport.getByValue(value);
   }

   /**
    * Set sport field
    *
    * @param sport
    */
   public void setSport(Sport sport) {
      setFieldValue(23, 0, sport.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get event_group field
    *
    * @return event_group
    */
   public Short getEventGroup() {
      return getFieldShortValue(24, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set event_group field
    *
    * @param eventGroup
    */
   public void setEventGroup(Short eventGroup) {
      setFieldValue(24, 0, eventGroup, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get nec_lat field
    * Units: semicircles
    * Comment: North east corner latitude.
    *
    * @return nec_lat
    */
   public Integer getNecLat() {
      return getFieldIntegerValue(25, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set nec_lat field
    * Units: semicircles
    * Comment: North east corner latitude.
    *
    * @param necLat
    */
   public void setNecLat(Integer necLat) {
      setFieldValue(25, 0, necLat, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get nec_long field
    * Units: semicircles
    * Comment: North east corner longitude.
    *
    * @return nec_long
    */
   public Integer getNecLong() {
      return getFieldIntegerValue(26, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set nec_long field
    * Units: semicircles
    * Comment: North east corner longitude.
    *
    * @param necLong
    */
   public void setNecLong(Integer necLong) {
      setFieldValue(26, 0, necLong, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get swc_lat field
    * Units: semicircles
    * Comment: South west corner latitude.
    *
    * @return swc_lat
    */
   public Integer getSwcLat() {
      return getFieldIntegerValue(27, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set swc_lat field
    * Units: semicircles
    * Comment: South west corner latitude.
    *
    * @param swcLat
    */
   public void setSwcLat(Integer swcLat) {
      setFieldValue(27, 0, swcLat, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get swc_long field
    * Units: semicircles
    * Comment: South west corner latitude.
    *
    * @return swc_long
    */
   public Integer getSwcLong() {
      return getFieldIntegerValue(28, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set swc_long field
    * Units: semicircles
    * Comment: South west corner latitude.
    *
    * @param swcLong
    */
   public void setSwcLong(Integer swcLong) {
      setFieldValue(28, 0, swcLong, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get name field
    *
    * @return name
    */
   public String getName() {
      return getFieldStringValue(29, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set name field
    *
    * @param name
    */
   public void setName(String name) {
      setFieldValue(29, 0, name, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get normalized_power field
    * Units: watts
    *
    * @return normalized_power
    */
   public Integer getNormalizedPower() {
      return getFieldIntegerValue(30, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set normalized_power field
    * Units: watts
    *
    * @param normalizedPower
    */
   public void setNormalizedPower(Integer normalizedPower) {
      setFieldValue(30, 0, normalizedPower, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get left_right_balance field
    *
    * @return left_right_balance
    */
   public Integer getLeftRightBalance() {
      return getFieldIntegerValue(31, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set left_right_balance field
    *
    * @param leftRightBalance
    */
   public void setLeftRightBalance(Integer leftRightBalance) {
      setFieldValue(31, 0, leftRightBalance, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get sub_sport field
    *
    * @return sub_sport
    */
   public SubSport getSubSport() {
      Short value = getFieldShortValue(32, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return SubSport.getByValue(value);
   }

   /**
    * Set sub_sport field
    *
    * @param subSport
    */
   public void setSubSport(SubSport subSport) {
      setFieldValue(32, 0, subSport.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_work field
    * Units: J
    *
    * @return total_work
    */
   public Long getTotalWork() {
      return getFieldLongValue(33, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_work field
    * Units: J
    *
    * @param totalWork
    */
   public void setTotalWork(Long totalWork) {
      setFieldValue(33, 0, totalWork, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_altitude field
    * Units: m
    *
    * @return avg_altitude
    */
   public Float getAvgAltitude() {
      return getFieldFloatValue(34, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_altitude field
    * Units: m
    *
    * @param avgAltitude
    */
   public void setAvgAltitude(Float avgAltitude) {
      setFieldValue(34, 0, avgAltitude, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_altitude field
    * Units: m
    *
    * @return max_altitude
    */
   public Float getMaxAltitude() {
      return getFieldFloatValue(35, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_altitude field
    * Units: m
    *
    * @param maxAltitude
    */
   public void setMaxAltitude(Float maxAltitude) {
      setFieldValue(35, 0, maxAltitude, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get gps_accuracy field
    * Units: m
    *
    * @return gps_accuracy
    */
   public Short getGpsAccuracy() {
      return getFieldShortValue(36, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set gps_accuracy field
    * Units: m
    *
    * @param gpsAccuracy
    */
   public void setGpsAccuracy(Short gpsAccuracy) {
      setFieldValue(36, 0, gpsAccuracy, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_grade field
    * Units: %
    *
    * @return avg_grade
    */
   public Float getAvgGrade() {
      return getFieldFloatValue(37, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_grade field
    * Units: %
    *
    * @param avgGrade
    */
   public void setAvgGrade(Float avgGrade) {
      setFieldValue(37, 0, avgGrade, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_pos_grade field
    * Units: %
    *
    * @return avg_pos_grade
    */
   public Float getAvgPosGrade() {
      return getFieldFloatValue(38, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_pos_grade field
    * Units: %
    *
    * @param avgPosGrade
    */
   public void setAvgPosGrade(Float avgPosGrade) {
      setFieldValue(38, 0, avgPosGrade, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_neg_grade field
    * Units: %
    *
    * @return avg_neg_grade
    */
   public Float getAvgNegGrade() {
      return getFieldFloatValue(39, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_neg_grade field
    * Units: %
    *
    * @param avgNegGrade
    */
   public void setAvgNegGrade(Float avgNegGrade) {
      setFieldValue(39, 0, avgNegGrade, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_pos_grade field
    * Units: %
    *
    * @return max_pos_grade
    */
   public Float getMaxPosGrade() {
      return getFieldFloatValue(40, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_pos_grade field
    * Units: %
    *
    * @param maxPosGrade
    */
   public void setMaxPosGrade(Float maxPosGrade) {
      setFieldValue(40, 0, maxPosGrade, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_neg_grade field
    * Units: %
    *
    * @return max_neg_grade
    */
   public Float getMaxNegGrade() {
      return getFieldFloatValue(41, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_neg_grade field
    * Units: %
    *
    * @param maxNegGrade
    */
   public void setMaxNegGrade(Float maxNegGrade) {
      setFieldValue(41, 0, maxNegGrade, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_temperature field
    * Units: C
    *
    * @return avg_temperature
    */
   public Byte getAvgTemperature() {
      return getFieldByteValue(42, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_temperature field
    * Units: C
    *
    * @param avgTemperature
    */
   public void setAvgTemperature(Byte avgTemperature) {
      setFieldValue(42, 0, avgTemperature, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_temperature field
    * Units: C
    *
    * @return max_temperature
    */
   public Byte getMaxTemperature() {
      return getFieldByteValue(43, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_temperature field
    * Units: C
    *
    * @param maxTemperature
    */
   public void setMaxTemperature(Byte maxTemperature) {
      setFieldValue(43, 0, maxTemperature, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_moving_time field
    * Units: s
    *
    * @return total_moving_time
    */
   public Float getTotalMovingTime() {
      return getFieldFloatValue(44, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_moving_time field
    * Units: s
    *
    * @param totalMovingTime
    */
   public void setTotalMovingTime(Float totalMovingTime) {
      setFieldValue(44, 0, totalMovingTime, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_pos_vertical_speed field
    * Units: m/s
    *
    * @return avg_pos_vertical_speed
    */
   public Float getAvgPosVerticalSpeed() {
      return getFieldFloatValue(45, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_pos_vertical_speed field
    * Units: m/s
    *
    * @param avgPosVerticalSpeed
    */
   public void setAvgPosVerticalSpeed(Float avgPosVerticalSpeed) {
      setFieldValue(45, 0, avgPosVerticalSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_neg_vertical_speed field
    * Units: m/s
    *
    * @return avg_neg_vertical_speed
    */
   public Float getAvgNegVerticalSpeed() {
      return getFieldFloatValue(46, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_neg_vertical_speed field
    * Units: m/s
    *
    * @param avgNegVerticalSpeed
    */
   public void setAvgNegVerticalSpeed(Float avgNegVerticalSpeed) {
      setFieldValue(46, 0, avgNegVerticalSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_pos_vertical_speed field
    * Units: m/s
    *
    * @return max_pos_vertical_speed
    */
   public Float getMaxPosVerticalSpeed() {
      return getFieldFloatValue(47, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_pos_vertical_speed field
    * Units: m/s
    *
    * @param maxPosVerticalSpeed
    */
   public void setMaxPosVerticalSpeed(Float maxPosVerticalSpeed) {
      setFieldValue(47, 0, maxPosVerticalSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_neg_vertical_speed field
    * Units: m/s
    *
    * @return max_neg_vertical_speed
    */
   public Float getMaxNegVerticalSpeed() {
      return getFieldFloatValue(48, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_neg_vertical_speed field
    * Units: m/s
    *
    * @param maxNegVerticalSpeed
    */
   public void setMaxNegVerticalSpeed(Float maxNegVerticalSpeed) {
      setFieldValue(48, 0, maxNegVerticalSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of time_in_hr_zone
    */
   public int getNumTimeInHrZone() {
      return getNumFieldValues(49, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get time_in_hr_zone field
    * Units: s
    *
    * @param index of time_in_hr_zone
    * @return time_in_hr_zone
    */
   public Float getTimeInHrZone(int index) {
      return getFieldFloatValue(49, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set time_in_hr_zone field
    * Units: s
    *
    * @param index of time_in_hr_zone
    * @param timeInHrZone
    */
   public void setTimeInHrZone(int index, Float timeInHrZone) {
      setFieldValue(49, index, timeInHrZone, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of time_in_speed_zone
    */
   public int getNumTimeInSpeedZone() {
      return getNumFieldValues(50, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get time_in_speed_zone field
    * Units: s
    *
    * @param index of time_in_speed_zone
    * @return time_in_speed_zone
    */
   public Float getTimeInSpeedZone(int index) {
      return getFieldFloatValue(50, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set time_in_speed_zone field
    * Units: s
    *
    * @param index of time_in_speed_zone
    * @param timeInSpeedZone
    */
   public void setTimeInSpeedZone(int index, Float timeInSpeedZone) {
      setFieldValue(50, index, timeInSpeedZone, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of time_in_cadence_zone
    */
   public int getNumTimeInCadenceZone() {
      return getNumFieldValues(51, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get time_in_cadence_zone field
    * Units: s
    *
    * @param index of time_in_cadence_zone
    * @return time_in_cadence_zone
    */
   public Float getTimeInCadenceZone(int index) {
      return getFieldFloatValue(51, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set time_in_cadence_zone field
    * Units: s
    *
    * @param index of time_in_cadence_zone
    * @param timeInCadenceZone
    */
   public void setTimeInCadenceZone(int index, Float timeInCadenceZone) {
      setFieldValue(51, index, timeInCadenceZone, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of time_in_power_zone
    */
   public int getNumTimeInPowerZone() {
      return getNumFieldValues(52, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get time_in_power_zone field
    * Units: s
    *
    * @param index of time_in_power_zone
    * @return time_in_power_zone
    */
   public Float getTimeInPowerZone(int index) {
      return getFieldFloatValue(52, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set time_in_power_zone field
    * Units: s
    *
    * @param index of time_in_power_zone
    * @param timeInPowerZone
    */
   public void setTimeInPowerZone(int index, Float timeInPowerZone) {
      setFieldValue(52, index, timeInPowerZone, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get repetition_num field
    *
    * @return repetition_num
    */
   public Integer getRepetitionNum() {
      return getFieldIntegerValue(53, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set repetition_num field
    *
    * @param repetitionNum
    */
   public void setRepetitionNum(Integer repetitionNum) {
      setFieldValue(53, 0, repetitionNum, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get min_altitude field
    * Units: m
    *
    * @return min_altitude
    */
   public Float getMinAltitude() {
      return getFieldFloatValue(54, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set min_altitude field
    * Units: m
    *
    * @param minAltitude
    */
   public void setMinAltitude(Float minAltitude) {
      setFieldValue(54, 0, minAltitude, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get min_heart_rate field
    * Units: bpm
    *
    * @return min_heart_rate
    */
   public Short getMinHeartRate() {
      return getFieldShortValue(55, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set min_heart_rate field
    * Units: bpm
    *
    * @param minHeartRate
    */
   public void setMinHeartRate(Short minHeartRate) {
      setFieldValue(55, 0, minHeartRate, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get active_time field
    * Units: s
    *
    * @return active_time
    */
   public Float getActiveTime() {
      return getFieldFloatValue(56, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set active_time field
    * Units: s
    *
    * @param activeTime
    */
   public void setActiveTime(Float activeTime) {
      setFieldValue(56, 0, activeTime, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get wkt_step_index field
    *
    * @return wkt_step_index
    */
   public Integer getWktStepIndex() {
      return getFieldIntegerValue(57, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set wkt_step_index field
    *
    * @param wktStepIndex
    */
   public void setWktStepIndex(Integer wktStepIndex) {
      setFieldValue(57, 0, wktStepIndex, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get sport_event field
    *
    * @return sport_event
    */
   public SportEvent getSportEvent() {
      Short value = getFieldShortValue(58, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return SportEvent.getByValue(value);
   }

   /**
    * Set sport_event field
    *
    * @param sportEvent
    */
   public void setSportEvent(SportEvent sportEvent) {
      setFieldValue(58, 0, sportEvent.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_left_torque_effectiveness field
    * Units: percent
    *
    * @return avg_left_torque_effectiveness
    */
   public Float getAvgLeftTorqueEffectiveness() {
      return getFieldFloatValue(59, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_left_torque_effectiveness field
    * Units: percent
    *
    * @param avgLeftTorqueEffectiveness
    */
   public void setAvgLeftTorqueEffectiveness(Float avgLeftTorqueEffectiveness) {
      setFieldValue(59, 0, avgLeftTorqueEffectiveness, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_right_torque_effectiveness field
    * Units: percent
    *
    * @return avg_right_torque_effectiveness
    */
   public Float getAvgRightTorqueEffectiveness() {
      return getFieldFloatValue(60, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_right_torque_effectiveness field
    * Units: percent
    *
    * @param avgRightTorqueEffectiveness
    */
   public void setAvgRightTorqueEffectiveness(Float avgRightTorqueEffectiveness) {
      setFieldValue(60, 0, avgRightTorqueEffectiveness, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_left_pedal_smoothness field
    * Units: percent
    *
    * @return avg_left_pedal_smoothness
    */
   public Float getAvgLeftPedalSmoothness() {
      return getFieldFloatValue(61, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_left_pedal_smoothness field
    * Units: percent
    *
    * @param avgLeftPedalSmoothness
    */
   public void setAvgLeftPedalSmoothness(Float avgLeftPedalSmoothness) {
      setFieldValue(61, 0, avgLeftPedalSmoothness, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_right_pedal_smoothness field
    * Units: percent
    *
    * @return avg_right_pedal_smoothness
    */
   public Float getAvgRightPedalSmoothness() {
      return getFieldFloatValue(62, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_right_pedal_smoothness field
    * Units: percent
    *
    * @param avgRightPedalSmoothness
    */
   public void setAvgRightPedalSmoothness(Float avgRightPedalSmoothness) {
      setFieldValue(62, 0, avgRightPedalSmoothness, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_combined_pedal_smoothness field
    * Units: percent
    *
    * @return avg_combined_pedal_smoothness
    */
   public Float getAvgCombinedPedalSmoothness() {
      return getFieldFloatValue(63, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_combined_pedal_smoothness field
    * Units: percent
    *
    * @param avgCombinedPedalSmoothness
    */
   public void setAvgCombinedPedalSmoothness(Float avgCombinedPedalSmoothness) {
      setFieldValue(63, 0, avgCombinedPedalSmoothness, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get status field
    *
    * @return status
    */
   public SegmentLapStatus getStatus() {
      Short value = getFieldShortValue(64, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return SegmentLapStatus.getByValue(value);
   }

   /**
    * Set status field
    *
    * @param status
    */
   public void setStatus(SegmentLapStatus status) {
      setFieldValue(64, 0, status.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get uuid field
    *
    * @return uuid
    */
   public String getUuid() {
      return getFieldStringValue(65, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set uuid field
    *
    * @param uuid
    */
   public void setUuid(String uuid) {
      setFieldValue(65, 0, uuid, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_fractional_cadence field
    * Units: rpm
    * Comment: fractional part of the avg_cadence
    *
    * @return avg_fractional_cadence
    */
   public Float getAvgFractionalCadence() {
      return getFieldFloatValue(66, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_fractional_cadence field
    * Units: rpm
    * Comment: fractional part of the avg_cadence
    *
    * @param avgFractionalCadence
    */
   public void setAvgFractionalCadence(Float avgFractionalCadence) {
      setFieldValue(66, 0, avgFractionalCadence, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_fractional_cadence field
    * Units: rpm
    * Comment: fractional part of the max_cadence
    *
    * @return max_fractional_cadence
    */
   public Float getMaxFractionalCadence() {
      return getFieldFloatValue(67, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_fractional_cadence field
    * Units: rpm
    * Comment: fractional part of the max_cadence
    *
    * @param maxFractionalCadence
    */
   public void setMaxFractionalCadence(Float maxFractionalCadence) {
      setFieldValue(67, 0, maxFractionalCadence, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_fractional_cycles field
    * Units: cycles
    * Comment: fractional part of the total_cycles
    *
    * @return total_fractional_cycles
    */
   public Float getTotalFractionalCycles() {
      return getFieldFloatValue(68, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_fractional_cycles field
    * Units: cycles
    * Comment: fractional part of the total_cycles
    *
    * @param totalFractionalCycles
    */
   public void setTotalFractionalCycles(Float totalFractionalCycles) {
      setFieldValue(68, 0, totalFractionalCycles, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get front_gear_shift_count field
    *
    * @return front_gear_shift_count
    */
   public Integer getFrontGearShiftCount() {
      return getFieldIntegerValue(69, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set front_gear_shift_count field
    *
    * @param frontGearShiftCount
    */
   public void setFrontGearShiftCount(Integer frontGearShiftCount) {
      setFieldValue(69, 0, frontGearShiftCount, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get rear_gear_shift_count field
    *
    * @return rear_gear_shift_count
    */
   public Integer getRearGearShiftCount() {
      return getFieldIntegerValue(70, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set rear_gear_shift_count field
    *
    * @param rearGearShiftCount
    */
   public void setRearGearShiftCount(Integer rearGearShiftCount) {
      setFieldValue(70, 0, rearGearShiftCount, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get time_standing field
    * Units: s
    * Comment: Total time spent in the standing position
    *
    * @return time_standing
    */
   public Float getTimeStanding() {
      return getFieldFloatValue(71, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set time_standing field
    * Units: s
    * Comment: Total time spent in the standing position
    *
    * @param timeStanding
    */
   public void setTimeStanding(Float timeStanding) {
      setFieldValue(71, 0, timeStanding, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get stand_count field
    * Comment: Number of transitions to the standing state
    *
    * @return stand_count
    */
   public Integer getStandCount() {
      return getFieldIntegerValue(72, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set stand_count field
    * Comment: Number of transitions to the standing state
    *
    * @param standCount
    */
   public void setStandCount(Integer standCount) {
      setFieldValue(72, 0, standCount, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_left_pco field
    * Units: mm
    * Comment: Average left platform center offset
    *
    * @return avg_left_pco
    */
   public Byte getAvgLeftPco() {
      return getFieldByteValue(73, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_left_pco field
    * Units: mm
    * Comment: Average left platform center offset
    *
    * @param avgLeftPco
    */
   public void setAvgLeftPco(Byte avgLeftPco) {
      setFieldValue(73, 0, avgLeftPco, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_right_pco field
    * Units: mm
    * Comment: Average right platform center offset
    *
    * @return avg_right_pco
    */
   public Byte getAvgRightPco() {
      return getFieldByteValue(74, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_right_pco field
    * Units: mm
    * Comment: Average right platform center offset
    *
    * @param avgRightPco
    */
   public void setAvgRightPco(Byte avgRightPco) {
      setFieldValue(74, 0, avgRightPco, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_left_power_phase
    */
   public int getNumAvgLeftPowerPhase() {
      return getNumFieldValues(75, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_left_power_phase field
    * Units: degrees
    * Comment: Average left power phase angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_left_power_phase
    * @return avg_left_power_phase
    */
   public Float getAvgLeftPowerPhase(int index) {
      return getFieldFloatValue(75, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_left_power_phase field
    * Units: degrees
    * Comment: Average left power phase angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_left_power_phase
    * @param avgLeftPowerPhase
    */
   public void setAvgLeftPowerPhase(int index, Float avgLeftPowerPhase) {
      setFieldValue(75, index, avgLeftPowerPhase, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_left_power_phase_peak
    */
   public int getNumAvgLeftPowerPhasePeak() {
      return getNumFieldValues(76, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_left_power_phase_peak field
    * Units: degrees
    * Comment: Average left power phase peak angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_left_power_phase_peak
    * @return avg_left_power_phase_peak
    */
   public Float getAvgLeftPowerPhasePeak(int index) {
      return getFieldFloatValue(76, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_left_power_phase_peak field
    * Units: degrees
    * Comment: Average left power phase peak angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_left_power_phase_peak
    * @param avgLeftPowerPhasePeak
    */
   public void setAvgLeftPowerPhasePeak(int index, Float avgLeftPowerPhasePeak) {
      setFieldValue(76, index, avgLeftPowerPhasePeak, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_right_power_phase
    */
   public int getNumAvgRightPowerPhase() {
      return getNumFieldValues(77, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_right_power_phase field
    * Units: degrees
    * Comment: Average right power phase angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_right_power_phase
    * @return avg_right_power_phase
    */
   public Float getAvgRightPowerPhase(int index) {
      return getFieldFloatValue(77, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_right_power_phase field
    * Units: degrees
    * Comment: Average right power phase angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_right_power_phase
    * @param avgRightPowerPhase
    */
   public void setAvgRightPowerPhase(int index, Float avgRightPowerPhase) {
      setFieldValue(77, index, avgRightPowerPhase, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_right_power_phase_peak
    */
   public int getNumAvgRightPowerPhasePeak() {
      return getNumFieldValues(78, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_right_power_phase_peak field
    * Units: degrees
    * Comment: Average right power phase peak angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_right_power_phase_peak
    * @return avg_right_power_phase_peak
    */
   public Float getAvgRightPowerPhasePeak(int index) {
      return getFieldFloatValue(78, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_right_power_phase_peak field
    * Units: degrees
    * Comment: Average right power phase peak angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_right_power_phase_peak
    * @param avgRightPowerPhasePeak
    */
   public void setAvgRightPowerPhasePeak(int index, Float avgRightPowerPhasePeak) {
      setFieldValue(78, index, avgRightPowerPhasePeak, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_power_position
    */
   public int getNumAvgPowerPosition() {
      return getNumFieldValues(79, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_power_position field
    * Units: watts
    * Comment: Average power by position. Data value indexes defined by rider_position_type.
    *
    * @param index of avg_power_position
    * @return avg_power_position
    */
   public Integer getAvgPowerPosition(int index) {
      return getFieldIntegerValue(79, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_power_position field
    * Units: watts
    * Comment: Average power by position. Data value indexes defined by rider_position_type.
    *
    * @param index of avg_power_position
    * @param avgPowerPosition
    */
   public void setAvgPowerPosition(int index, Integer avgPowerPosition) {
      setFieldValue(79, index, avgPowerPosition, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of max_power_position
    */
   public int getNumMaxPowerPosition() {
      return getNumFieldValues(80, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_power_position field
    * Units: watts
    * Comment: Maximum power by position. Data value indexes defined by rider_position_type.
    *
    * @param index of max_power_position
    * @return max_power_position
    */
   public Integer getMaxPowerPosition(int index) {
      return getFieldIntegerValue(80, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_power_position field
    * Units: watts
    * Comment: Maximum power by position. Data value indexes defined by rider_position_type.
    *
    * @param index of max_power_position
    * @param maxPowerPosition
    */
   public void setMaxPowerPosition(int index, Integer maxPowerPosition) {
      setFieldValue(80, index, maxPowerPosition, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_cadence_position
    */
   public int getNumAvgCadencePosition() {
      return getNumFieldValues(81, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_cadence_position field
    * Units: rpm
    * Comment: Average cadence by position. Data value indexes defined by rider_position_type.
    *
    * @param index of avg_cadence_position
    * @return avg_cadence_position
    */
   public Short getAvgCadencePosition(int index) {
      return getFieldShortValue(81, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_cadence_position field
    * Units: rpm
    * Comment: Average cadence by position. Data value indexes defined by rider_position_type.
    *
    * @param index of avg_cadence_position
    * @param avgCadencePosition
    */
   public void setAvgCadencePosition(int index, Short avgCadencePosition) {
      setFieldValue(81, index, avgCadencePosition, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of max_cadence_position
    */
   public int getNumMaxCadencePosition() {
      return getNumFieldValues(82, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_cadence_position field
    * Units: rpm
    * Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.
    *
    * @param index of max_cadence_position
    * @return max_cadence_position
    */
   public Short getMaxCadencePosition(int index) {
      return getFieldShortValue(82, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_cadence_position field
    * Units: rpm
    * Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.
    *
    * @param index of max_cadence_position
    * @param maxCadencePosition
    */
   public void setMaxCadencePosition(int index, Short maxCadencePosition) {
      setFieldValue(82, index, maxCadencePosition, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

}
