////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Dynastream Innovations Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2015 Dynastream Innovations Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 16.10Release
// Tag = development-akw-16.10.00-0
////////////////////////////////////////////////////////////////////////////////


package com.garmin.fit;


public class SessionMesg extends Mesg implements MesgWithEvent {

   protected static final	Mesg sessionMesg;
   static {            
      int field_index = 0;
      int subfield_index = 0;         
      // session   
      sessionMesg = new Mesg("session", MesgNum.SESSION);
      sessionMesg.addField(new Field("message_index", 254, 132, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("timestamp", 253, 134, 1, 0, "s", false));
      field_index++;
      sessionMesg.addField(new Field("event", 0, 0, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("event_type", 1, 0, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("start_time", 2, 134, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("start_position_lat", 3, 133, 1, 0, "semicircles", false));
      field_index++;
      sessionMesg.addField(new Field("start_position_long", 4, 133, 1, 0, "semicircles", false));
      field_index++;
      sessionMesg.addField(new Field("sport", 5, 0, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("sub_sport", 6, 0, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("total_elapsed_time", 7, 134, 1000, 0, "s", false));
      field_index++;
      sessionMesg.addField(new Field("total_timer_time", 8, 134, 1000, 0, "s", false));
      field_index++;
      sessionMesg.addField(new Field("total_distance", 9, 134, 100, 0, "m", false));
      field_index++;
      sessionMesg.addField(new Field("total_cycles", 10, 134, 1, 0, "cycles", false));
      subfield_index = 0;
      sessionMesg.fields.get(field_index).subFields.add(new SubField("total_strides", 134, 1, 0, "strides"));
      sessionMesg.fields.get(field_index).subFields.get(subfield_index).addMap(5, 1);
      sessionMesg.fields.get(field_index).subFields.get(subfield_index).addMap(5, 11);
      subfield_index++;
      field_index++;
      sessionMesg.addField(new Field("total_calories", 11, 132, 1, 0, "kcal", false));
      field_index++;
      sessionMesg.addField(new Field("total_fat_calories", 13, 132, 1, 0, "kcal", false));
      field_index++;
      sessionMesg.addField(new Field("avg_speed", 14, 132, 1000, 0, "m/s", false)); 
      sessionMesg.fields.get(field_index).components.add(new FieldComponent(124, false, 16, 1000, 0)); // enhanced_avg_speed
      field_index++;
      sessionMesg.addField(new Field("max_speed", 15, 132, 1000, 0, "m/s", false)); 
      sessionMesg.fields.get(field_index).components.add(new FieldComponent(125, false, 16, 1000, 0)); // enhanced_max_speed
      field_index++;
      sessionMesg.addField(new Field("avg_heart_rate", 16, 2, 1, 0, "bpm", false));
      field_index++;
      sessionMesg.addField(new Field("max_heart_rate", 17, 2, 1, 0, "bpm", false));
      field_index++;
      sessionMesg.addField(new Field("avg_cadence", 18, 2, 1, 0, "rpm", false));
      subfield_index = 0;
      sessionMesg.fields.get(field_index).subFields.add(new SubField("avg_running_cadence", 2, 1, 0, "strides/min"));
      sessionMesg.fields.get(field_index).subFields.get(subfield_index).addMap(5, 1);
      subfield_index++;
      field_index++;
      sessionMesg.addField(new Field("max_cadence", 19, 2, 1, 0, "rpm", false));
      subfield_index = 0;
      sessionMesg.fields.get(field_index).subFields.add(new SubField("max_running_cadence", 2, 1, 0, "strides/min"));
      sessionMesg.fields.get(field_index).subFields.get(subfield_index).addMap(5, 1);
      subfield_index++;
      field_index++;
      sessionMesg.addField(new Field("avg_power", 20, 132, 1, 0, "watts", false));
      field_index++;
      sessionMesg.addField(new Field("max_power", 21, 132, 1, 0, "watts", false));
      field_index++;
      sessionMesg.addField(new Field("total_ascent", 22, 132, 1, 0, "m", false));
      field_index++;
      sessionMesg.addField(new Field("total_descent", 23, 132, 1, 0, "m", false));
      field_index++;
      sessionMesg.addField(new Field("total_training_effect", 24, 2, 10, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("first_lap_index", 25, 132, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("num_laps", 26, 132, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("event_group", 27, 2, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("trigger", 28, 0, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("nec_lat", 29, 133, 1, 0, "semicircles", false));
      field_index++;
      sessionMesg.addField(new Field("nec_long", 30, 133, 1, 0, "semicircles", false));
      field_index++;
      sessionMesg.addField(new Field("swc_lat", 31, 133, 1, 0, "semicircles", false));
      field_index++;
      sessionMesg.addField(new Field("swc_long", 32, 133, 1, 0, "semicircles", false));
      field_index++;
      sessionMesg.addField(new Field("normalized_power", 34, 132, 1, 0, "watts", false));
      field_index++;
      sessionMesg.addField(new Field("training_stress_score", 35, 132, 10, 0, "tss", false));
      field_index++;
      sessionMesg.addField(new Field("intensity_factor", 36, 132, 1000, 0, "if", false));
      field_index++;
      sessionMesg.addField(new Field("left_right_balance", 37, 132, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("avg_stroke_count", 41, 134, 10, 0, "strokes/lap", false));
      field_index++;
      sessionMesg.addField(new Field("avg_stroke_distance", 42, 132, 100, 0, "m", false));
      field_index++;
      sessionMesg.addField(new Field("swim_stroke", 43, 0, 1, 0, "swim_stroke", false));
      field_index++;
      sessionMesg.addField(new Field("pool_length", 44, 132, 100, 0, "m", false));
      field_index++;
      sessionMesg.addField(new Field("threshold_power", 45, 132, 1, 0, "watts", false));
      field_index++;
      sessionMesg.addField(new Field("pool_length_unit", 46, 0, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("num_active_lengths", 47, 132, 1, 0, "lengths", false));
      field_index++;
      sessionMesg.addField(new Field("total_work", 48, 134, 1, 0, "J", false));
      field_index++;
      sessionMesg.addField(new Field("avg_altitude", 49, 132, 5, 500, "m", false)); 
      sessionMesg.fields.get(field_index).components.add(new FieldComponent(126, false, 16, 5, 500)); // enhanced_avg_altitude
      field_index++;
      sessionMesg.addField(new Field("max_altitude", 50, 132, 5, 500, "m", false)); 
      sessionMesg.fields.get(field_index).components.add(new FieldComponent(128, false, 16, 5, 500)); // enhanced_max_altitude
      field_index++;
      sessionMesg.addField(new Field("gps_accuracy", 51, 2, 1, 0, "m", false));
      field_index++;
      sessionMesg.addField(new Field("avg_grade", 52, 131, 100, 0, "%", false));
      field_index++;
      sessionMesg.addField(new Field("avg_pos_grade", 53, 131, 100, 0, "%", false));
      field_index++;
      sessionMesg.addField(new Field("avg_neg_grade", 54, 131, 100, 0, "%", false));
      field_index++;
      sessionMesg.addField(new Field("max_pos_grade", 55, 131, 100, 0, "%", false));
      field_index++;
      sessionMesg.addField(new Field("max_neg_grade", 56, 131, 100, 0, "%", false));
      field_index++;
      sessionMesg.addField(new Field("avg_temperature", 57, 1, 1, 0, "C", false));
      field_index++;
      sessionMesg.addField(new Field("max_temperature", 58, 1, 1, 0, "C", false));
      field_index++;
      sessionMesg.addField(new Field("total_moving_time", 59, 134, 1000, 0, "s", false));
      field_index++;
      sessionMesg.addField(new Field("avg_pos_vertical_speed", 60, 131, 1000, 0, "m/s", false));
      field_index++;
      sessionMesg.addField(new Field("avg_neg_vertical_speed", 61, 131, 1000, 0, "m/s", false));
      field_index++;
      sessionMesg.addField(new Field("max_pos_vertical_speed", 62, 131, 1000, 0, "m/s", false));
      field_index++;
      sessionMesg.addField(new Field("max_neg_vertical_speed", 63, 131, 1000, 0, "m/s", false));
      field_index++;
      sessionMesg.addField(new Field("min_heart_rate", 64, 2, 1, 0, "bpm", false));
      field_index++;
      sessionMesg.addField(new Field("time_in_hr_zone", 65, 134, 1000, 0, "s", false));
      field_index++;
      sessionMesg.addField(new Field("time_in_speed_zone", 66, 134, 1000, 0, "s", false));
      field_index++;
      sessionMesg.addField(new Field("time_in_cadence_zone", 67, 134, 1000, 0, "s", false));
      field_index++;
      sessionMesg.addField(new Field("time_in_power_zone", 68, 134, 1000, 0, "s", false));
      field_index++;
      sessionMesg.addField(new Field("avg_lap_time", 69, 134, 1000, 0, "s", false));
      field_index++;
      sessionMesg.addField(new Field("best_lap_index", 70, 132, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("min_altitude", 71, 132, 5, 500, "m", false)); 
      sessionMesg.fields.get(field_index).components.add(new FieldComponent(127, false, 16, 5, 500)); // enhanced_min_altitude
      field_index++;
      sessionMesg.addField(new Field("player_score", 82, 132, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("opponent_score", 83, 132, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("opponent_name", 84, 7, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("stroke_count", 85, 132, 1, 0, "counts", false));
      field_index++;
      sessionMesg.addField(new Field("zone_count", 86, 132, 1, 0, "counts", false));
      field_index++;
      sessionMesg.addField(new Field("max_ball_speed", 87, 132, 100, 0, "m/s", false));
      field_index++;
      sessionMesg.addField(new Field("avg_ball_speed", 88, 132, 100, 0, "m/s", false));
      field_index++;
      sessionMesg.addField(new Field("avg_vertical_oscillation", 89, 132, 10, 0, "mm", false));
      field_index++;
      sessionMesg.addField(new Field("avg_stance_time_percent", 90, 132, 100, 0, "percent", false));
      field_index++;
      sessionMesg.addField(new Field("avg_stance_time", 91, 132, 10, 0, "ms", false));
      field_index++;
      sessionMesg.addField(new Field("avg_fractional_cadence", 92, 2, 128, 0, "rpm", false));
      field_index++;
      sessionMesg.addField(new Field("max_fractional_cadence", 93, 2, 128, 0, "rpm", false));
      field_index++;
      sessionMesg.addField(new Field("total_fractional_cycles", 94, 2, 128, 0, "cycles", false));
      field_index++;
      sessionMesg.addField(new Field("avg_total_hemoglobin_conc", 95, 132, 100, 0, "g/dL", false));
      field_index++;
      sessionMesg.addField(new Field("min_total_hemoglobin_conc", 96, 132, 100, 0, "g/dL", false));
      field_index++;
      sessionMesg.addField(new Field("max_total_hemoglobin_conc", 97, 132, 100, 0, "g/dL", false));
      field_index++;
      sessionMesg.addField(new Field("avg_saturated_hemoglobin_percent", 98, 132, 10, 0, "%", false));
      field_index++;
      sessionMesg.addField(new Field("min_saturated_hemoglobin_percent", 99, 132, 10, 0, "%", false));
      field_index++;
      sessionMesg.addField(new Field("max_saturated_hemoglobin_percent", 100, 132, 10, 0, "%", false));
      field_index++;
      sessionMesg.addField(new Field("avg_left_torque_effectiveness", 101, 2, 2, 0, "percent", false));
      field_index++;
      sessionMesg.addField(new Field("avg_right_torque_effectiveness", 102, 2, 2, 0, "percent", false));
      field_index++;
      sessionMesg.addField(new Field("avg_left_pedal_smoothness", 103, 2, 2, 0, "percent", false));
      field_index++;
      sessionMesg.addField(new Field("avg_right_pedal_smoothness", 104, 2, 2, 0, "percent", false));
      field_index++;
      sessionMesg.addField(new Field("avg_combined_pedal_smoothness", 105, 2, 2, 0, "percent", false));
      field_index++;
      sessionMesg.addField(new Field("sport_index", 111, 2, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("time_standing", 112, 134, 1000, 0, "s", false));
      field_index++;
      sessionMesg.addField(new Field("stand_count", 113, 132, 1, 0, "", false));
      field_index++;
      sessionMesg.addField(new Field("avg_left_pco", 114, 1, 1, 0, "mm", false));
      field_index++;
      sessionMesg.addField(new Field("avg_right_pco", 115, 1, 1, 0, "mm", false));
      field_index++;
      sessionMesg.addField(new Field("avg_left_power_phase", 116, 2, 0.7111111, 0, "degrees", false));
      field_index++;
      sessionMesg.addField(new Field("avg_left_power_phase_peak", 117, 2, 0.7111111, 0, "degrees", false));
      field_index++;
      sessionMesg.addField(new Field("avg_right_power_phase", 118, 2, 0.7111111, 0, "degrees", false));
      field_index++;
      sessionMesg.addField(new Field("avg_right_power_phase_peak", 119, 2, 0.7111111, 0, "degrees", false));
      field_index++;
      sessionMesg.addField(new Field("avg_power_position", 120, 132, 1, 0, "watts", false));
      field_index++;
      sessionMesg.addField(new Field("max_power_position", 121, 132, 1, 0, "watts", false));
      field_index++;
      sessionMesg.addField(new Field("avg_cadence_position", 122, 2, 1, 0, "rpm", false));
      field_index++;
      sessionMesg.addField(new Field("max_cadence_position", 123, 2, 1, 0, "rpm", false));
      field_index++;
      sessionMesg.addField(new Field("enhanced_avg_speed", 124, 134, 1000, 0, "m/s", false));
      field_index++;
      sessionMesg.addField(new Field("enhanced_max_speed", 125, 134, 1000, 0, "m/s", false));
      field_index++;
      sessionMesg.addField(new Field("enhanced_avg_altitude", 126, 134, 5, 500, "m", false));
      field_index++;
      sessionMesg.addField(new Field("enhanced_min_altitude", 127, 134, 5, 500, "m", false));
      field_index++;
      sessionMesg.addField(new Field("enhanced_max_altitude", 128, 134, 5, 500, "m", false));
      field_index++;
      sessionMesg.addField(new Field("avg_lev_motor_power", 129, 132, 1, 0, "watts", false));
      field_index++;
      sessionMesg.addField(new Field("max_lev_motor_power", 130, 132, 1, 0, "watts", false));
      field_index++;
      sessionMesg.addField(new Field("lev_battery_consumption", 131, 2, 2, 0, "percent", false));
      field_index++;
   }

   public SessionMesg() {
      super(Factory.createMesg(MesgNum.SESSION));
   }

   public SessionMesg(final Mesg mesg) {
      super(mesg);
   }


   /**
    * Get message_index field
    * Comment: Selected bit is set for the current session.
    *
    * @return message_index
    */
   public Integer getMessageIndex() {
      return getFieldIntegerValue(254, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set message_index field
    * Comment: Selected bit is set for the current session.
    *
    * @param messageIndex
    */
   public void setMessageIndex(Integer messageIndex) {
      setFieldValue(254, 0, messageIndex, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get timestamp field
    * Units: s
    * Comment: Sesson end time.
    *
    * @return timestamp
    */
   public DateTime getTimestamp() {
      return timestampToDateTime(getFieldLongValue(253, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD));
   }

   /**
    * Set timestamp field
    * Units: s
    * Comment: Sesson end time.
    *
    * @param timestamp
    */
   public void setTimestamp(DateTime timestamp) {
      setFieldValue(253, 0, timestamp.getTimestamp(), Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get event field
    * Comment: session
    *
    * @return event
    */
   public Event getEvent() {
      Short value = getFieldShortValue(0, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return Event.getByValue(value);
   }

   /**
    * Set event field
    * Comment: session
    *
    * @param event
    */
   public void setEvent(Event event) {
      setFieldValue(0, 0, event.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get event_type field
    * Comment: stop
    *
    * @return event_type
    */
   public EventType getEventType() {
      Short value = getFieldShortValue(1, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return EventType.getByValue(value);
   }

   /**
    * Set event_type field
    * Comment: stop
    *
    * @param eventType
    */
   public void setEventType(EventType eventType) {
      setFieldValue(1, 0, eventType.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get start_time field
    *
    * @return start_time
    */
   public DateTime getStartTime() {
      return timestampToDateTime(getFieldLongValue(2, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD));
   }

   /**
    * Set start_time field
    *
    * @param startTime
    */
   public void setStartTime(DateTime startTime) {
      setFieldValue(2, 0, startTime.getTimestamp(), Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get start_position_lat field
    * Units: semicircles
    *
    * @return start_position_lat
    */
   public Integer getStartPositionLat() {
      return getFieldIntegerValue(3, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set start_position_lat field
    * Units: semicircles
    *
    * @param startPositionLat
    */
   public void setStartPositionLat(Integer startPositionLat) {
      setFieldValue(3, 0, startPositionLat, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get start_position_long field
    * Units: semicircles
    *
    * @return start_position_long
    */
   public Integer getStartPositionLong() {
      return getFieldIntegerValue(4, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set start_position_long field
    * Units: semicircles
    *
    * @param startPositionLong
    */
   public void setStartPositionLong(Integer startPositionLong) {
      setFieldValue(4, 0, startPositionLong, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get sport field
    *
    * @return sport
    */
   public Sport getSport() {
      Short value = getFieldShortValue(5, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return Sport.getByValue(value);
   }

   /**
    * Set sport field
    *
    * @param sport
    */
   public void setSport(Sport sport) {
      setFieldValue(5, 0, sport.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get sub_sport field
    *
    * @return sub_sport
    */
   public SubSport getSubSport() {
      Short value = getFieldShortValue(6, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return SubSport.getByValue(value);
   }

   /**
    * Set sub_sport field
    *
    * @param subSport
    */
   public void setSubSport(SubSport subSport) {
      setFieldValue(6, 0, subSport.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_elapsed_time field
    * Units: s
    * Comment: Time (includes pauses)
    *
    * @return total_elapsed_time
    */
   public Float getTotalElapsedTime() {
      return getFieldFloatValue(7, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_elapsed_time field
    * Units: s
    * Comment: Time (includes pauses)
    *
    * @param totalElapsedTime
    */
   public void setTotalElapsedTime(Float totalElapsedTime) {
      setFieldValue(7, 0, totalElapsedTime, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_timer_time field
    * Units: s
    * Comment: Timer Time (excludes pauses)
    *
    * @return total_timer_time
    */
   public Float getTotalTimerTime() {
      return getFieldFloatValue(8, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_timer_time field
    * Units: s
    * Comment: Timer Time (excludes pauses)
    *
    * @param totalTimerTime
    */
   public void setTotalTimerTime(Float totalTimerTime) {
      setFieldValue(8, 0, totalTimerTime, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_distance field
    * Units: m
    *
    * @return total_distance
    */
   public Float getTotalDistance() {
      return getFieldFloatValue(9, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_distance field
    * Units: m
    *
    * @param totalDistance
    */
   public void setTotalDistance(Float totalDistance) {
      setFieldValue(9, 0, totalDistance, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_cycles field
    * Units: cycles
    *
    * @return total_cycles
    */
   public Long getTotalCycles() {
      return getFieldLongValue(10, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_cycles field
    * Units: cycles
    *
    * @param totalCycles
    */
   public void setTotalCycles(Long totalCycles) {
      setFieldValue(10, 0, totalCycles, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_strides field
    * Units: strides
    *
    * @return total_strides
    */
   public Long getTotalStrides() {
      return getFieldLongValue(10, 0, Profile.SubFields.SESSION_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES);
   }

   /**
    * Set total_strides field
    * Units: strides
    *
    * @param totalStrides
    */
   public void setTotalStrides(Long totalStrides) {
      setFieldValue(10, 0, totalStrides, Profile.SubFields.SESSION_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES);
   }

   /**
    * Get total_calories field
    * Units: kcal
    *
    * @return total_calories
    */
   public Integer getTotalCalories() {
      return getFieldIntegerValue(11, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_calories field
    * Units: kcal
    *
    * @param totalCalories
    */
   public void setTotalCalories(Integer totalCalories) {
      setFieldValue(11, 0, totalCalories, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_fat_calories field
    * Units: kcal
    *
    * @return total_fat_calories
    */
   public Integer getTotalFatCalories() {
      return getFieldIntegerValue(13, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_fat_calories field
    * Units: kcal
    *
    * @param totalFatCalories
    */
   public void setTotalFatCalories(Integer totalFatCalories) {
      setFieldValue(13, 0, totalFatCalories, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_speed field
    * Units: m/s
    * Comment: total_distance / total_timer_time
    *
    * @return avg_speed
    */
   public Float getAvgSpeed() {
      return getFieldFloatValue(14, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_speed field
    * Units: m/s
    * Comment: total_distance / total_timer_time
    *
    * @param avgSpeed
    */
   public void setAvgSpeed(Float avgSpeed) {
      setFieldValue(14, 0, avgSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_speed field
    * Units: m/s
    *
    * @return max_speed
    */
   public Float getMaxSpeed() {
      return getFieldFloatValue(15, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_speed field
    * Units: m/s
    *
    * @param maxSpeed
    */
   public void setMaxSpeed(Float maxSpeed) {
      setFieldValue(15, 0, maxSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_heart_rate field
    * Units: bpm
    * Comment: average heart rate (excludes pause time)
    *
    * @return avg_heart_rate
    */
   public Short getAvgHeartRate() {
      return getFieldShortValue(16, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_heart_rate field
    * Units: bpm
    * Comment: average heart rate (excludes pause time)
    *
    * @param avgHeartRate
    */
   public void setAvgHeartRate(Short avgHeartRate) {
      setFieldValue(16, 0, avgHeartRate, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_heart_rate field
    * Units: bpm
    *
    * @return max_heart_rate
    */
   public Short getMaxHeartRate() {
      return getFieldShortValue(17, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_heart_rate field
    * Units: bpm
    *
    * @param maxHeartRate
    */
   public void setMaxHeartRate(Short maxHeartRate) {
      setFieldValue(17, 0, maxHeartRate, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_cadence field
    * Units: rpm
    * Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
    *
    * @return avg_cadence
    */
   public Short getAvgCadence() {
      return getFieldShortValue(18, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_cadence field
    * Units: rpm
    * Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
    *
    * @param avgCadence
    */
   public void setAvgCadence(Short avgCadence) {
      setFieldValue(18, 0, avgCadence, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_running_cadence field
    * Units: strides/min
    *
    * @return avg_running_cadence
    */
   public Short getAvgRunningCadence() {
      return getFieldShortValue(18, 0, Profile.SubFields.SESSION_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE);
   }

   /**
    * Set avg_running_cadence field
    * Units: strides/min
    *
    * @param avgRunningCadence
    */
   public void setAvgRunningCadence(Short avgRunningCadence) {
      setFieldValue(18, 0, avgRunningCadence, Profile.SubFields.SESSION_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE);
   }

   /**
    * Get max_cadence field
    * Units: rpm
    *
    * @return max_cadence
    */
   public Short getMaxCadence() {
      return getFieldShortValue(19, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_cadence field
    * Units: rpm
    *
    * @param maxCadence
    */
   public void setMaxCadence(Short maxCadence) {
      setFieldValue(19, 0, maxCadence, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_running_cadence field
    * Units: strides/min
    *
    * @return max_running_cadence
    */
   public Short getMaxRunningCadence() {
      return getFieldShortValue(19, 0, Profile.SubFields.SESSION_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE);
   }

   /**
    * Set max_running_cadence field
    * Units: strides/min
    *
    * @param maxRunningCadence
    */
   public void setMaxRunningCadence(Short maxRunningCadence) {
      setFieldValue(19, 0, maxRunningCadence, Profile.SubFields.SESSION_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE);
   }

   /**
    * Get avg_power field
    * Units: watts
    * Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
    *
    * @return avg_power
    */
   public Integer getAvgPower() {
      return getFieldIntegerValue(20, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_power field
    * Units: watts
    * Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
    *
    * @param avgPower
    */
   public void setAvgPower(Integer avgPower) {
      setFieldValue(20, 0, avgPower, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_power field
    * Units: watts
    *
    * @return max_power
    */
   public Integer getMaxPower() {
      return getFieldIntegerValue(21, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_power field
    * Units: watts
    *
    * @param maxPower
    */
   public void setMaxPower(Integer maxPower) {
      setFieldValue(21, 0, maxPower, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_ascent field
    * Units: m
    *
    * @return total_ascent
    */
   public Integer getTotalAscent() {
      return getFieldIntegerValue(22, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_ascent field
    * Units: m
    *
    * @param totalAscent
    */
   public void setTotalAscent(Integer totalAscent) {
      setFieldValue(22, 0, totalAscent, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_descent field
    * Units: m
    *
    * @return total_descent
    */
   public Integer getTotalDescent() {
      return getFieldIntegerValue(23, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_descent field
    * Units: m
    *
    * @param totalDescent
    */
   public void setTotalDescent(Integer totalDescent) {
      setFieldValue(23, 0, totalDescent, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_training_effect field
    *
    * @return total_training_effect
    */
   public Float getTotalTrainingEffect() {
      return getFieldFloatValue(24, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_training_effect field
    *
    * @param totalTrainingEffect
    */
   public void setTotalTrainingEffect(Float totalTrainingEffect) {
      setFieldValue(24, 0, totalTrainingEffect, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get first_lap_index field
    *
    * @return first_lap_index
    */
   public Integer getFirstLapIndex() {
      return getFieldIntegerValue(25, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set first_lap_index field
    *
    * @param firstLapIndex
    */
   public void setFirstLapIndex(Integer firstLapIndex) {
      setFieldValue(25, 0, firstLapIndex, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get num_laps field
    *
    * @return num_laps
    */
   public Integer getNumLaps() {
      return getFieldIntegerValue(26, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set num_laps field
    *
    * @param numLaps
    */
   public void setNumLaps(Integer numLaps) {
      setFieldValue(26, 0, numLaps, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get event_group field
    *
    * @return event_group
    */
   public Short getEventGroup() {
      return getFieldShortValue(27, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set event_group field
    *
    * @param eventGroup
    */
   public void setEventGroup(Short eventGroup) {
      setFieldValue(27, 0, eventGroup, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get trigger field
    *
    * @return trigger
    */
   public SessionTrigger getTrigger() {
      Short value = getFieldShortValue(28, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return SessionTrigger.getByValue(value);
   }

   /**
    * Set trigger field
    *
    * @param trigger
    */
   public void setTrigger(SessionTrigger trigger) {
      setFieldValue(28, 0, trigger.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get nec_lat field
    * Units: semicircles
    *
    * @return nec_lat
    */
   public Integer getNecLat() {
      return getFieldIntegerValue(29, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set nec_lat field
    * Units: semicircles
    *
    * @param necLat
    */
   public void setNecLat(Integer necLat) {
      setFieldValue(29, 0, necLat, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get nec_long field
    * Units: semicircles
    *
    * @return nec_long
    */
   public Integer getNecLong() {
      return getFieldIntegerValue(30, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set nec_long field
    * Units: semicircles
    *
    * @param necLong
    */
   public void setNecLong(Integer necLong) {
      setFieldValue(30, 0, necLong, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get swc_lat field
    * Units: semicircles
    *
    * @return swc_lat
    */
   public Integer getSwcLat() {
      return getFieldIntegerValue(31, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set swc_lat field
    * Units: semicircles
    *
    * @param swcLat
    */
   public void setSwcLat(Integer swcLat) {
      setFieldValue(31, 0, swcLat, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get swc_long field
    * Units: semicircles
    *
    * @return swc_long
    */
   public Integer getSwcLong() {
      return getFieldIntegerValue(32, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set swc_long field
    * Units: semicircles
    *
    * @param swcLong
    */
   public void setSwcLong(Integer swcLong) {
      setFieldValue(32, 0, swcLong, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get normalized_power field
    * Units: watts
    *
    * @return normalized_power
    */
   public Integer getNormalizedPower() {
      return getFieldIntegerValue(34, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set normalized_power field
    * Units: watts
    *
    * @param normalizedPower
    */
   public void setNormalizedPower(Integer normalizedPower) {
      setFieldValue(34, 0, normalizedPower, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get training_stress_score field
    * Units: tss
    *
    * @return training_stress_score
    */
   public Float getTrainingStressScore() {
      return getFieldFloatValue(35, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set training_stress_score field
    * Units: tss
    *
    * @param trainingStressScore
    */
   public void setTrainingStressScore(Float trainingStressScore) {
      setFieldValue(35, 0, trainingStressScore, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get intensity_factor field
    * Units: if
    *
    * @return intensity_factor
    */
   public Float getIntensityFactor() {
      return getFieldFloatValue(36, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set intensity_factor field
    * Units: if
    *
    * @param intensityFactor
    */
   public void setIntensityFactor(Float intensityFactor) {
      setFieldValue(36, 0, intensityFactor, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get left_right_balance field
    *
    * @return left_right_balance
    */
   public Integer getLeftRightBalance() {
      return getFieldIntegerValue(37, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set left_right_balance field
    *
    * @param leftRightBalance
    */
   public void setLeftRightBalance(Integer leftRightBalance) {
      setFieldValue(37, 0, leftRightBalance, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_stroke_count field
    * Units: strokes/lap
    *
    * @return avg_stroke_count
    */
   public Float getAvgStrokeCount() {
      return getFieldFloatValue(41, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_stroke_count field
    * Units: strokes/lap
    *
    * @param avgStrokeCount
    */
   public void setAvgStrokeCount(Float avgStrokeCount) {
      setFieldValue(41, 0, avgStrokeCount, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_stroke_distance field
    * Units: m
    *
    * @return avg_stroke_distance
    */
   public Float getAvgStrokeDistance() {
      return getFieldFloatValue(42, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_stroke_distance field
    * Units: m
    *
    * @param avgStrokeDistance
    */
   public void setAvgStrokeDistance(Float avgStrokeDistance) {
      setFieldValue(42, 0, avgStrokeDistance, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get swim_stroke field
    * Units: swim_stroke
    *
    * @return swim_stroke
    */
   public SwimStroke getSwimStroke() {
      Short value = getFieldShortValue(43, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return SwimStroke.getByValue(value);
   }

   /**
    * Set swim_stroke field
    * Units: swim_stroke
    *
    * @param swimStroke
    */
   public void setSwimStroke(SwimStroke swimStroke) {
      setFieldValue(43, 0, swimStroke.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get pool_length field
    * Units: m
    *
    * @return pool_length
    */
   public Float getPoolLength() {
      return getFieldFloatValue(44, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set pool_length field
    * Units: m
    *
    * @param poolLength
    */
   public void setPoolLength(Float poolLength) {
      setFieldValue(44, 0, poolLength, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get threshold_power field
    * Units: watts
    *
    * @return threshold_power
    */
   public Integer getThresholdPower() {
      return getFieldIntegerValue(45, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set threshold_power field
    * Units: watts
    *
    * @param thresholdPower
    */
   public void setThresholdPower(Integer thresholdPower) {
      setFieldValue(45, 0, thresholdPower, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get pool_length_unit field
    *
    * @return pool_length_unit
    */
   public DisplayMeasure getPoolLengthUnit() {
      Short value = getFieldShortValue(46, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
      if (value == null)
         return null;
      return DisplayMeasure.getByValue(value);
   }

   /**
    * Set pool_length_unit field
    *
    * @param poolLengthUnit
    */
   public void setPoolLengthUnit(DisplayMeasure poolLengthUnit) {
      setFieldValue(46, 0, poolLengthUnit.value, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get num_active_lengths field
    * Units: lengths
    * Comment: # of active lengths of swim pool
    *
    * @return num_active_lengths
    */
   public Integer getNumActiveLengths() {
      return getFieldIntegerValue(47, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set num_active_lengths field
    * Units: lengths
    * Comment: # of active lengths of swim pool
    *
    * @param numActiveLengths
    */
   public void setNumActiveLengths(Integer numActiveLengths) {
      setFieldValue(47, 0, numActiveLengths, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_work field
    * Units: J
    *
    * @return total_work
    */
   public Long getTotalWork() {
      return getFieldLongValue(48, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_work field
    * Units: J
    *
    * @param totalWork
    */
   public void setTotalWork(Long totalWork) {
      setFieldValue(48, 0, totalWork, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_altitude field
    * Units: m
    *
    * @return avg_altitude
    */
   public Float getAvgAltitude() {
      return getFieldFloatValue(49, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_altitude field
    * Units: m
    *
    * @param avgAltitude
    */
   public void setAvgAltitude(Float avgAltitude) {
      setFieldValue(49, 0, avgAltitude, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_altitude field
    * Units: m
    *
    * @return max_altitude
    */
   public Float getMaxAltitude() {
      return getFieldFloatValue(50, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_altitude field
    * Units: m
    *
    * @param maxAltitude
    */
   public void setMaxAltitude(Float maxAltitude) {
      setFieldValue(50, 0, maxAltitude, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get gps_accuracy field
    * Units: m
    *
    * @return gps_accuracy
    */
   public Short getGpsAccuracy() {
      return getFieldShortValue(51, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set gps_accuracy field
    * Units: m
    *
    * @param gpsAccuracy
    */
   public void setGpsAccuracy(Short gpsAccuracy) {
      setFieldValue(51, 0, gpsAccuracy, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_grade field
    * Units: %
    *
    * @return avg_grade
    */
   public Float getAvgGrade() {
      return getFieldFloatValue(52, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_grade field
    * Units: %
    *
    * @param avgGrade
    */
   public void setAvgGrade(Float avgGrade) {
      setFieldValue(52, 0, avgGrade, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_pos_grade field
    * Units: %
    *
    * @return avg_pos_grade
    */
   public Float getAvgPosGrade() {
      return getFieldFloatValue(53, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_pos_grade field
    * Units: %
    *
    * @param avgPosGrade
    */
   public void setAvgPosGrade(Float avgPosGrade) {
      setFieldValue(53, 0, avgPosGrade, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_neg_grade field
    * Units: %
    *
    * @return avg_neg_grade
    */
   public Float getAvgNegGrade() {
      return getFieldFloatValue(54, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_neg_grade field
    * Units: %
    *
    * @param avgNegGrade
    */
   public void setAvgNegGrade(Float avgNegGrade) {
      setFieldValue(54, 0, avgNegGrade, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_pos_grade field
    * Units: %
    *
    * @return max_pos_grade
    */
   public Float getMaxPosGrade() {
      return getFieldFloatValue(55, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_pos_grade field
    * Units: %
    *
    * @param maxPosGrade
    */
   public void setMaxPosGrade(Float maxPosGrade) {
      setFieldValue(55, 0, maxPosGrade, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_neg_grade field
    * Units: %
    *
    * @return max_neg_grade
    */
   public Float getMaxNegGrade() {
      return getFieldFloatValue(56, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_neg_grade field
    * Units: %
    *
    * @param maxNegGrade
    */
   public void setMaxNegGrade(Float maxNegGrade) {
      setFieldValue(56, 0, maxNegGrade, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_temperature field
    * Units: C
    *
    * @return avg_temperature
    */
   public Byte getAvgTemperature() {
      return getFieldByteValue(57, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_temperature field
    * Units: C
    *
    * @param avgTemperature
    */
   public void setAvgTemperature(Byte avgTemperature) {
      setFieldValue(57, 0, avgTemperature, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_temperature field
    * Units: C
    *
    * @return max_temperature
    */
   public Byte getMaxTemperature() {
      return getFieldByteValue(58, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_temperature field
    * Units: C
    *
    * @param maxTemperature
    */
   public void setMaxTemperature(Byte maxTemperature) {
      setFieldValue(58, 0, maxTemperature, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_moving_time field
    * Units: s
    *
    * @return total_moving_time
    */
   public Float getTotalMovingTime() {
      return getFieldFloatValue(59, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_moving_time field
    * Units: s
    *
    * @param totalMovingTime
    */
   public void setTotalMovingTime(Float totalMovingTime) {
      setFieldValue(59, 0, totalMovingTime, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_pos_vertical_speed field
    * Units: m/s
    *
    * @return avg_pos_vertical_speed
    */
   public Float getAvgPosVerticalSpeed() {
      return getFieldFloatValue(60, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_pos_vertical_speed field
    * Units: m/s
    *
    * @param avgPosVerticalSpeed
    */
   public void setAvgPosVerticalSpeed(Float avgPosVerticalSpeed) {
      setFieldValue(60, 0, avgPosVerticalSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_neg_vertical_speed field
    * Units: m/s
    *
    * @return avg_neg_vertical_speed
    */
   public Float getAvgNegVerticalSpeed() {
      return getFieldFloatValue(61, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_neg_vertical_speed field
    * Units: m/s
    *
    * @param avgNegVerticalSpeed
    */
   public void setAvgNegVerticalSpeed(Float avgNegVerticalSpeed) {
      setFieldValue(61, 0, avgNegVerticalSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_pos_vertical_speed field
    * Units: m/s
    *
    * @return max_pos_vertical_speed
    */
   public Float getMaxPosVerticalSpeed() {
      return getFieldFloatValue(62, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_pos_vertical_speed field
    * Units: m/s
    *
    * @param maxPosVerticalSpeed
    */
   public void setMaxPosVerticalSpeed(Float maxPosVerticalSpeed) {
      setFieldValue(62, 0, maxPosVerticalSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_neg_vertical_speed field
    * Units: m/s
    *
    * @return max_neg_vertical_speed
    */
   public Float getMaxNegVerticalSpeed() {
      return getFieldFloatValue(63, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_neg_vertical_speed field
    * Units: m/s
    *
    * @param maxNegVerticalSpeed
    */
   public void setMaxNegVerticalSpeed(Float maxNegVerticalSpeed) {
      setFieldValue(63, 0, maxNegVerticalSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get min_heart_rate field
    * Units: bpm
    *
    * @return min_heart_rate
    */
   public Short getMinHeartRate() {
      return getFieldShortValue(64, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set min_heart_rate field
    * Units: bpm
    *
    * @param minHeartRate
    */
   public void setMinHeartRate(Short minHeartRate) {
      setFieldValue(64, 0, minHeartRate, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of time_in_hr_zone
    */
   public int getNumTimeInHrZone() {
      return getNumFieldValues(65, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get time_in_hr_zone field
    * Units: s
    *
    * @param index of time_in_hr_zone
    * @return time_in_hr_zone
    */
   public Float getTimeInHrZone(int index) {
      return getFieldFloatValue(65, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set time_in_hr_zone field
    * Units: s
    *
    * @param index of time_in_hr_zone
    * @param timeInHrZone
    */
   public void setTimeInHrZone(int index, Float timeInHrZone) {
      setFieldValue(65, index, timeInHrZone, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of time_in_speed_zone
    */
   public int getNumTimeInSpeedZone() {
      return getNumFieldValues(66, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get time_in_speed_zone field
    * Units: s
    *
    * @param index of time_in_speed_zone
    * @return time_in_speed_zone
    */
   public Float getTimeInSpeedZone(int index) {
      return getFieldFloatValue(66, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set time_in_speed_zone field
    * Units: s
    *
    * @param index of time_in_speed_zone
    * @param timeInSpeedZone
    */
   public void setTimeInSpeedZone(int index, Float timeInSpeedZone) {
      setFieldValue(66, index, timeInSpeedZone, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of time_in_cadence_zone
    */
   public int getNumTimeInCadenceZone() {
      return getNumFieldValues(67, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get time_in_cadence_zone field
    * Units: s
    *
    * @param index of time_in_cadence_zone
    * @return time_in_cadence_zone
    */
   public Float getTimeInCadenceZone(int index) {
      return getFieldFloatValue(67, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set time_in_cadence_zone field
    * Units: s
    *
    * @param index of time_in_cadence_zone
    * @param timeInCadenceZone
    */
   public void setTimeInCadenceZone(int index, Float timeInCadenceZone) {
      setFieldValue(67, index, timeInCadenceZone, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of time_in_power_zone
    */
   public int getNumTimeInPowerZone() {
      return getNumFieldValues(68, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get time_in_power_zone field
    * Units: s
    *
    * @param index of time_in_power_zone
    * @return time_in_power_zone
    */
   public Float getTimeInPowerZone(int index) {
      return getFieldFloatValue(68, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set time_in_power_zone field
    * Units: s
    *
    * @param index of time_in_power_zone
    * @param timeInPowerZone
    */
   public void setTimeInPowerZone(int index, Float timeInPowerZone) {
      setFieldValue(68, index, timeInPowerZone, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_lap_time field
    * Units: s
    *
    * @return avg_lap_time
    */
   public Float getAvgLapTime() {
      return getFieldFloatValue(69, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_lap_time field
    * Units: s
    *
    * @param avgLapTime
    */
   public void setAvgLapTime(Float avgLapTime) {
      setFieldValue(69, 0, avgLapTime, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get best_lap_index field
    *
    * @return best_lap_index
    */
   public Integer getBestLapIndex() {
      return getFieldIntegerValue(70, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set best_lap_index field
    *
    * @param bestLapIndex
    */
   public void setBestLapIndex(Integer bestLapIndex) {
      setFieldValue(70, 0, bestLapIndex, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get min_altitude field
    * Units: m
    *
    * @return min_altitude
    */
   public Float getMinAltitude() {
      return getFieldFloatValue(71, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set min_altitude field
    * Units: m
    *
    * @param minAltitude
    */
   public void setMinAltitude(Float minAltitude) {
      setFieldValue(71, 0, minAltitude, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get player_score field
    *
    * @return player_score
    */
   public Integer getPlayerScore() {
      return getFieldIntegerValue(82, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set player_score field
    *
    * @param playerScore
    */
   public void setPlayerScore(Integer playerScore) {
      setFieldValue(82, 0, playerScore, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get opponent_score field
    *
    * @return opponent_score
    */
   public Integer getOpponentScore() {
      return getFieldIntegerValue(83, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set opponent_score field
    *
    * @param opponentScore
    */
   public void setOpponentScore(Integer opponentScore) {
      setFieldValue(83, 0, opponentScore, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get opponent_name field
    *
    * @return opponent_name
    */
   public String getOpponentName() {
      return getFieldStringValue(84, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set opponent_name field
    *
    * @param opponentName
    */
   public void setOpponentName(String opponentName) {
      setFieldValue(84, 0, opponentName, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of stroke_count
    */
   public int getNumStrokeCount() {
      return getNumFieldValues(85, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get stroke_count field
    * Units: counts
    * Comment: stroke_type enum used as the index
    *
    * @param index of stroke_count
    * @return stroke_count
    */
   public Integer getStrokeCount(int index) {
      return getFieldIntegerValue(85, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set stroke_count field
    * Units: counts
    * Comment: stroke_type enum used as the index
    *
    * @param index of stroke_count
    * @param strokeCount
    */
   public void setStrokeCount(int index, Integer strokeCount) {
      setFieldValue(85, index, strokeCount, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of zone_count
    */
   public int getNumZoneCount() {
      return getNumFieldValues(86, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get zone_count field
    * Units: counts
    * Comment: zone number used as the index
    *
    * @param index of zone_count
    * @return zone_count
    */
   public Integer getZoneCount(int index) {
      return getFieldIntegerValue(86, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set zone_count field
    * Units: counts
    * Comment: zone number used as the index
    *
    * @param index of zone_count
    * @param zoneCount
    */
   public void setZoneCount(int index, Integer zoneCount) {
      setFieldValue(86, index, zoneCount, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_ball_speed field
    * Units: m/s
    *
    * @return max_ball_speed
    */
   public Float getMaxBallSpeed() {
      return getFieldFloatValue(87, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_ball_speed field
    * Units: m/s
    *
    * @param maxBallSpeed
    */
   public void setMaxBallSpeed(Float maxBallSpeed) {
      setFieldValue(87, 0, maxBallSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_ball_speed field
    * Units: m/s
    *
    * @return avg_ball_speed
    */
   public Float getAvgBallSpeed() {
      return getFieldFloatValue(88, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_ball_speed field
    * Units: m/s
    *
    * @param avgBallSpeed
    */
   public void setAvgBallSpeed(Float avgBallSpeed) {
      setFieldValue(88, 0, avgBallSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_vertical_oscillation field
    * Units: mm
    *
    * @return avg_vertical_oscillation
    */
   public Float getAvgVerticalOscillation() {
      return getFieldFloatValue(89, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_vertical_oscillation field
    * Units: mm
    *
    * @param avgVerticalOscillation
    */
   public void setAvgVerticalOscillation(Float avgVerticalOscillation) {
      setFieldValue(89, 0, avgVerticalOscillation, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_stance_time_percent field
    * Units: percent
    *
    * @return avg_stance_time_percent
    */
   public Float getAvgStanceTimePercent() {
      return getFieldFloatValue(90, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_stance_time_percent field
    * Units: percent
    *
    * @param avgStanceTimePercent
    */
   public void setAvgStanceTimePercent(Float avgStanceTimePercent) {
      setFieldValue(90, 0, avgStanceTimePercent, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_stance_time field
    * Units: ms
    *
    * @return avg_stance_time
    */
   public Float getAvgStanceTime() {
      return getFieldFloatValue(91, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_stance_time field
    * Units: ms
    *
    * @param avgStanceTime
    */
   public void setAvgStanceTime(Float avgStanceTime) {
      setFieldValue(91, 0, avgStanceTime, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_fractional_cadence field
    * Units: rpm
    * Comment: fractional part of the avg_cadence
    *
    * @return avg_fractional_cadence
    */
   public Float getAvgFractionalCadence() {
      return getFieldFloatValue(92, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_fractional_cadence field
    * Units: rpm
    * Comment: fractional part of the avg_cadence
    *
    * @param avgFractionalCadence
    */
   public void setAvgFractionalCadence(Float avgFractionalCadence) {
      setFieldValue(92, 0, avgFractionalCadence, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_fractional_cadence field
    * Units: rpm
    * Comment: fractional part of the max_cadence
    *
    * @return max_fractional_cadence
    */
   public Float getMaxFractionalCadence() {
      return getFieldFloatValue(93, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_fractional_cadence field
    * Units: rpm
    * Comment: fractional part of the max_cadence
    *
    * @param maxFractionalCadence
    */
   public void setMaxFractionalCadence(Float maxFractionalCadence) {
      setFieldValue(93, 0, maxFractionalCadence, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get total_fractional_cycles field
    * Units: cycles
    * Comment: fractional part of the total_cycles
    *
    * @return total_fractional_cycles
    */
   public Float getTotalFractionalCycles() {
      return getFieldFloatValue(94, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set total_fractional_cycles field
    * Units: cycles
    * Comment: fractional part of the total_cycles
    *
    * @param totalFractionalCycles
    */
   public void setTotalFractionalCycles(Float totalFractionalCycles) {
      setFieldValue(94, 0, totalFractionalCycles, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_total_hemoglobin_conc
    */
   public int getNumAvgTotalHemoglobinConc() {
      return getNumFieldValues(95, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_total_hemoglobin_conc field
    * Units: g/dL
    * Comment: Avg saturated and unsaturated hemoglobin
    *
    * @param index of avg_total_hemoglobin_conc
    * @return avg_total_hemoglobin_conc
    */
   public Float getAvgTotalHemoglobinConc(int index) {
      return getFieldFloatValue(95, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_total_hemoglobin_conc field
    * Units: g/dL
    * Comment: Avg saturated and unsaturated hemoglobin
    *
    * @param index of avg_total_hemoglobin_conc
    * @param avgTotalHemoglobinConc
    */
   public void setAvgTotalHemoglobinConc(int index, Float avgTotalHemoglobinConc) {
      setFieldValue(95, index, avgTotalHemoglobinConc, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of min_total_hemoglobin_conc
    */
   public int getNumMinTotalHemoglobinConc() {
      return getNumFieldValues(96, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get min_total_hemoglobin_conc field
    * Units: g/dL
    * Comment: Min saturated and unsaturated hemoglobin
    *
    * @param index of min_total_hemoglobin_conc
    * @return min_total_hemoglobin_conc
    */
   public Float getMinTotalHemoglobinConc(int index) {
      return getFieldFloatValue(96, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set min_total_hemoglobin_conc field
    * Units: g/dL
    * Comment: Min saturated and unsaturated hemoglobin
    *
    * @param index of min_total_hemoglobin_conc
    * @param minTotalHemoglobinConc
    */
   public void setMinTotalHemoglobinConc(int index, Float minTotalHemoglobinConc) {
      setFieldValue(96, index, minTotalHemoglobinConc, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of max_total_hemoglobin_conc
    */
   public int getNumMaxTotalHemoglobinConc() {
      return getNumFieldValues(97, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_total_hemoglobin_conc field
    * Units: g/dL
    * Comment: Max saturated and unsaturated hemoglobin
    *
    * @param index of max_total_hemoglobin_conc
    * @return max_total_hemoglobin_conc
    */
   public Float getMaxTotalHemoglobinConc(int index) {
      return getFieldFloatValue(97, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_total_hemoglobin_conc field
    * Units: g/dL
    * Comment: Max saturated and unsaturated hemoglobin
    *
    * @param index of max_total_hemoglobin_conc
    * @param maxTotalHemoglobinConc
    */
   public void setMaxTotalHemoglobinConc(int index, Float maxTotalHemoglobinConc) {
      setFieldValue(97, index, maxTotalHemoglobinConc, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_saturated_hemoglobin_percent
    */
   public int getNumAvgSaturatedHemoglobinPercent() {
      return getNumFieldValues(98, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_saturated_hemoglobin_percent field
    * Units: %
    * Comment: Avg percentage of hemoglobin saturated with oxygen
    *
    * @param index of avg_saturated_hemoglobin_percent
    * @return avg_saturated_hemoglobin_percent
    */
   public Float getAvgSaturatedHemoglobinPercent(int index) {
      return getFieldFloatValue(98, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_saturated_hemoglobin_percent field
    * Units: %
    * Comment: Avg percentage of hemoglobin saturated with oxygen
    *
    * @param index of avg_saturated_hemoglobin_percent
    * @param avgSaturatedHemoglobinPercent
    */
   public void setAvgSaturatedHemoglobinPercent(int index, Float avgSaturatedHemoglobinPercent) {
      setFieldValue(98, index, avgSaturatedHemoglobinPercent, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of min_saturated_hemoglobin_percent
    */
   public int getNumMinSaturatedHemoglobinPercent() {
      return getNumFieldValues(99, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get min_saturated_hemoglobin_percent field
    * Units: %
    * Comment: Min percentage of hemoglobin saturated with oxygen
    *
    * @param index of min_saturated_hemoglobin_percent
    * @return min_saturated_hemoglobin_percent
    */
   public Float getMinSaturatedHemoglobinPercent(int index) {
      return getFieldFloatValue(99, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set min_saturated_hemoglobin_percent field
    * Units: %
    * Comment: Min percentage of hemoglobin saturated with oxygen
    *
    * @param index of min_saturated_hemoglobin_percent
    * @param minSaturatedHemoglobinPercent
    */
   public void setMinSaturatedHemoglobinPercent(int index, Float minSaturatedHemoglobinPercent) {
      setFieldValue(99, index, minSaturatedHemoglobinPercent, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of max_saturated_hemoglobin_percent
    */
   public int getNumMaxSaturatedHemoglobinPercent() {
      return getNumFieldValues(100, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_saturated_hemoglobin_percent field
    * Units: %
    * Comment: Max percentage of hemoglobin saturated with oxygen
    *
    * @param index of max_saturated_hemoglobin_percent
    * @return max_saturated_hemoglobin_percent
    */
   public Float getMaxSaturatedHemoglobinPercent(int index) {
      return getFieldFloatValue(100, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_saturated_hemoglobin_percent field
    * Units: %
    * Comment: Max percentage of hemoglobin saturated with oxygen
    *
    * @param index of max_saturated_hemoglobin_percent
    * @param maxSaturatedHemoglobinPercent
    */
   public void setMaxSaturatedHemoglobinPercent(int index, Float maxSaturatedHemoglobinPercent) {
      setFieldValue(100, index, maxSaturatedHemoglobinPercent, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_left_torque_effectiveness field
    * Units: percent
    *
    * @return avg_left_torque_effectiveness
    */
   public Float getAvgLeftTorqueEffectiveness() {
      return getFieldFloatValue(101, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_left_torque_effectiveness field
    * Units: percent
    *
    * @param avgLeftTorqueEffectiveness
    */
   public void setAvgLeftTorqueEffectiveness(Float avgLeftTorqueEffectiveness) {
      setFieldValue(101, 0, avgLeftTorqueEffectiveness, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_right_torque_effectiveness field
    * Units: percent
    *
    * @return avg_right_torque_effectiveness
    */
   public Float getAvgRightTorqueEffectiveness() {
      return getFieldFloatValue(102, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_right_torque_effectiveness field
    * Units: percent
    *
    * @param avgRightTorqueEffectiveness
    */
   public void setAvgRightTorqueEffectiveness(Float avgRightTorqueEffectiveness) {
      setFieldValue(102, 0, avgRightTorqueEffectiveness, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_left_pedal_smoothness field
    * Units: percent
    *
    * @return avg_left_pedal_smoothness
    */
   public Float getAvgLeftPedalSmoothness() {
      return getFieldFloatValue(103, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_left_pedal_smoothness field
    * Units: percent
    *
    * @param avgLeftPedalSmoothness
    */
   public void setAvgLeftPedalSmoothness(Float avgLeftPedalSmoothness) {
      setFieldValue(103, 0, avgLeftPedalSmoothness, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_right_pedal_smoothness field
    * Units: percent
    *
    * @return avg_right_pedal_smoothness
    */
   public Float getAvgRightPedalSmoothness() {
      return getFieldFloatValue(104, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_right_pedal_smoothness field
    * Units: percent
    *
    * @param avgRightPedalSmoothness
    */
   public void setAvgRightPedalSmoothness(Float avgRightPedalSmoothness) {
      setFieldValue(104, 0, avgRightPedalSmoothness, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_combined_pedal_smoothness field
    * Units: percent
    *
    * @return avg_combined_pedal_smoothness
    */
   public Float getAvgCombinedPedalSmoothness() {
      return getFieldFloatValue(105, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_combined_pedal_smoothness field
    * Units: percent
    *
    * @param avgCombinedPedalSmoothness
    */
   public void setAvgCombinedPedalSmoothness(Float avgCombinedPedalSmoothness) {
      setFieldValue(105, 0, avgCombinedPedalSmoothness, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get sport_index field
    *
    * @return sport_index
    */
   public Short getSportIndex() {
      return getFieldShortValue(111, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set sport_index field
    *
    * @param sportIndex
    */
   public void setSportIndex(Short sportIndex) {
      setFieldValue(111, 0, sportIndex, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get time_standing field
    * Units: s
    * Comment: Total time spend in the standing position
    *
    * @return time_standing
    */
   public Float getTimeStanding() {
      return getFieldFloatValue(112, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set time_standing field
    * Units: s
    * Comment: Total time spend in the standing position
    *
    * @param timeStanding
    */
   public void setTimeStanding(Float timeStanding) {
      setFieldValue(112, 0, timeStanding, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get stand_count field
    * Comment: Number of transitions to the standing state
    *
    * @return stand_count
    */
   public Integer getStandCount() {
      return getFieldIntegerValue(113, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set stand_count field
    * Comment: Number of transitions to the standing state
    *
    * @param standCount
    */
   public void setStandCount(Integer standCount) {
      setFieldValue(113, 0, standCount, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_left_pco field
    * Units: mm
    * Comment: Average platform center offset Left
    *
    * @return avg_left_pco
    */
   public Byte getAvgLeftPco() {
      return getFieldByteValue(114, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_left_pco field
    * Units: mm
    * Comment: Average platform center offset Left
    *
    * @param avgLeftPco
    */
   public void setAvgLeftPco(Byte avgLeftPco) {
      setFieldValue(114, 0, avgLeftPco, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_right_pco field
    * Units: mm
    * Comment: Average platform center offset Right
    *
    * @return avg_right_pco
    */
   public Byte getAvgRightPco() {
      return getFieldByteValue(115, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_right_pco field
    * Units: mm
    * Comment: Average platform center offset Right
    *
    * @param avgRightPco
    */
   public void setAvgRightPco(Byte avgRightPco) {
      setFieldValue(115, 0, avgRightPco, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_left_power_phase
    */
   public int getNumAvgLeftPowerPhase() {
      return getNumFieldValues(116, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_left_power_phase field
    * Units: degrees
    * Comment: Average left power phase angles. Indexes defined by power_phase_type.
    *
    * @param index of avg_left_power_phase
    * @return avg_left_power_phase
    */
   public Float getAvgLeftPowerPhase(int index) {
      return getFieldFloatValue(116, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_left_power_phase field
    * Units: degrees
    * Comment: Average left power phase angles. Indexes defined by power_phase_type.
    *
    * @param index of avg_left_power_phase
    * @param avgLeftPowerPhase
    */
   public void setAvgLeftPowerPhase(int index, Float avgLeftPowerPhase) {
      setFieldValue(116, index, avgLeftPowerPhase, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_left_power_phase_peak
    */
   public int getNumAvgLeftPowerPhasePeak() {
      return getNumFieldValues(117, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_left_power_phase_peak field
    * Units: degrees
    * Comment: Average left power phase peak angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_left_power_phase_peak
    * @return avg_left_power_phase_peak
    */
   public Float getAvgLeftPowerPhasePeak(int index) {
      return getFieldFloatValue(117, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_left_power_phase_peak field
    * Units: degrees
    * Comment: Average left power phase peak angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_left_power_phase_peak
    * @param avgLeftPowerPhasePeak
    */
   public void setAvgLeftPowerPhasePeak(int index, Float avgLeftPowerPhasePeak) {
      setFieldValue(117, index, avgLeftPowerPhasePeak, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_right_power_phase
    */
   public int getNumAvgRightPowerPhase() {
      return getNumFieldValues(118, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_right_power_phase field
    * Units: degrees
    * Comment: Average right power phase angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_right_power_phase
    * @return avg_right_power_phase
    */
   public Float getAvgRightPowerPhase(int index) {
      return getFieldFloatValue(118, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_right_power_phase field
    * Units: degrees
    * Comment: Average right power phase angles. Data value indexes defined by power_phase_type.
    *
    * @param index of avg_right_power_phase
    * @param avgRightPowerPhase
    */
   public void setAvgRightPowerPhase(int index, Float avgRightPowerPhase) {
      setFieldValue(118, index, avgRightPowerPhase, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_right_power_phase_peak
    */
   public int getNumAvgRightPowerPhasePeak() {
      return getNumFieldValues(119, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_right_power_phase_peak field
    * Units: degrees
    * Comment: Average right power phase peak angles data value indexes  defined by power_phase_type.
    *
    * @param index of avg_right_power_phase_peak
    * @return avg_right_power_phase_peak
    */
   public Float getAvgRightPowerPhasePeak(int index) {
      return getFieldFloatValue(119, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_right_power_phase_peak field
    * Units: degrees
    * Comment: Average right power phase peak angles data value indexes  defined by power_phase_type.
    *
    * @param index of avg_right_power_phase_peak
    * @param avgRightPowerPhasePeak
    */
   public void setAvgRightPowerPhasePeak(int index, Float avgRightPowerPhasePeak) {
      setFieldValue(119, index, avgRightPowerPhasePeak, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_power_position
    */
   public int getNumAvgPowerPosition() {
      return getNumFieldValues(120, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_power_position field
    * Units: watts
    * Comment: Average power by position. Data value indexes defined by rider_position_type.
    *
    * @param index of avg_power_position
    * @return avg_power_position
    */
   public Integer getAvgPowerPosition(int index) {
      return getFieldIntegerValue(120, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_power_position field
    * Units: watts
    * Comment: Average power by position. Data value indexes defined by rider_position_type.
    *
    * @param index of avg_power_position
    * @param avgPowerPosition
    */
   public void setAvgPowerPosition(int index, Integer avgPowerPosition) {
      setFieldValue(120, index, avgPowerPosition, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of max_power_position
    */
   public int getNumMaxPowerPosition() {
      return getNumFieldValues(121, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_power_position field
    * Units: watts
    * Comment: Maximum power by position. Data value indexes defined by rider_position_type.
    *
    * @param index of max_power_position
    * @return max_power_position
    */
   public Integer getMaxPowerPosition(int index) {
      return getFieldIntegerValue(121, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_power_position field
    * Units: watts
    * Comment: Maximum power by position. Data value indexes defined by rider_position_type.
    *
    * @param index of max_power_position
    * @param maxPowerPosition
    */
   public void setMaxPowerPosition(int index, Integer maxPowerPosition) {
      setFieldValue(121, index, maxPowerPosition, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of avg_cadence_position
    */
   public int getNumAvgCadencePosition() {
      return getNumFieldValues(122, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_cadence_position field
    * Units: rpm
    * Comment: Average cadence by position. Data value indexes defined by rider_position_type.
    *
    * @param index of avg_cadence_position
    * @return avg_cadence_position
    */
   public Short getAvgCadencePosition(int index) {
      return getFieldShortValue(122, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_cadence_position field
    * Units: rpm
    * Comment: Average cadence by position. Data value indexes defined by rider_position_type.
    *
    * @param index of avg_cadence_position
    * @param avgCadencePosition
    */
   public void setAvgCadencePosition(int index, Short avgCadencePosition) {
      setFieldValue(122, index, avgCadencePosition, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * @return number of max_cadence_position
    */
   public int getNumMaxCadencePosition() {
      return getNumFieldValues(123, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_cadence_position field
    * Units: rpm
    * Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.
    *
    * @param index of max_cadence_position
    * @return max_cadence_position
    */
   public Short getMaxCadencePosition(int index) {
      return getFieldShortValue(123, index, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_cadence_position field
    * Units: rpm
    * Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.
    *
    * @param index of max_cadence_position
    * @param maxCadencePosition
    */
   public void setMaxCadencePosition(int index, Short maxCadencePosition) {
      setFieldValue(123, index, maxCadencePosition, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get enhanced_avg_speed field
    * Units: m/s
    * Comment: total_distance / total_timer_time
    *
    * @return enhanced_avg_speed
    */
   public Float getEnhancedAvgSpeed() {
      return getFieldFloatValue(124, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set enhanced_avg_speed field
    * Units: m/s
    * Comment: total_distance / total_timer_time
    *
    * @param enhancedAvgSpeed
    */
   public void setEnhancedAvgSpeed(Float enhancedAvgSpeed) {
      setFieldValue(124, 0, enhancedAvgSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get enhanced_max_speed field
    * Units: m/s
    *
    * @return enhanced_max_speed
    */
   public Float getEnhancedMaxSpeed() {
      return getFieldFloatValue(125, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set enhanced_max_speed field
    * Units: m/s
    *
    * @param enhancedMaxSpeed
    */
   public void setEnhancedMaxSpeed(Float enhancedMaxSpeed) {
      setFieldValue(125, 0, enhancedMaxSpeed, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get enhanced_avg_altitude field
    * Units: m
    *
    * @return enhanced_avg_altitude
    */
   public Float getEnhancedAvgAltitude() {
      return getFieldFloatValue(126, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set enhanced_avg_altitude field
    * Units: m
    *
    * @param enhancedAvgAltitude
    */
   public void setEnhancedAvgAltitude(Float enhancedAvgAltitude) {
      setFieldValue(126, 0, enhancedAvgAltitude, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get enhanced_min_altitude field
    * Units: m
    *
    * @return enhanced_min_altitude
    */
   public Float getEnhancedMinAltitude() {
      return getFieldFloatValue(127, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set enhanced_min_altitude field
    * Units: m
    *
    * @param enhancedMinAltitude
    */
   public void setEnhancedMinAltitude(Float enhancedMinAltitude) {
      setFieldValue(127, 0, enhancedMinAltitude, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get enhanced_max_altitude field
    * Units: m
    *
    * @return enhanced_max_altitude
    */
   public Float getEnhancedMaxAltitude() {
      return getFieldFloatValue(128, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set enhanced_max_altitude field
    * Units: m
    *
    * @param enhancedMaxAltitude
    */
   public void setEnhancedMaxAltitude(Float enhancedMaxAltitude) {
      setFieldValue(128, 0, enhancedMaxAltitude, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get avg_lev_motor_power field
    * Units: watts
    * Comment: lev average motor power during session
    *
    * @return avg_lev_motor_power
    */
   public Integer getAvgLevMotorPower() {
      return getFieldIntegerValue(129, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set avg_lev_motor_power field
    * Units: watts
    * Comment: lev average motor power during session
    *
    * @param avgLevMotorPower
    */
   public void setAvgLevMotorPower(Integer avgLevMotorPower) {
      setFieldValue(129, 0, avgLevMotorPower, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get max_lev_motor_power field
    * Units: watts
    * Comment: lev maximum motor power during session
    *
    * @return max_lev_motor_power
    */
   public Integer getMaxLevMotorPower() {
      return getFieldIntegerValue(130, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set max_lev_motor_power field
    * Units: watts
    * Comment: lev maximum motor power during session
    *
    * @param maxLevMotorPower
    */
   public void setMaxLevMotorPower(Integer maxLevMotorPower) {
      setFieldValue(130, 0, maxLevMotorPower, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Get lev_battery_consumption field
    * Units: percent
    * Comment: lev battery consumption during session
    *
    * @return lev_battery_consumption
    */
   public Float getLevBatteryConsumption() {
      return getFieldFloatValue(131, 0, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

   /**
    * Set lev_battery_consumption field
    * Units: percent
    * Comment: lev battery consumption during session
    *
    * @param levBatteryConsumption
    */
   public void setLevBatteryConsumption(Float levBatteryConsumption) {
      setFieldValue(131, 0, levBatteryConsumption, Fit.SUBFIELD_INDEX_MAIN_FIELD);
   }

}
