% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pt_model.R
\name{Pt_model}
\alias{Pt_model}
\title{Power-time modelling.}
\usage{
Pt_model(P, tsec)
}
\arguments{
\item{P}{a numeric vector of maximal mean power values for time periods given
in the \code{tsec} argument.}

\item{tsec}{a numeric vector of time values that (positionally) correspond to
elements in \code{P}.}
}
\value{
returns an S3 object of class "Ptmodels".
}
\description{
Model the Power-time (Pt) relationship for a set of data. This is done via
nonlinear least squares regression of four models: an inverse model; an
exponential model; a bivariate power function model; and a three parameter
inverse model. An S3 object of class "Ptmodels" is returned, which currently
has methods for \link[base]{print}, \link[stats]{coef}, \link[base]{summary},
and \link[stats]{predict}. If inputs do not conform well to the models, a
warning message is generated. This function will make use of
\code{minpack.lm::nlsLM} if available.
}
\examples{
data(Pt_prof)  # Example power-time profile.

P    <- Pt_prof$pwr
tsec <- Pt_prof$time

mdls <- Pt_model(P, tsec)  # Model.
print(mdls)

coef(mdls)
summary(mdls)

}
\references{
R. Hugh Morton (1996) A 3-parameter critical power model,
  Ergonomics, 39:4, 611-619,
  \href{http://dx.doi.org/10.1080/00140139608964484}{DOI}.
}
\seealso{
\code{\link{predict.Ptmodels}}
}

