% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{diff_section}
\alias{diff_section}
\title{Section data according to breaks.}
\usage{
diff_section(x, br)
}
\arguments{
\item{x}{a numeric vector (e.g. a timer column) that increments uniformly.
When there is a \strong{significant} break in this uniformity, a new
section is created, and so forth.}

\item{br}{criterion for a significant break in terms of \code{x}.}
}
\value{
a vector of the same length as \code{x}.
}
\description{
Generates a vector of "section" values/levels according to differences in
the supplied vector. The function simply rolls over \code{x}, incrementing
the return vector every time there is a significant break (\code{stop}
argument) in the pattern of differences between adjacent elements of
\code{x}. In practical terms, if \code{x} is a series of timestamp values
(see example), every time there is a significant break in the timer (e.g.
>10 sec), the return vector is incremented by 1.
}
\examples{
t_sec <- c(1:10, 40:60, 100:150)       # Discontinuous timer values.
pwr   <- runif(length(t_sec), 0, 400)  # Some power values.
x     <- data.frame(t_sec, pwr)

## Generate section levels.
x$section <- diff_section(x$t_sec, br = 10) # 10 second breaks.
print(x)
split(x, x$section)

## Using "intervaldata", which has a large stop.
data(intervaldata)
intervaldata$section <- diff_section(intervaldata$timer.s, br = 20)
sp <- split(intervaldata, intervaldata$section)

## Plot.
eplot <- function(x) cycleRtools:::elev_plot(x, "timer.min")
layout(matrix(c(1, 2, 1, 3), 2, 2))
eplot(cycleRtools:::expand_stops(intervaldata))
eplot(sp[[1]])
eplot(sp[[2]])

}

