% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elevation_correct.R
\name{elevation_correct}
\alias{elevation_correct}
\title{Generate reliable elevation data.}
\usage{
elevation_correct(data, country)
}
\arguments{
\item{data}{a dataset with longitude ("lng") and lattitude ("lon") columns.}

\item{country}{character string; the country to which the data pertain, given
as an ISO3 code (see \code{raster::getData("ISO3")})}
}
\value{
a vector of elevation values. If there is an error at any stage, a
  vector of NAs is returned.
}
\description{
Using the latitude and longitude columns of the supplied \emph{formatted}
data, a vector of elevation values is returned of the same length. If no
elevation data files exist within the working directory, files are first
downloaded. Note that NAs in the data will return corresponding NAs in the
corrected elevation.
}
\examples{
\dontrun{
data(ridedata)

## When run the first time, geographical data will need to be downloaded.
ridedata$elevation.corrected <- elevation_correct(ridedata, "GBR")

## A Bland-Altman-type plot.
difference <- ridedata$elevation.m - ridedata$elevation.corrected
plot(difference ~ ridedata$timer.min, cex = 0.2, ylab = "raw minus corrected")
m <- mean(difference, na.rm = TRUE); stdev <- sd(difference, na.rm = TRUE)
abline(h = c(m + c(-stdev, 0, stdev)), lty = c(1, 2, 1), col = "red")
}

}
\seealso{
\code{\link{download_elev_data}}.
}

