% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmv.R
\name{mmv}
\alias{mmv}
\title{Maximal mean values.}
\usage{
mmv(data, column, windows, deltat = NULL, character.only = FALSE)
}
\arguments{
\item{data}{a \strong{formatted} dataset produced by \code{read*()}.}

\item{column}{column in \code{data} giving the values of interest. Needn't be
quoted.}

\item{windows}{window size(s) for which to generate best averages, given in
seconds.}

\item{deltat}{the sampling frequency of \code{data} in seconds per sample;
typically 0.5 or 1. If \code{NULL}, this is estimated.}

\item{character.only}{are column name arguments given as character strings? A
backdoor around non-standard evaluation. Mainly for internal use.}
}
\value{
a matrix object with two rows: 1) best mean values and 2) the time
  at which those values were recorded
}
\description{
Calculate maximal mean values for specified time periods.
}
\examples{
data(ridedata)

## Best power for 5 and 20 minutes.
tsec <- c(5, 20) * 60
mmv(ridedata, power.W, tsec)

## Generate a simple critical power estimate.
tsec <- 2:20 * 60
pwrs <- mmv(ridedata, power.W, tsec)
m <- lm(pwrs[1, ] ~ {1 / tsec})  # Simple inverse model.
coef(m)[1]  # Intercept = critical power.

## More complex models...
m <- Pt_model(pwrs[1, ], tsec)
print(m)
## Extract the asymptote of the exponential model.
coef(m)$exp["CP"]

}
\seealso{
For a more generic and efficient version of this function, see
  \code{\link{mmv2}}
}

