% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mmv2}
\alias{mmv2}
\title{Efficient maximal mean values.}
\usage{
mmv2(x, windows)
}
\arguments{
\item{x}{a numeric vector of values.}

\item{windows}{window size(s) (in element units) for which to
generate maximum mean values.}
}
\value{
a vector of \code{length(windows)}.
}
\description{
A more efficient implementation of \code{\link{mmv}}. Simply takes a vector
(\code{x}) of values and rolls over them element wise by \code{windows}.
Returns a vector of maximum mean values for each window. \code{NA}s are not
ignored.
}
\examples{
x <- rnorm(100, 500, 200)
mmv2(x, windows = c(5, 10, 20))

}

