% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cycleRdata_S3.R
\name{plot.cycleRdata}
\alias{plot.cycleRdata}
\title{Plot cycling data.}
\usage{
\method{plot}{cycleRdata}(x, y = 1:3, xvar = "timer.s", xlab = NULL,
  xlim = NULL, CP = attr(x, "CP"), laps = FALSE, breaks = TRUE, ...)
}
\arguments{
\item{x}{a \code{"cycleRdata"} object produced by \code{read*()}.}

\item{y}{numeric; plots to be created (see details).}

\item{xvar}{character; name of the column to be plotted as the xvariable.}

\item{xlab}{character; x axis label for bottom plot.}

\item{xlim}{given in terms of \code{x}.}

\item{CP}{a value for critical power annotation.}

\item{laps}{logical; should laps be seperately coloured?}

\item{breaks}{logical; should plot lines be broken when stationary? Will only
show when \code{xvar} represents time values.}

\item{...}{graphical parameters, and/or arguments to be passed to or from
other methods.}
}
\value{
a variable number of plots.
}
\description{
Generate plots to effectively summarise a cycling dataset.
}
\details{
The \code{y} argument describes plot options such that: \enumerate{\item
plots W' balance (kJ). \item plots power data (W). \item plots an elevation
profile (m).} These options can be combined to produce a stack of plots as
desired.
}
\examples{
\dontrun{
data(ridedata)

plot(ridedata, xvar = "timer.min")
plot(ridedata, xvar = "distance.km")

## With only two plots.
plot(ridedata, y = c(2, 1))

## Using xlim, note that title metrics adjust.
plot(ridedata, xvar = "timer.min", xlim = c(100, 150))

## Lap colouring.
data(intervaldata)
plot(intervaldata, xvar = "timer.min", laps = TRUE)
}

}

