% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ptmodels_S3.R
\name{predict.Ptmodels}
\alias{predict.Ptmodels}
\title{Predict Power or Time}
\usage{
\method{predict}{Ptmodels}(object, x, xtype = c("pwr", "time"), ...)
}
\arguments{
\item{object}{an object of class "Ptmodels".}

\item{x}{the value for which to make a prediction.}

\item{xtype}{what is \code{x}? A power or a time value?}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a named numeric vector of predicted values. Names correspond to their
  respective models.
}
\description{
Given a Ptmodels \code{object}, the predict.Ptmodels will produce a named
numeric vector of either time (seconds) or power (watts) values according to
the \code{x} and \code{y} arguments
}
\examples{
data(Pt_prof)  # Example power-time profile.

P    <- Pt_prof$pwr
tsec <- Pt_prof$time

mdls <- Pt_model(P, tsec)  ## Model.
print(mdls)

## What is the best predicted 20 minute power?
predict(mdls, x = 60 * 20, xtype = "time")

## How sustainable is 500 Watts?
predict(mdls, x = 500, xtype = "P") / 60  # Minutes.

## Create some plots of the models.
par(mfrow = c(2, 2), mar = c(3.1, 3.1, 1.1, 1.1))
plotargs <- alist(x = tsec, y = P, cex = 0.2, ann = FALSE, bty = "l")
mapply(function(f, m) {
  do.call(plot, plotargs)
  curve(f(x), col = "red", add = TRUE)
  title(main = paste0(rownames(m),"; RSE = ", round(m$RSE, 2)))
  legend("topleft", legend = m$formula, bty = "n")
  return()
}, f = mdls$Pfn, m = split(mdls$table, seq_len(nrow(mdls$table))))

}

