% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reading.R
\name{read_ride}
\alias{read_fit}
\alias{read_pwx}
\alias{read_ride}
\alias{read_srm}
\alias{read_tcx}
\title{Read cycling device data.}
\usage{
read_ride(file = file.choose(), format = TRUE, CP = NULL, sRPE = NULL)

read_fit(file = file.choose(), format = TRUE, CP = NULL, sRPE = NULL)

read_pwx(file = file.choose(), format = TRUE, CP = NULL, sRPE = NULL)

read_srm(file = file.choose(), format = TRUE, CP = NULL, sRPE = NULL)

read_tcx(file = file.choose(), format = TRUE, CP = NULL, sRPE = NULL)
}
\arguments{
\item{file}{character; path to the file.}

\item{format}{logical; should data be formatted?}

\item{CP, sRPE}{optional; critical power and session RPE values to be
associated with the data. Ignored if \code{format = FALSE}.}
}
\value{
a data frame object.
}
\description{
Read data from a cycling head unit into the R environment; optionally
formatting it for use with other functions in this package. Critical power
and session RPE metrics can also be associated with the data and used by
other functions (e.g. \link{summary.cycleRdata}).
}
\details{
Note that most functions within this package depend on imported data being
formatted; i.e. \code{read*("file_path", format = TRUE)}. Hence, unless the
raw data is of particular interest and/or the user wants to process it
manually, the format argument should be TRUE (default). When working with a
formatted dataset, do not change existing column names. The formatted data
structure is described in detail in \link{ridedata}.

Garmin .fit file data is parsed with the java command line tool provided in
the \href{http://www.thisisant.com/resources/fit}{FIT SDK}. The latest source
code and licensing information can be found at the previous link.

SRM device files (.srm) are also parsed at the command line, provided
\href{http://www.zuto.de/project/srmio/}{Rainer Clasen's srmio library} is
installed and available. The associated GitHub repo' can be found
\href{https://github.com/rclasen/srmio}{here}.
}
\section{Functions}{
\itemize{
\item \code{read_ride}: A wrapper for read_* functions that chooses the
appropriate function based on file extension.

\item \code{read_fit}: Read a Garmin (Ltd) device .fit file. This invokes
\code{\link[base]{system2}} to execute the FitCSVTool.jar command line tool
(see \href{http://www.thisisant.com/resources/fit}{FIT SDK}). Hence, this
function requires that Java (JRE/JDK) binaries be on the system path.

\item \code{read_pwx}: Read a Training Peaks .pwx file. Requires the "xml2" package
to be installed.

\item \code{read_srm}: Read an SRM (.srm) file. This requires
\href{http://www.zuto.de/project/srmio/}{Rainer Clasen's srmio library} to
be installed and on the system path.

\item \code{read_tcx}: Read a Garmin .tcx file. Requires the "xml2" package to be
installed.
}}
\examples{
\dontrun{
fl  <- system.file("extdata/example_files.tar.gz",
                   package = "cycleRtools")
fls <- untar(fl, list = TRUE)
untar(fl)  # Extract to working directory.

dat <- lapply(fls, read_ride, format = TRUE, CP = 300, sRPE = 5)

file.remove(fls)
}

}

