% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_exported.R
\name{reset}
\alias{reset}
\title{Reset a dataset or vector.}
\usage{
reset(x)
}
\arguments{
\item{x}{a numeric vector or formatted cycling dataset (i.e. class \code{"cycleRdata"}).}
}
\value{
either a data frame or vector, depending on the class of \code{x}.
}
\description{
if \code{x} is a \code{"cycleRdata"} object, all columns are reset as
appropriate. This can be useful after subsetting a ride dataset, for example.
Otherwise, this is a wrapper for \code{x - x[[1]]}.
}
\examples{
data(ridedata)

# Remove first minute of data and reset.
data_raw   <- ridedata[ridedata$timer.s > 60, ]
data_reset <- reset(data_raw)

}

