% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/rollmean_smth.R
\name{rollmean_}
\alias{rollmean_}
\alias{rollmean_smth}
\title{Rolling average smoothing.}
\usage{
rollmean_(x, window, ema, narm)

rollmean_smth(data, column, smth.pd, deltat = NULL, ema = FALSE,
  character.only = FALSE)
}
\arguments{
\item{x}{numeric; values to be rolled over.}

\item{window}{numeric; size of the rolling window in terms of elements in
\code{x}.}

\item{ema}{logical; should the moving average be exponentially weighted?}

\item{narm}{logical; should \code{NA}s be removed?}

\item{data}{a dataset of class \code{cycleRdata}.}

\item{column}{the column name of the data to be smoothed, needn't be quoted.}

\item{smth.pd}{numeric; the time period over which to smooth (seconds).}

\item{deltat}{the sampling frequency of \code{data} in seconds per sample;
typically 0.5 or 1. If \code{NULL}, this is estimated.}

\item{character.only}{are column name arguments given as character strings? A
backdoor around non-standard evaluation.}
}
\value{
a vector of the same length as the \code{data[, column]}.
}
\description{
Smooth data with a right-aligned (zero-padded) rolling average.
}
\details{
\code{rollmean_} is the core Rcpp function, which rolls over elements in
\code{x} by a window given in \code{window}; optionally applying exponential
weights and/or removing \code{NA}s. \code{rollmean_smth} is a wrapper for
\code{rollmean_} that only has a method for \code{cycleRdata} objects. The
latter will pre-process the data and permits what is effectively the
\code{window} argument being given in time units.
}
\examples{
\dontrun{
data(ridedata)

## Smooth power data with a 30 second moving average.
rollmean_smth(ridedata, power.W, 30)

## Or use an exponentially weighted moving average.
rollmean_smth(ridedata, power.W, 30, ema = TRUE)
}
}

