% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smth_plot.R
\name{smth_plot}
\alias{smth_plot}
\title{Smoothed data plot.}
\usage{
smth_plot(data, x = "timer.s", yraw = "power.W", ysmth = "power.smooth.W",
  colour = "lap", ..., character.only = FALSE)
}
\arguments{
\item{data}{the dataset to be used.}

\item{x}{column identifier for the x axis data.}

\item{yraw}{column identifier for the (underlying) raw data.}

\item{ysmth}{column identifier for the smoothed data.}

\item{colour}{level identifier in \code{data} by which to colour lines. Or a
colour name.}

\item{...}{further arguments to be passed to \code{plot()}.}

\item{character.only}{are column name arguments given as character strings? A
backdoor around non-standard evaluation.}
}
\description{
Create a plot with both raw and smoothed data lines.
}
\examples{
data(ridedata)

## Plot with a single blue line (default arguments):
smth_plot(ridedata, colour = "blue", main = "Single Colour",
          xlab = "Time (seconds)", ylab = "Power (watts)")

## Create some laps.
ridedata$lap <- ceiling(seq(from = 1.1, to = 5, length.out = nrow(ridedata)))
## Plot with lap colours.
smth_plot(ridedata, timer.min, power.W, power.smooth.W, colour = "lap",
          xlab = "Time (mins)", ylab = "Power (watts)", main = "Lap Colours")

}

