% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cycleRdata_S3.R
\name{summary.cycleRdata}
\alias{summary.cycleRdata}
\title{Summary method for cycleRdata class.}
\usage{
\method{summary}{cycleRdata}(object, sRPE = attr(object, "sRPE"),
  CP = attr(object, "CP"), .smoothpwr = "power.smooth.W", ...)
}
\arguments{
\item{object}{object for which a summary is desired.}

\item{sRPE}{optional; session Rating of Percieved Exertion (value between 1
and 10; Foster 1998).}

\item{CP}{optional; Critical Power value (Watts).}

\item{.smoothpwr}{character string; column name of smoothed power values.
Used for xP metric.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list object of class \code{"cyclesummary"}, which has an associated
  print method.
}
\description{
Relevant summary metrics for cycling data (method for class
\code{"cycleRdata"}).
}
\examples{
data(intervaldata)
summary(intervaldata)

}
\references{
Foster C. Monitoring training in athletes with reference to
overtraining syndrome. Medicine & Science in Sports & Exercise 30: 1164-1168,
1998.
}

