% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_metrics.R
\name{summary_metrics}
\alias{NP}
\alias{TSS}
\alias{pwr_TRIMP}
\alias{ride_time}
\alias{summary_metrics}
\alias{xPower}
\title{Summary metrics.}
\usage{
ride_time(x, deltat = NULL)

xPower(data)

NP(data)

pwr_TRIMP(data, CP = attr(data, "CP"))

TSS(data, CP = attr(data, "CP"))
}
\arguments{
\item{x}{a vector of time values.}

\item{deltat}{numeric; the typical interval between time values, if
\code{NULL} a best estimate is used.}

\item{data}{a "cycleRdata" object, produced from a \code{\link{read_ride}}
function.}

\item{CP}{a Critical Power value - e.g. CP or FTP.}
}
\value{
a single numeric value.
}
\description{
Common summary measures of interest to cyclists.
}
\details{
\code{NP} calculates a Normalised Power value. "Normalised Power" is a
registered trademark of Peaksware Inc.

\code{xPower}; Dr. Philip Skiba/Golden Cheetah's answer to NP.

\code{pwr_TRIMP}: Power-Based TRaining IMPulse. Calculates a
\emph{normalised} TRIMP value using power data. This is a power-based
adaptation of Bannister's TRIMP, whereby critical power (CP) is assumed to
represent 90% of heart rate ratio (HRR). The final TRIMP score is normalised
to the score associated with one-hour's riding at CP, to aid interpretation.

\code{ride_time} is a simple function for calculating ride time, as opposed
to elapsed time.

\code{TSS} calculates a Training Stress Score (TSS). TSS is a registered
trademark of Peaksware Inc.
}
\examples{
data(ridedata)

## Display all summary metrics with an *apply call.
fns   <- list("ride_time", "xPower", "NP", "pwr_TRIMP", "TSS")
argl  <- list(data = ridedata, x = ridedata$timer.s, CP = 300)
metrs <- vapply(fns, function(f) {
  do.call(f, argl[names(argl) \%in\% names(formals(f))])
}, numeric(1))

names(metrs) <- fns
print(metrs)
}
\references{
Morton, R.H., Fitz-Clarke, J.R., Banister, E.W., 1990. Modeling
  human performance in running. Journal of Applied Physiology 69, 1171-1177.
}

