% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zone_functions.R
\name{zdist_plot}
\alias{zdist_plot}
\title{Zone-time distribution plot.}
\usage{
zdist_plot(data, column = "power.W", binwidth = 10, zbounds = NULL,
  character.only = FALSE, ...)
}
\arguments{
\item{data}{a "cycleRdata" object, produced from a \code{\link{read_ride}}
function.}

\item{column}{column in \code{data} giving the values of interest. Needn't be
quoted.}

\item{binwidth}{how should values in \code{column} be binned? E.g.
\code{bindiwdth = 10} will create 10 watt bins if \code{column} is power
data.}

\item{zbounds}{optional; a numeric vector of zone boundaries.}

\item{character.only}{are column name arguments given as character strings? A
backdoor around non-standard evaluation.}

\item{...}{arguments to be passed to \code{barplot()} and/or graphical
parameters (\code{\link{par}}).}
}
\value{
nothing; a plot is sent to the current graphics device.
}
\description{
Display the time distribution of values within a dataset. The distribution
can also be partitioned into zones if the \code{zbounds} argument is not
\code{NULL}.
}
\examples{
data(ridedata)

## Using power.
zdist_plot(
 data = ridedata, column = power.W,
 binwidth = 10,  # 10 watt bins.
 zbounds = c(100, 200, 300),
 xlim = c(110, 500), xlab = "Power (Watts)",
 main = "Power distribution" # Argument passed to barplot.
)

## Using speed.
zdist_plot(
  data = ridedata, column = speed.kmh,
  binwidth = 2,  # 2 km/hr bins.
  zbounds = c(10, 20, 30),
  xlab = "Speed (km/hr)",
  main = "Speed distribution"
)

## Without zone colouring (produces a warning).
zdist_plot(
  data = ridedata, column = speed.kmh,
  binwidth = 5,  # 2 km/hr bins.
  xlab = "Speed (km/hr)", main = "Dull"
)

}

