% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zone_functions.R
\name{zone_index}
\alias{zone_index}
\title{Index zones.}
\usage{
zone_index(x, zbounds)
}
\arguments{
\item{x}{numeric; values to be "zoned".}

\item{zbounds}{numeric; values for zone boundaries.}
}
\value{
a numeric vector of zone values of the same length as \code{x}. The
  number of zone levels will be \code{length(zbounds) + 1}.
}
\description{
Generate a vector of zone "levels" from an input vector and defined
boundaries.
}
\examples{
data(ridedata)

## Best used to append to existing data.
ridedata$zone <- zone_index(ridedata$power.W, c(100, 200, 300))

## How much distance was covered in each zone?
ridedata$delta.dist <- c(0, diff(ridedata$distance.km))
with(ridedata, tapply(delta.dist, zone, sum, na.rm = TRUE))  # Km.

}

