% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zone_functions.R
\name{zone_time}
\alias{zone_time}
\title{Calculate time in zones.}
\usage{
zone_time(data, column = "power.W", zbounds, pct = FALSE,
  character.only = FALSE)
}
\arguments{
\item{data}{a "cycleRdata" object, produced from a \code{\link{read_ride}}
function.}

\item{column}{the column name of the data to which the zone boundaries
relate.}

\item{zbounds}{numeric; zone boundaries.}

\item{pct}{should percentage values be returned?}

\item{character.only}{are column name arguments given as character strings? A
backdoor around non-standard evaluation. Mainly for internal use.}
}
\value{
a data frame of zone times.
}
\description{
Given a vector of zone boundaries, sums the time spent in each zone.
}
\examples{
data(ridedata)

## Time spent above and below critical power...
zone_time(ridedata, "power.W", zbounds = 300) / 60  # Minutes.

## Or with more zones...
zone_time(ridedata, "power.W", zbounds = c(100, 200, 300)) / 60

## Or given as a percentage...
zone_time(ridedata, "power.W", zbounds = c(100, 200, 300), pct = TRUE)

}

