% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggregate}
\alias{aggregate}
\title{Aggregate data based on given grouping.}
\usage{
aggregate(
  population,
  variables,
  strata,
  operation = "mean",
  univariate = TRUE,
  ...
)
}
\arguments{
\item{population}{tbl with grouping (metadata) and observation variables.}

\item{variables}{character vector specifying observation variables.}

\item{strata}{character vector specifying grouping variables for aggregation.}

\item{operation}{optional character string specifying method for aggregation,
e.g. \code{"mean"}, \code{"median"}, \code{"mean+sd"}. A sequence can
comprise only of univariate functions.}

\item{univariate}{boolean specifying whether the aggregation function is
univariate or multivariate.}

\item{...}{optional arguments passed to aggregation operation}
}
\value{
aggregated data of the same class as \code{population}.
}
\description{
\code{aggregate} aggregates data based on the specified aggregation method.
}
\examples{
population <- tibble::tibble(
  Metadata_group = c(
    "control", "control", "control", "control",
    "experiment", "experiment", "experiment",
    "experiment"
  ),
  Metadata_batch = c("a", "a", "b", "b", "a", "a", "b", "b"),
  AreaShape_Area = c(10, 12, 15, 16, 8, 8, 7, 7)
)
variables <- c("AreaShape_Area")
strata <- c("Metadata_group", "Metadata_batch")
aggregate(population, variables, strata, operation = "mean")
}
