% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_table.R
\name{simple_table}
\alias{simple_table}
\title{Simple HTML table}
\usage{
simple_table(data, colnames = TRUE, rownames = FALSE)
}
\arguments{
\item{data}{A data.frame}

\item{colnames}{\emph{(logical)} Whether or not to show the column names (a header row)}

\item{rownames}{\emph{(logical)} Whether or not to show the row names}
}
\description{
Simple HTML table
}
\examples{
if (interactive()) {
    app <- dash_app() \%>\%
      set_layout(
        dccChecklist(
          id = "table_params",
          labelStyle = list(display = "block"),
          options = list(
            list(label = "Header", value = "colnames"),
            list(label = "Row names", value = "rownames")
          )
        ),
        br(),
        div(id = "table")
      )

    app \%>\% add_callback(
      output(id = 'table', property = 'children'),
      input(id = 'table_params', property = 'value'),
      function(val) {
        simple_table(mtcars, colnames = "colnames" \%in\% val, rownames = "rownames" \%in\% val)
      }
    )

    app \%>\% run_app()
}
}
