% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcCullochPitts.R
\docType{class}
\name{McCullochPitts-class}
\alias{McCullochPitts-class}
\alias{mcCullochPitts}
\title{The McCullochPitts neuron class, that implements the logic of the
McCullochPitts neuron model.}
\arguments{
\item{inputs}{The actual data to be fed to the nuron, this input's
dimentions vary with the chosen weights dimentions.}

\item{ins}{The list of vectors of inputs to the first layer in the network}

\item{outs}{The list of vectors of outputs of the last layer in the network}

\item{epochs}{How many rounds of training to run}

\item{tax}{This is the learning rate, aka eta}

\item{maxErr}{A contition to early stop the training process}
}
\value{
The computed value using the McCullochPitts model.

Vector of computed values of the same size of the last layer
}
\description{
The McCullochPitts neuron class, that implements the logic of the
McCullochPitts neuron model.
}
\section{Fields}{

\describe{
\item{\code{ws}}{The matrix of weights that multiply the input vector, it can be a
vector, a matrix or an array.}

\item{\code{bias}}{The bias value.}
}}


\examples{
# Create a dataset
dataset <- iris
dataset$Petal.Length <- NULL
dataset$Petal.Width <- NULL
dataset <- dataset[dataset$Species != "versicolor",]
dataset$Code <- as.integer(dataset$Species == "virginica")
dataset <- dataset[sample(20),]

# Create the neuron
neuron <- mcCullochPitts(c(1,1), 1)

# Train the neuron, takes a while
neuron$train(dataset[,c(1,2)], dataset[,'Code', drop=FALSE], epochs = 10)

# Check the output
neuron$output(c(1,2))

# See accuracy
dataset$Calc <- sapply(1:nrow(dataset), function(x) {
    as.integer(neuron$output(dataset[x,c(1,2)]))
})
length(which(dataset$Code==dataset$Calc))/nrow(dataset)

}
