% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{dptriml_s}
\alias{dptriml_s}
\title{Automatically trim a list of density profiles on the starting side}
\usage{
dptriml_s(dp.list, rreport = FALSE, cl = 1, ...)
}
\arguments{
\item{dp.list}{A list of dp objects, see \code{dpload}}

\item{rreport}{Return an embedded report on automatic trim success,
mandatory when using \code{correct_failures} to manually pick
starting/ending.}

\item{cl}{Number of cores to run the trimming in parallel, passed
through to \code{pbapply}.}

\item{...}{Parameters minseglen, span and nroll, will get passed through
to dpdetect_s, adjust when profile resolution is not 1/100 of a millimeter.}
}
\value{
A list of trimmed dp objects. When rreport = TRUE, it
  return a two-item list of (i) trimmed dp objects and (ii)
  trimming report data frame.
}
\description{
Calls \code{dptrim} on a list of dp objects and returns a list of
trimmed objects. If automatic detection fails, the dp objects are
not trimmed. Can be run in parallel on multiple cores, this speeds
up the trimming process significantly. Only trims the starting
side, see \code{dptriml} for trimming both side simultaneously.
}
\examples{
\donttest{
## load several dp files
dp.list <- dpload(dp.directory = system.file("extdata", package = "densitr"))
## trim the measurements
dp.trimmed <- dptriml_s(dp.list)
}
}
\seealso{
dptrim, dptrim_s, dptriml_s,
}
