% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_p.R
\name{adjust_p}
\alias{adjust_p}
\alias{adjust_p.tidy_summary}
\title{Adjust P-values}
\usage{
adjust_p(x, method)

\method{adjust_p}{tidy_summary}(x, method = "BH")
}
\arguments{
\item{x}{a \code{\link{tidy_summary}} object.}

\item{method}{(chr, default = "BH") a valid method for
\code{\link[stats]{p.adjust}}}
}
\value{
a \code{\link{tidy_summary}} object with the Ps adjusted
}
\description{
Adjust P-values of a \code{\link{tidy_summary}} object
}
\examples{
\donttest{
  library(Hmisc)
  my_summary <- summary(Species ~ ., data = iris,
    method = "reverse",
    test = TRUE
  )

  tidy_summary(my_summary, prtest = "P") \%>\%
    adjust_p()
}
}
