% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectBinary.R
\name{detectBinary}
\alias{detectBinary}
\title{Change point detection using PCA and binary segmentation}
\usage{
detectBinary(
  Y,
  Del,
  L,
  q = "fixed",
  alpha = 0.05,
  nboot = 199,
  n.cl,
  bsize = "log",
  bootTF = TRUE,
  scaleTF = TRUE,
  diagTF = TRUE,
  plotTF = TRUE
)
}
\arguments{
\item{Y}{data: Y = length*dim}

\item{Del}{Delta away from the boundary restriction}

\item{L}{the number of factors}

\item{q}{methods in calculating long-run variance of the test statistic. Defaul is "andrew" "fixed" = length^{1/3} or user specify the length}

\item{alpha}{significance level of the test}

\item{nboot}{the number of bootstrap sample for pvalue. Defauls is 199.}

\item{n.cl}{number of cores in parallel computing. The default is (machine cores - 1)}

\item{bsize}{block size for the Block Wild Boostrapping. Default is log(length),  "sqrt" uses sqrt(length), "adaptive" deterines block size usign data dependent selection of Andrews}

\item{bootTF}{determine whether the threshold is calculated from bootstrap or asymptotic}

\item{scaleTF}{scale the variance into 1}

\item{diagTF}{include diagonal term of covariance matrix or not}

\item{plotTF}{Draw plot to see test statistic and threshold}
}
\value{
\strong{tstathist} The complete history of test tsatistic

\strong{Brhist} The sequence of breakspoints found from binay splitting

\strong{L} The number of factors used in the procedure

\strong{q} The estimated vecorized autocovariance on each regime.

\strong{crit} The critical vlaue to identify change point

\strong{bsize} The block size of the bootstrap

\strong{diagTF} If TRUE, the diagonal entry of covariance matrix is used in detecting connectivity changes.

\strong{bootTF} If TRUE, boostrap is used to find critical value

\strong{scaleTF} If TRUE, the multivariate signal is studentized to have zero mean and unit variance.
}
\description{
This function uses PCA-based method to find breaks. Simultaneous breaks are found from binary segmentation.
}
\examples{
\donttest{out3= detectBinary(changesim, L=2, n.cl=1)}
}
