% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffr.R
\name{diffrOutput}
\alias{diffrOutput}
\alias{renderDiffr}
\title{Wrapper functions for using diffr in shiny}
\usage{
diffrOutput(outputId, width = "100\%", height = "400px")

renderDiffr(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{Output variable to read from}

\item{width, height}{The width and height of the diff (see
\code{\link[htmlwidgets]{shinyWidgetOutput}})}

\item{expr}{An expression that generates a \code{\link{diffr}} object}

\item{env}{The environment in which to evaluate \code{expr}}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
  is useful if you want to save an expression in a variable.

Widget output function for use in Shiny}
}
\description{
Use \code{diffrOutput} to create a UI element, and \code{renderDiffr}
to render the diff.
}
\examples{
\donttest{
library(diffr)
library(shiny)
file1 = tempfile()
writeLines("hello, world!\\n", con = file1)
file2 = tempfile()
writeLines(paste0(
"hello world?\\nI don't get it\\n",
paste0(sample(letters, 65, replace = TRUE), collapse = "")), con = file2)

ui <- fluidPage(
  h1("A diffr demo"),
  checkboxInput("wordWrap", "Word Wrap",
     value = TRUE),
   diffrOutput("exdiff")
)

server <- function(input, output, session) {
  output$exdiff <- renderDiffr({
    diffr(file1, file2, wordWrap = input$wordWrap,
    before = "f1", after = "f2")
  })
}

shinyApp(ui, server)
}
}
