% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_chunk_ids.r
\name{get_chunk_ids}
\alias{get_chunk_ids}
\title{Get the chunk IDs and files names}
\usage{
get_chunk_ids(df, ..., full.names = FALSE, strip_extension = TRUE)
}
\arguments{
\item{df}{a disk.frame}

\item{...}{passed to list.files}

\item{full.names}{If TRUE returns the full path to the file, Defaults to FALSE}

\item{strip_extension}{If TRUE then the file extension in the chunk_id is removed. Defaults to TRUE}
}
\description{
Get the chunk IDs and files names
}
\examples{
cars.df = as.disk.frame(cars)

# return the integer-string chunk IDs
get_chunk_ids(cars.df)

# return the file name chunk IDs
get_chunk_ids(cars.df, full.names = TRUE)

# return the file name chunk IDs with file extension
get_chunk_ids(cars.df, strip_extension = FALSE)

# clean up cars.df
delete(cars.df)
}
