% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aggregateData.R
\name{aggregateData}
\alias{aggregateData}
\title{Averages photographs of the same type}
\usage{
aggregateData(projectName, varFunc = "se", replicate = c("line", "type"),
  overwrite = TRUE, save = TRUE)
}
\arguments{
\item{projectName}{the short name in use for the project.}

\item{varFunc}{what type of variation measurment to perform. Currently supports \code{varFunc} = "se" to calculate the standard error, \code{varFun} = "cv" to calculate the coefficient of variation or any built-in R function (e.g., sd).}

\item{replicate}{a character vector indicating which the column names that contain which factors to use. Defaults to c("line", "type"). Note that if the typeVector name was changed in \code{createDataframe} this should be reflected here.}

\item{overwrite}{a logical value indicating whether to overwrite existing aggregate dataframe for the same project name. This allows you to save different dataframes averaging across different factors or using different variance measures}

\item{save}{denotes whether to overwrite the existing .csv file or just update the .df in the R global environment. Defaults to TRUE.}
}
\value{
A dataframe "projectName.ag" is saved to the global environment and a .csv file "projectName_ag.csv" is exported to the "parameter_files" directory.
}
\description{
Uses a user-supplied variance measure (currently supported: standard error, coefficient of variation, built-in R functions (e.g., sd) to calculate variance among photographs of the same type
}
\examples{
\dontrun{
aggregateData("myProject")
aggregateData("myProject", varFunc= "sd", replicate = c("line", "drugAmt"), overwrite = FALSE)
}
}
\seealso{
\code{\link{addType}} if there multiple factors in your experiment. Add whatever the new factor is called (default: "type2") to the replicate vector if this is appropriate.
}

