% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflowPartialMatch.R
\name{workflowPartialMatch}
\alias{workflowPartialMatch}
\title{Finds the section in a long sequence that better matches a short sequence.}
\usage{
workflowPartialMatch(
  sequences = NULL,
  grouping.column = NULL,
  time.column = NULL,
  exclude.columns = NULL,
  method = "manhattan",
  diagonal = FALSE,
  paired.samples = FALSE,
  min.length = NULL,
  max.length = NULL,
  ignore.blocks = FALSE,
  parallel.execution = TRUE
  )
}
\arguments{
\item{sequences}{dataframe with multiple sequences identified by a grouping column generated by \code{\link{prepareSequences}}.}

\item{grouping.column}{character string, name of the column in \code{sequences} to be used to identify separates sequences within the file.}

\item{time.column}{character string, name of the column with time/depth/rank data.}

\item{exclude.columns}{character string or character vector with column names in \code{sequences} to be excluded from the analysis.}

\item{method}{character string naming a distance metric. Valid entries are: "manhattan", "euclidean", "chi", and "hellinger". Invalid entries will throw an error.}

\item{diagonal}{boolean, if \code{TRUE} (default), diagonals are included in the computation of the least cost path. This is the best option if the user suspects that a given segment in the short sequence might be identical to the short sequence.}

\item{paired.samples}{boolean, if \code{TRUE}, the sequences are assumed to be aligned, and distances are computed for paired-samples only (no distance matrix required). Default value is \code{FALSE}.}

\item{min.length}{integer, minimum length (in rows) of the subsets of the long sequence to be matched against the short sequence. If \code{NULL} (default), the subset of the long sequence to be matched will thave the same number of samples as the short sequence.}

\item{max.length}{integer, maximum length (in rows) of the subsets of the long sequence to be matched against the short sequence. If \code{NULL} (default), the subset of the long sequence to be matched will thave the same number of samples as the short sequence.}

\item{ignore.blocks}{boolean. If \code{TRUE}, the function \code{\link{leastCostPathNoBlocks}} analyzes the least-cost path of the best solution, and removes blocks (straight-orthogonal sections of the least-cost path), which happen in highly dissimilar sections of the sequences, and inflate output psi values.}

\item{parallel.execution}{boolean, if \code{TRUE} (default), execution is parallelized, and serialized if \code{FALSE}.}
}
\value{
A dataframe with three columns:
\itemize{
\item \emph{first.row} first row of the segment in the long sequence matched against the short one.
\item \emph{last.row} last row of the segment in the long sequence matched against the short one.
\item \emph{psi} psi values, ordered from lower (máximum similarity / minimum dissimilarity) to higher.
}
}
\description{
This workflow works under the following scenario: the user has a short sequence, and a long sequence, and has the objective of finding the segment in the long sequence that better matches the short sequence. The function identifies automatically the short and the long sequence, but throws an error if more than two sequences are introduced. The lengths of the segments in the long sequence to be compared with the long sequence are defined through the arguments \code{min.length} and \code{max.length}. If left empty, \code{min.length} and \code{max.length} equal 0, meaning that the segment to be searched for will have the same number of cases as the short sequence. Note that this is a brute force algorithm, can have a large memory footpring if the interval between \code{min.length} and \code{max.length} is too long. It might be convenient to pre-check the number of iterations to be performed by computing \code{sum(nrow(long.sequence) - min.length:max.length) + 1}. The algorithm is parallelized and optimized as possible, so still, large searches are possible.
}
\examples{

\donttest{

#loading the data
data(sequencesMIS)

#removing grouping column
sequencesMIS$MIS <- NULL

#mock-up short sequence
MIS.short <- sequencesMIS[1:10, ]

#mock-up long sequence
MIS.long <- sequencesMIS[1:30, ]

#preparing sequences
MIS.sequences <- prepareSequences(
 sequence.A = MIS.short,
 sequence.A.name = "short",
 sequence.B = MIS.long,
 sequence.B.name = "long",
 grouping.column = "id",
 transformation = "hellinger"
 )

#matching sequences
#min.length and max.length are
#minimal to speed up execution
MIS.psi <- workflowPartialMatch(
 sequences = MIS.sequences,
 grouping.column = "id",
 time.column = NULL,
 exclude.columns = NULL,
 method = "manhattan",
 diagonal = FALSE,
 parallel.execution = FALSE
 )

#output dataframe
MIS.psi

}

}
\author{
Blas Benito <blasbenito@gmail.com>
}
