% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnorm.R
\name{lnorm}
\alias{lnorm}
\alias{mlnorm}
\title{The Lognormal distribution}
\usage{
mlnorm(r = 0, truncation = 0, meanlog = -0.5, sdlog = 0.5, lower.tail = TRUE)
}
\arguments{
\item{r}{rth raw moment of the distribution, defaults to 1.}

\item{truncation}{lower truncation parameter, defaults to 0.}

\item{meanlog, sdlog}{mean and standard deviation of the distribution on the log scale with default values of 0 and 1 respectively.}

\item{lower.tail}{logical; if TRUE (default), moments are \eqn{E[x^r|X \le y]}, otherwise, \eqn{E[x^r|X > y]}}
}
\value{
Provides the y-bounded, rth raw moment of the distribution.
}
\description{
Raw moments for the Lognormal distribution.
}
\details{
Probability and Cumulative Distribution Function:

 \deqn{f(x) = \frac{1}{{x Var \sqrt {2\pi } }}e^{- (lnx - \mu  )^2/ 2Var^2} , \qquad F_X(x) = \Phi(\frac{lnx- \mu}{Var})}

 The y-bounded r-th raw moment of the Lognormal distribution equals:

 \deqn{\mu^r_y =  e^{\frac{r (rVar^2 + 2\mu)}{2}}[1-\Phi(\frac{lny - (rVar^2 + \mu)}{Var})]  }
}
\examples{

## The zeroth truncated moment is equivalent to the probability function
plnorm(2, meanlog = -0.5, sdlog = 0.5)
mlnorm(truncation = 2)

## The (truncated) first moment is equivalent to the mean of a (truncated) random sample,
#for large enough samples.
x <- rlnorm(1e5, meanlog = -0.5, sdlog = 0.5)
mean(x)
mlnorm(r = 1, lower.tail = FALSE)

sum(x[x > quantile(x, 0.1)]) / length(x)
mlnorm(r = 1, truncation = quantile(x, 0.1), lower.tail = FALSE)
}
