% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{schema}
\alias{schema}
\alias{schema.number_line}
\alias{schema.epid}
\alias{schema.pane}
\alias{schema.pid}
\title{Schema diagram for linked records in \code{diyar}}
\usage{
schema(x, ...)

\method{schema}{number_line}(x, show_labels = c("date", "case_overlap_methods"), ...)

\method{schema}{epid}(
  x,
  title = NULL,
  show_labels = c("length_arrow"),
  show_skipped = TRUE,
  show_non_finite = FALSE,
  theme = "dark",
  seed = NULL,
  custom_label = NULL,
  ...
)

\method{schema}{pane}(
  x,
  title = NULL,
  show_labels = c("window_label"),
  theme = "dark",
  seed = NULL,
  custom_label = NULL,
  ...
)

\method{schema}{pid}(
  x,
  title = NULL,
  show_labels = TRUE,
  theme = "dark",
  orientation = "by_pid",
  seed = NULL,
  custom_label = NULL,
  ...
)
}
\arguments{
\item{x}{\code{[\link[=number_line-class]{number_line}|\link[=epid-class]{epid}|\link[=pid-class]{pid}|\link[=pane-class]{pane}]}}

\item{...}{Other arguments.}

\item{show_labels}{\code{[logical|character]}. Show/hide certain parts of the schema. See \code{Details}.}

\item{title}{\code{[character]}. Plot title.}

\item{show_skipped}{\code{[logical]}. Show/hide \code{"Skipped"} records.}

\item{show_non_finite}{\code{[logical]}. Show/hide records with non-finite \code{date} values.}

\item{theme}{\code{[character]}. Options are \code{"dark"} or \code{"light"}.}

\item{seed}{\code{[integer]}. See \code{set.seed}. Used to get a consistent arrangement of items in the plot.}

\item{custom_label}{\code{[character]}. Custom label for each record of the identifier.}

\item{orientation}{\code{[character]}. Show each record of a \code{pid} object within its group id (\code{"by_pid"}) or its \code{pid_cri} (\code{"by_pid_cri"})}
}
\value{
\code{ggplot} objects
}
\description{
Create schema diagrams for \code{\link[=number_line-class]{number_line}}, \code{\link[=epid-class]{epid}}, \code{\link[=pid-class]{pid}} and \code{\link[=pane-class]{pane}} objects.
}
\details{
A visual aid to describe the data linkage (\code{\link{links}}), episode tracking (\code{\link{episodes}}) or partitioning process (\code{\link{partitions}}).

\bold{\code{show_labels} options (multi-select)}
\itemize{
\item schema.epid - \bold{TRUE}, \bold{FALSE}, "sn", "epid", "date", "case_nm", "wind_nm", "length", "length_arrow", "case_overlap_methods" or "recurrence_overlap_methods"
\item schema.pane - \bold{TRUE}, \bold{FALSE}, "sn", "pane", "date", "case_nm" or "window_label"
\item schema.pid - \bold{TRUE}, \bold{FALSE}, "sn" or "pid"
}
}
\examples{
schema(number_line(c(1, 2), c(2, 1)))

schema(episodes(1:10, 2))

schema(partitions(1:10, by = 2, separate = TRUE))

schema(links(list(c(1, 1, NA, NA), c(NA, 1, 1, NA))))

}
