% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fund-cycles.R
\name{dodgr_fundamental_cycles}
\alias{dodgr_fundamental_cycles}
\title{dodgr_fundamental_cycles}
\usage{
dodgr_fundamental_cycles(
  graph,
  vertices = NULL,
  graph_max_size = 10000,
  expand = 0.05
)
}
\arguments{
\item{graph}{\code{data.frame} or equivalent object representing the contracted
network graph (see Details).}

\item{vertices}{\code{data.frame} returned from \link{dodgr_vertices}\code{(graph)}.
Will be calculated if not provided, but it's quicker to pass this if it has
already been calculated.}

\item{graph_max_size}{Maximum size submitted to the internal C++ routines as
a single chunk. Warning: Increasing this may lead to computer meltdown!}

\item{expand}{For large graphs which must be broken into chunks, this factor
determines the relative overlap between chunks to ensure all cycles are
captured. (This value should only need to be modified in special cases.)}
}
\value{
List of cycle paths, in terms of vertex IDs in \code{graph} and, for
spatial graphs, the corresponding coordinates.
}
\description{
Calculate fundamental cycles in a graph.
}
\note{
Calculation of fundamental cycles is VERY computationally demanding,
and this function should only be executed on CONTRACTED graphs (that is,
graphs returned from \link{dodgr_contract_graph}), and even than may take a
long time to execute. Results for full graphs can be obtained with the
function \link{dodgr_full_cycles}. The computational complexity can also not
be calculated in advance, and so the parameter \code{graph_max_size} will lead to
graphs larger than that (measured in numbers of edges) being cut into smaller
parts. (Note that that is only possible for spatial graphs, meaning that it
is not at all possible to apply this function to large, non-spatial graphs.)
Each of these smaller parts will be expanded by the specified amount
(\code{expand}), and cycles found within. The final result is obtained by
aggregating all of these cycles and removing any repeated ones arising due to
overlap in the expanded portions. Finally, note that this procedure of
cutting graphs into smaller, computationally manageable sub-graphs provides
only an approximation and may not yield all fundamental cycles.
}
\examples{
net <- weight_streetnet (hampi)
graph <- dodgr_contract_graph (net)
verts <- dodgr_vertices (graph)
cyc <- dodgr_fundamental_cycles (graph, verts)
}
\seealso{
Other misc: 
\code{\link{compare_heaps}()},
\code{\link{dodgr_flowmap}()},
\code{\link{dodgr_full_cycles}()},
\code{\link{dodgr_insert_vertex}()},
\code{\link{dodgr_sample}()},
\code{\link{dodgr_sflines_to_poly}()},
\code{\link{dodgr_vertices}()},
\code{\link{match_points_to_graph}()},
\code{\link{match_pts_to_graph}()},
\code{\link{merge_directed_graph}()},
\code{\link{summary.dodgr_dists_categorical}()},
\code{\link{write_dodgr_wt_profile}()}
}
\concept{misc}
