% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crd.R
\name{crd}
\alias{crd}
\title{Analysis of Completely Randomized Design}
\usage{
crd(data, trt.vector, MultipleComparisonTest)
}
\arguments{
\item{data}{dependent variables}

\item{trt.vector}{vector containing treatments}

\item{MultipleComparisonTest}{0 for no test, 1 for LSD test, 2 for Duncan test and 3 for HSD test}
}
\value{
ANOVA, interpretation of ANOVA, R-square, normality test result, SEm, SEd and multiple comparison test result
}
\description{
The function gives ANOVA, R-square of the model, normality testing of residuals, SEm (standard error of mean), SEd (standard error of difference), interpretation of ANOVA results and multiple comparison test for means
}
\examples{
data<-data.frame(Treatments=c("T1","T2","T3","T4","T5","T6","T7","T1","T2","T3","T4","T5","T6",
"T7","T1","T2","T3","T4","T5","T6","T7"),
yield=c(25,21,21,18,25,28,24,25,24,24,16,21,20,17,16,19,14,15,13,11,25),
height=c(130,120,125,135,139,140,145,136,129,135,150,152,140,148,130,135,145,160,145,130,160))
#CRD analysis with LSD test for yield only
crd(data[2],data$Treatments,1)
#CRD analysis with LSD test for both yield and height
crd(data[2:3],data$Treatments,1)
}
