% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wmean_fn.R
\name{get_one_wmean}
\alias{get_one_wmean}
\title{Compute one weighted mean based on a given data set.}
\usage{
get_one_wmean(
  treat,
  covar,
  treat_form,
  out,
  out_levels,
  out_form,
  out_model,
  out_weights
)
}
\arguments{
\item{treat}{A \code{numeric} vector containing treatment status. Missing
values are not allowed unless the corresponding entry in \code{out} is also missing. 
Only values of 0 or 1 are treated as actual treatment levels. Any other value is assumed 
to encode a value for which the outcome is missing and the corresponding outcome value is 
ignored.}

\item{covar}{A \code{data.frame} containing the covariates to include in the working
proportional odds model.}

\item{treat_form}{The right-hand side of a regression formula for the working model of
treatment probability as a function of covariates}

\item{out}{A \code{numeric} vector containing the outcomes. Missing outcomes are 
allowed.}

\item{out_levels}{A \code{numeric} vector containing all ordered levels of the 
outcome.}

\item{out_form}{The right-hand side of a regression formula for the working proportional 
odds model. NOTE: THIS FORMULA MUST NOT SUPPRESS THE INTERCEPT.}

\item{out_model}{Which R function should be used to fit the proportional odds 
model. Options are \code{"polr"} (from the \code{MASS} package), 
"vglm" (from the \code{VGAM} package), or \code{"clm"} (from the \code{ordinal} package).}

\item{out_weights}{A vector of \code{numeric} weights with length equal to the length 
of \code{out_levels}.}
}
\description{
Compute one weighted mean based on a given data set.
}
