% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_table.R
\name{find_table}
\alias{find_table}
\alias{find_dec_table}
\alias{find_acs_table}
\title{Find a decennial or ACS census table with variables of interest}
\usage{
find_dec_table(..., show = 2)

find_acs_table(..., show = 4)
}
\arguments{
\item{...}{Variables to look for. These can be length-1 character vectors,
or, for convenience, can be left unquoted (see examples).}

\item{show}{How many matching tables to show. Increase this to show more
possible matches, at the cost of more output. Negative values will be
converted to positive but will suppress any printing.}
}
\value{
The codes for the top \code{show} tables, invisibly.
}
\description{
This function uses fuzzy matching to help identify tables from the census
which contain variables of interest. Matched table codes are printed out,
along with the Census-provided table description, the parsed variable names,
and example table cells. The website \url{https://censusreporter.org/} may also
be useful in finding variables.
}
\examples{
find_dec_table("sex", "age")
find_dec_table(tenure, race)
find_acs_table("income", "sex", show=3)
find_acs_table("heath care", show=-1)

}
