% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{cva}
\alias{cva}
\title{Compute average coverage critical value under moment constraints.}
\usage{
cva(m2, kappa = Inf, alpha = 0.05, check = TRUE)
}
\arguments{
\item{m2}{Bound on second moment of the normalized bias, \eqn{m_{2}}{m_2}}

\item{kappa}{Bound on the kurtosis of the normalized bias,
\eqn{\kappa}{kappa}}

\item{alpha}{Determines confidence level, \eqn{1-\alpha}{1-alpha}.}

\item{check}{If \code{TRUE}, verify accuracy of the solution by checking that
the implied least favorable distribution satisfies the \code{m2} and
\code{kappa} constraints and yields the same non-coverage rate. If this
fails (perhaps due to numerical accuracy issues), solve a finite-grid
approximation (by discretizing the support of the normalized bias) to the
primal linear programming problem, and check that it agrees with the dual
solution.}
}
\value{
Returns a list with 4 components: \describe{

\item{\code{cv}}{Critical value for constructing two-sided confidence
intervals.}

\item{\code{alpha}}{The argument \code{alpha}.}

\item{\code{x}}{Support points for the least favorable distribution for the
squared normalized bias, \eqn{b^2}.}

\item{\code{p}}{Probabilities associated with the support points.}

}
}
\description{
Computes the critical value \eqn{cva_{\alpha}(m_{2}, \kappa)}{cva_alpha(m_2,
kappa)} from Armstrong, Kolesár, and Plagborg-Møller (2020).
}
\examples{
# Usual critical value
cva(m2=0, kappa=Inf, alpha=0.05)
# Larger critical value that takes bias into account. Only uses second moment
# constraint on normalized bias.
cva(m2=4, kappa=Inf, alpha=0.05)
# Add a constraint on kurtosis. This tightens the critical value.
cva(m2=4, kappa=3, alpha=0.05)
}
\references{
{

\cite{Armstrong, Timothy B., Kolesár, Michal, and Plagborg-Møller, Mikkel
(2020): Robust Empirical Bayes Confidence Intervals,
\url{https://arxiv.org/abs/2004.03448}}

}
}
