% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ecotoxicology.R
\name{ProbitWeightingCoef}
\alias{ProbitWeightingCoef}
\title{Calculate the weighting coefficient}
\usage{
ProbitWeightingCoef(Z, Q, P, C)
}
\arguments{
\item{Z}{numeric, ordinate to the normal distribution corresponding to the probability P}

\item{Q}{numeric, 1-P}

\item{P}{numeric, Probability P of expected probit}

\item{C}{numeric, proportion of natural mortality}
}
\value{
the weighting coefficient
}
\description{
Returns the weighting coefficient
}
\examples{
# Example from page 90 of Finney 1964:
# expected probit Y = 6.2, control mortality C = 59\%
Y <- 6.2
C <- 0.59
P <- pnorm(Y-5)
Q <- 1-P
Z <- ProbitZ(Y)
# weighting coefficient = 0.141
ProbitWeightingCoef(Z,Q,P,C)
}
\author{
Jose Gama
}
\references{
Finney D. J., 1964
Probit analysis: a statistical treatment of the sigmoid response curve.
Cambridge University Press. Formula 6.3.
}

