% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diminishing_returns.R
\name{dose_of_diminishing_returns}
\alias{dose_of_diminishing_returns}
\alias{dose_for_criterion}
\title{Calculate the dose of diminishing return}
\usage{
dose_of_diminishing_returns(
  dose,
  DOC_final,
  molar_mass = 297,
  threshold = 0.3/10
)

dose_for_criterion(dose, DOC_final, criterion)
}
\arguments{
\item{dose}{The coagulant dose (mmol/L).}

\item{DOC_final}{The final DOC concentration, probably modeled using \code{\link[=fit_edwards_optim]{fit_edwards_optim()}}
or \code{\link[=fit_edwards]{fit_edwards()}} and \code{\link[=coagulate_grid]{coagulate_grid()}}.}

\item{molar_mass}{The moalr mass of the coagulant, in grams per mol Al or Fe.}

\item{threshold}{The point of diminishing return threshold, in mg/L DOC per mg/L dose.
Often this is taken to be 0.3 mg/L DOC per 10 mg/L dose (Brantby 2016).}

\item{criterion}{A desired final DOC concentration in mg/L}
}
\value{
The dose (in mmol/L) of diminishing returns.
}
\description{
Calculate the dose of diminishing return
}
\examples{
dose_curve <- coagulate_grid(fit_edwards("Low DOC"), DOC = 4, UV254 = 0.2, pH = 5.5)
dose_of_diminishing_returns(dose_curve$dose, dose_curve$DOC_final)
dose_for_criterion(dose_curve$dose, dose_curve$DOC_final, criterion = 3)

}
\references{
Bratby, J. 2016. Coagulation and Flocculation in Water and Wastewater Treatment.
IWA Publishing. https://books.google.ca/books?id=PabQDAAAQBAJ
}
