% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_performance.R
\name{beta_var}
\alias{beta_var}
\title{Standard Deviation of Estimated Coefficients}
\usage{
beta_var(df)
}
\arguments{
\item{df}{A data frame of replicated simulations which must include columns
titled "Estimate" and "Std.Error".}
}
\value{
A data frame of the variance across all values of beta hat
   and the mean variance of the beta hats
}
\description{
Measures the variance of the point estimates of the estimated log relative risk
(\eqn{\hat{beta}}{b}) over the \code{n_rep} simulations and the mean of
the variances of each \eqn{\hat{\beta}}{b}.
}
\examples{
sims <- create_sims(n_reps = 10, n = 600, central = 100,
                    sd = 10, exposure_type = "continuous",
                    exposure_trend = "cos1",
                    exposure_amp = 0.6,
                    average_outcome = 20,
                    outcome_trend = "no trend",
                    rr = 1.01)
fits <- fit_mods(data = sims, custom_model = spline_mod,
                 custom_model_args  = list(df_year = 1))
beta_var(fits)

}
