% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathjax_node_setup.R
\name{mathjax_install}
\alias{mathjax_install}
\title{Install 'mathjax-node'}
\usage{
mathjax_install(force = FALSE, verbose = TRUE)
}
\arguments{
\item{force}{Whether to force to install (override) 'mathjax-node'.}

\item{verbose}{should a log be printed in the console, default to TRUE.}
}
\value{
a single logical value, FALSE if the operation
failed, TRUE otherwise.
}
\description{
Downloads and installs 'mathjax-node'
(APIs to call MathJax from node.js programs) in the user-specific
data directory managed with \code{\link[=R_user_dir]{R_user_dir()}}.

Please note that the total size of the downloaded files is about 70 MB.

This data directory can be removed from the computer
with command \code{\link[=mathjax_uninstall]{mathjax_uninstall()}}.
}
\examples{
library(locatexec)
if(exec_available("node") && !mathjax_available()){
  mathjax_install()
  mathjax_uninstall()
}
}
\seealso{
Other tools for 'mathjax-node': 
\code{\link{mathjax_available}()},
\code{\link{mathjax_uninstall}()}
}
\concept{tools for 'mathjax-node'}
