% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_mathjax.R
\name{transform_mathjax}
\alias{transform_mathjax}
\title{'MathJax' equation as 'SVG' or 'MathML'.}
\usage{
transform_mathjax(x, to = "svg")
}
\arguments{
\item{x}{MathJax equations}

\item{to}{output format, one of 'svg' or 'mml'}
}
\value{
a character vector that contains 'svg' or 'mml'
codes corresponding to the equations.
}
\description{
Get 'SVG' or 'MathML' XML codes corresponding to the rendering
of 'MathJax' equations.

This function can only be used if the command
\code{\link[=mathjax_install]{mathjax_install()}} has been executed once (it installs
a set of "npm" packages on your machine).
}
\examples{
library(locatexec)
if(exec_available("node") && mathjax_available()){
  x <- c("(ax^2 + bx + c = 0)",
         "x = {-b \\\\pm \\\\sqrt{b^2-4ac} \\\\over 2a}.")
  z <- transform_mathjax(x = x, to = "svg")
  cat(z, sep = "\n\n")
  z <- transform_mathjax(x = x, to = "mml")
  cat(z, sep = "\n\n")
}
}
