% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_expSubset.R
\name{expSubset}
\alias{expSubset}
\title{Obtains a subset of an experiment matching the given conditions}
\usage{
expSubset(e, columns, invertSelection = FALSE)
}
\arguments{
\item{e}{The experiment to be subsetted}

\item{columns}{A named list containing the variables to be filtered and the
valid values.}

\item{invertSelection}{If the filtering must match the inversion of the
specified conditions.}
}
\value{
a filtered experiment object
}
\description{
This function receives a named list indicating variables and values to filter
the input experiment.
}
\details{
The names of the elements in the list correspond with the variables to be
filtered, indicating either the methos or problem variables as well as
parameters. The values of the list correspond with the valid states for the
filtering.
}
\examples{
# We create a new experiment from the wekaExperiment problem
e <- expCreate(wekaExperiment, parameters="fold", name="Test Experiment")

# We can filter the experiment to reduce the number of methods.
e <- expSubset(e, list(method = c("J48", "NaiveBayes")))
e

# We can filter the experiment to remove a given problem
e <- expSubset(e, list(problem = "iris"), invertSelection=TRUE)
e

# We can subset the experiment to obtain a specific parameter configuration
e <- expSubset(e, list("featureSelection" = "no"))
e
}

