% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_plotRankDistribution.R
\name{plotRankDistribution}
\alias{plotRankDistribution}
\title{Boxplot for the ranks distribution and control hypotheses from multiple test}
\usage{
plotRankDistribution(testMultiple)
}
\arguments{
\item{testMultiple}{The statistical test from which the plot is generated.
The functions accepts either control and pairwise multiple tests.}
}
\value{
an experiment object
}
\description{
This function generates a boxplot from a testMultiple statistical test
showing the ordered distrubution of rankings for each method computed for
the Friedman test. If the input test features a control multiple comparison
then the rejected hypotheses by the Holm methd are also indicates in the plot.
}
\examples{
# First we create an experiment from the wekaExperiment problem and prepare
# it to apply the test:
experiment <- expCreate(wekaExperiment, name="test", parameter="fold")
experiment <- expReduce(experiment, "fold", mean)
experiment <- expSubset(experiment, list(featureSelection = "yes"))
experiment <- expInstantiate(experiment, removeUnary=TRUE)

# Then we perform a Friedman test included ina a testMultipleControl
# test procedure
test <- testMultipleControl(experiment, "accuracy")

# Finally we obtain the plot
plotRankDistribution(test)
cat()
}

